/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.mfsearch;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JOptionPane;
import nl.mpi.annot.search.lib.HitField;
import nl.mpi.annot.search.lib.SearchHit;
import nl.mpi.annot.search.mfsearch.HitStats;
import nl.mpi.annot.search.mfsearch.SaverBasics;
import nl.mpi.annot.search.mfsearch.SearchMediator;

public class SaverHitStatistics
extends SaverBasics {
    private DecimalFormat format2 = new DecimalFormat("#0.###", new DecimalFormatSymbols(Locale.US));
    private final String _sep = "\t";
    private final int _stepSize = 10;
    private final boolean _distinguishHitValues;
    private final boolean _includeFileName;
    private final boolean _includeFilePath;
    private final boolean _msFormat;
    private final File _saveFile;
    private final int _nToBeSaved;

    public SaverHitStatistics(File file, int hitCount, SearchMediator mediator, String queryId, boolean distinguishHits, boolean inclFileName, boolean inclFilePath, boolean unitMsec) {
        super(mediator, queryId);
        this._distinguishHitValues = distinguishHits;
        this._includeFileName = inclFileName;
        this._includeFilePath = inclFilePath;
        this._msFormat = unitMsec;
        this._saveFile = file;
        this._nToBeSaved = hitCount;
    }

    @Override
    public void run() {
        try {
            BufferedWriter out = SaverHitStatistics.writeSaveFile(this._saveFile);
            if (this._includeFileName) {
                out.write("\"TranscriptionName\"\t");
            }
            if (this._distinguishHitValues) {
                out.write("\"Hit\"\t");
            }
            out.write("\"Occurrences\"\t\"TotalDuration\"\t\"MinDuration\"\t\"MaxDuration\"\t\"AverageDuration\"\t\"MedianDuration\"");
            if (this._includeFilePath) {
                out.write("\t\"TranscriptionPath\"");
            }
            out.newLine();
            out.newLine();
            ArrayList<SearchHit> hitsPerFile = new ArrayList<SearchHit>();
            ArrayList<String> filesWithHits = new ArrayList<String>();
            String curFilePath = null;
            for (int i = 0; i < this._nToBeSaved && this.getSaving(); i += 10) {
                List<SearchHit> hits = this.getMediator().getHitsFromDatabase(i, 10, 0, this.getQueryId());
                for (int j = 0; j < hits.size(); ++j) {
                    this.setProgress((float)(i + j) / (float)this._nToBeSaved);
                    SearchHit hit = hits.get(j);
                    if (!hit.transcriptionName.equals(curFilePath)) {
                        this.writeHits(hitsPerFile, out);
                        hitsPerFile.clear();
                        hitsPerFile.add(hit);
                        filesWithHits.add(hit.transcriptionName);
                        curFilePath = hit.transcriptionName;
                    } else {
                        hitsPerFile.add(hit);
                    }
                    if (j != hits.size() - 1 || i + j != this._nToBeSaved - 1) continue;
                    this.writeHits(hitsPerFile, out);
                }
            }
            for (File file : this.getMediator().getDomainInfo(this.getQueryId())) {
                String filepath = file.getAbsolutePath();
                if (filesWithHits.contains(filepath)) continue;
                if (this._includeFileName) {
                    out.write(SaverHitStatistics.nameFromPath(filepath) + "\t");
                }
                if (this._distinguishHitValues) {
                    out.write("\t");
                }
                out.write("0\t0\t");
                out.write("0\t0\t");
                out.write("0\t0");
                if (this._includeFilePath) {
                    out.write("\t" + filepath);
                }
                out.newLine();
            }
            out.flush();
            out.close();
            if (this.getSaving()) {
                JOptionPane.showMessageDialog(null, "Ready saving hits", "Save Hit Statistics", 1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "Save Hit Statistics", 0);
        }
        this.cancel();
        this.setProgress(-1.0f);
    }

    private void writeHits(List<SearchHit> hitsPerFile, BufferedWriter out) throws IOException {
        Object hitRepres;
        if (hitsPerFile == null || hitsPerFile.size() == 0) {
            return;
        }
        HashMap<String, HitStats> hitMap = new HashMap<String, HitStats>();
        String transcriptionName = null;
        long divFactor = this._msFormat ? 1L : 1000L;
        for (int m = 0; m < hitsPerFile.size(); ++m) {
            HitStats stats;
            SearchHit hit2 = hitsPerFile.get(m);
            if (transcriptionName == null) {
                transcriptionName = hit2.transcriptionName;
            }
            hitRepres = this._distinguishHitValues ? ((HitField)((List)hit2.hitFields.get((int)0)).get((int)0)).annotation : "";
            long b = hit2.beginTime;
            long e = hit2.endTime;
            if (hit2.isComplex()) {
                boolean[][] cellsInUse = this.getMediator().getMatrixUsage(this.getQueryId());
                boolean firstNonEmptyFound = false;
                for (int k = 0; k < hit2.layerTiers.size(); ++k) {
                    for (int n = 0; n < ((List)hit2.hitFields.get(k)).size(); ++n) {
                        boolean doProcess;
                        HitField hitField = (HitField)((List)hit2.hitFields.get(k)).get(n);
                        boolean bl = cellsInUse != null ? cellsInUse[k][n] : (doProcess = hitField != null);
                        if (!doProcess) continue;
                        if (this._distinguishHitValues) {
                            String annotation = hitField.annotation;
                            hitRepres = !firstNonEmptyFound ? annotation : (String)hitRepres + "|" + annotation;
                        }
                        if (!firstNonEmptyFound && hitField != null) {
                            b = hitField.beginTime;
                            e = hitField.endTime;
                        }
                        firstNonEmptyFound = true;
                    }
                }
            }
            if ((stats = (HitStats)hitMap.get(hitRepres)) == null) {
                stats = new HitStats();
                hitMap.put((String)hitRepres, stats);
            }
            long duration = e - b;
            ++stats.numOcc;
            stats.minDur = duration < stats.minDur ? duration : stats.minDur;
            stats.maxDur = duration > stats.maxDur ? duration : stats.maxDur;
            stats.totalDur += duration;
            stats.firstOcc = b < stats.firstOcc ? b : stats.firstOcc;
            stats.durList.add(duration);
        }
        for (Map.Entry me : hitMap.entrySet()) {
            hitRepres = (String)me.getKey();
            HitStats stats = (HitStats)me.getValue();
            double averageDur = 0.0;
            if (stats.numOcc > 0) {
                averageDur = (double)stats.totalDur / (double)stats.numOcc;
            }
            Collections.sort(stats.durList);
            int numDurs = stats.durList.size();
            if (numDurs % 2 != 0) {
                stats.medianDur = stats.durList.get(numDurs / 2);
            } else {
                stats.medianDur = stats.durList.get(numDurs / 2);
                stats.medianDur += stats.durList.get(numDurs / 2 - 1).longValue();
                stats.medianDur /= 2L;
            }
            if (this._includeFileName) {
                out.write(SaverHitStatistics.nameFromPath(transcriptionName) + "\t");
            }
            if (this._distinguishHitValues) {
                out.write((String)hitRepres + "\t");
            }
            out.write(String.valueOf(stats.numOcc) + "\t");
            out.write(this.format2.format((double)stats.totalDur / (double)divFactor).replace(',', '.') + "\t");
            out.write(this.format2.format((double)stats.minDur / (double)divFactor).replace(',', '.') + "\t");
            out.write(this.format2.format((double)stats.maxDur / (double)divFactor).replace(',', '.') + "\t");
            out.write(this.format2.format((double)stats.totalDur / (double)stats.numOcc / (double)divFactor).replace(',', '.') + "\t");
            out.write(this.format2.format((double)stats.medianDur / (double)divFactor).replace(',', '.'));
            if (this._includeFilePath) {
                out.write("\t" + transcriptionName);
            }
            out.newLine();
        }
    }
}

