/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.mfsearch;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import nl.mpi.annot.search.lib.Constants;
import nl.mpi.annot.search.lib.FrequencyInfo;
import nl.mpi.annot.search.lib.HSQLDBQuery;
import nl.mpi.annot.search.lib.HitLayer;
import nl.mpi.annot.search.lib.SearchHit;
import nl.mpi.annot.search.lib.SearchQuery;
import nl.mpi.annot.search.lib.SearchStatistics;
import nl.mpi.annot.search.mfsearch.SearchApplication;
import nl.mpi.annot.search.mfsearch.SearchDomainPanel;
import nl.mpi.annot.search.mfsearch.SearchMediator;
import nl.mpi.annot.search.mfsearch.SearchPane;
import nl.mpi.annot.search.mfsearch.SearchResultPanel;

public class SearchApplicationMediator
implements SearchMediator {
    private static int queryIdCounter;
    private HSQLDBQuery lastCreatedQuery;
    private SearchApplication application;
    private SearchPane searchPane;
    private HashMap<String, HSQLDBQuery> queryForId;
    private HashMap<String, SearchDomainPanel> domainPanelForId;
    private HashMap<String, SearchResultPanel> resultPanelForId;
    private HashMap<String, ArrayList<SearchHit>> bufferedHitsForQuery;
    private HashMap<String, boolean[][]> matrixForId;
    private ArrayList<File> initialDomain;
    private JPanel dummyPanel;

    public SearchApplicationMediator(SearchApplication application, ArrayList<File> initialDomain) {
        this.application = application;
        this.initialDomain = initialDomain;
        new Constants();
        this.queryForId = new HashMap();
        this.domainPanelForId = new HashMap();
        this.resultPanelForId = new HashMap();
        this.bufferedHitsForQuery = new HashMap();
        this.matrixForId = new HashMap(6);
        this.dummyPanel = new JPanel();
    }

    @Override
    public void init() {
    }

    @Override
    public JComponent getSearchComponent() {
        if (this.searchPane == null) {
            this.searchPane = new SearchPane(this);
        }
        return this.searchPane;
    }

    @Override
    public String createQuery() {
        int queryId = queryIdCounter++;
        HSQLDBQuery query = new HSQLDBQuery(queryId);
        if (this.lastCreatedQuery == null) {
            query.setDomain(this.initialDomain);
        } else {
            query.setDomain(this.lastCreatedQuery);
        }
        this.lastCreatedQuery = query;
        this.queryForId.put("" + queryId, query);
        this.bufferedHitsForQuery.put("" + queryId, new ArrayList());
        return "" + queryId;
    }

    @Override
    public void doQuery(String encodedQuery, String queryId) {
        if (this.queryRunning()) {
            JOptionPane.showMessageDialog(null, "A new query can not start while another query is running", "Running query on other panel", 2);
            return;
        }
        ArrayList<SearchHit> bufferedHits = this.bufferedHitsForQuery.get(queryId);
        bufferedHits.clear();
        HSQLDBQuery query = this.queryForId.get(queryId);
        query.doQuery(encodedQuery);
    }

    @Override
    public void cancelQuery(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        query.cancelQuery();
    }

    @Override
    public void showInViewer(Object hit, String queryId) {
        if (hit == null) {
            return;
        }
        if (hit instanceof SearchHit) {
            this.showSearchHitInViewer((SearchHit)hit);
        } else if (hit instanceof FrequencyInfo) {
            this.showFrequencyHitInViewer((FrequencyInfo)hit, queryId);
        }
    }

    public void showSearchHitInViewer(SearchHit hit) {
        String filePath = hit.transcriptionName;
        String tierName = ((HitLayer)hit.layerTiers.get((int)0)).tierName;
        long beginTime = hit.beginTime;
        long endTime = hit.endTime;
        this.application.showInViewer(filePath, tierName, beginTime, endTime);
    }

    public void showFrequencyHitInViewer(FrequencyInfo freqInfo, String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        ArrayList parameters = query.getViewerParametersFor(freqInfo.annId, freqInfo.fileIndex);
        String filePath = (String)parameters.get(0);
        String tierName = (String)parameters.get(1);
        long beginTime = (Long)parameters.get(2);
        long endTime = (Long)parameters.get(3);
        this.application.showInViewer(filePath, tierName, beginTime, endTime);
    }

    @Override
    public void showInCorpusStructure(Object hit, String queryId) {
    }

    @Override
    public SearchStatistics getSearchStatistics(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getSearchStatistics();
    }

    public ArrayList<SearchHit> getHitsFromDatabase(int from, int count, int contextSize, String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getHits(from, count, contextSize);
    }

    @Override
    public List<SearchHit> getHits(int from, int count, int contextSize, String queryId) {
        int to;
        ArrayList<SearchHit> bufferedHits = this.bufferedHitsForQuery.get(queryId);
        if (from >= this.getSearchStatistics((String)queryId).nHits) {
            return bufferedHits.subList(0, 0);
        }
        int bufferSize = bufferedHits.size();
        if (from > bufferSize) {
            return this.getHitsFromDatabase(from, count, contextSize, queryId);
        }
        if (from + count > bufferSize) {
            int chunkSize = count + 1000;
            if (from + chunkSize > this.getSearchStatistics((String)queryId).nHits) {
                chunkSize = this.getSearchStatistics((String)queryId).nHits - from;
            }
            List hits = this.getHitsFromDatabase(bufferSize, chunkSize, contextSize, queryId);
            for (SearchHit hit : hits) {
                bufferedHits.add(hit);
            }
        }
        if ((to = 1 + from + count) > (bufferSize = bufferedHits.size())) {
            to = bufferSize;
        }
        return bufferedHits.subList(from, to);
    }

    public ArrayList<FrequencyInfo> getFrequencyInfo(int from, int count, String queryId, boolean sortByFreq) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getFrequencyInfo(from, count, sortByFreq);
    }

    private boolean queryRunning() {
        boolean running = false;
        for (HSQLDBQuery query : this.queryForId.values()) {
            if (!query.isRunning()) continue;
            return true;
        }
        return running;
    }

    @Override
    public void addDomainPanel(String queryId, SearchDomainPanel panel) {
        this.domainPanelForId.put(queryId, panel);
    }

    @Override
    public void addResultPanel(String queryId, SearchResultPanel panel) {
        this.resultPanelForId.put(queryId, panel);
    }

    @Override
    public void setQueryDomain(String domainTypes, String queryId) {
        if (this.queryRunning()) {
            JOptionPane.showMessageDialog(null, "The domain can not be changed while any query is running", "Running query on other panel", 2);
            return;
        }
        ArrayList oldDomain = this.queryForId.get(queryId).getDomain();
        ArrayList<File> newDomain = this.application.getDomain();
        if (newDomain == null || newDomain.equals(oldDomain)) {
            System.out.println("No new domain");
            return;
        }
        System.out.println("New domain: " + newDomain.size() + " nodes" + (String)(newDomain.size() > 0 ? ", " + newDomain.get(0) + " etc." : "."));
        this.queryForId.get(queryId).setDomain(newDomain);
        for (String oneQueryId : this.queryForId.keySet()) {
            if (!oneQueryId.equals(queryId)) {
                this.queryForId.get(oneQueryId).setDomain(this.queryForId.get(queryId));
            }
            this.domainPanelForId.get(oneQueryId).newDomainFromOtherPanel();
            SearchResultPanel resultPanel = this.resultPanelForId.get(oneQueryId);
            resultPanel.clear();
        }
    }

    @Override
    public void checkForDomainErrors(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        ArrayList problemFiles = query.getProblemFiles();
        if (problemFiles.size() > 0) {
            StringBuilder errorFilePaths = new StringBuilder("");
            for (int i = 0; i < problemFiles.size(); ++i) {
                errorFilePaths.append(((File)problemFiles.get(i)).getAbsolutePath());
                errorFilePaths.append("\n");
            }
            String explanation = "The following files could not be parsed and are therefore removed from the search domain:\n";
            JOptionPane.showMessageDialog(null, explanation + errorFilePaths.toString(), "Not Searchable Files", 0);
        }
    }

    @Override
    public float getDomainInitializationProgress(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getDomainInitializationProgress();
    }

    @Override
    public int getDomainSize(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getDomain().size();
    }

    public ArrayList<String> getSearchModes(String queryId) {
        return SearchQuery.getSearchModes();
    }

    public ArrayList<String> getParticipants(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getParticipants();
    }

    public ArrayList<String> getAnnotators(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getAnnotators();
    }

    public ArrayList<String> getTierNames(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getTierNames();
    }

    public ArrayList<String> getTierTypes(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        return query.getTierTypes();
    }

    @Override
    public Color getBackgroundColor() {
        return this.dummyPanel.getBackground();
    }

    @Override
    public List<File> getDomainInfo(String queryId) {
        HSQLDBQuery query = this.queryForId.get(queryId);
        if (query != null && this.getDomainInitializationProgress(queryId) >= 1.0f) {
            return new ArrayList<File>(query.getDomain());
        }
        System.out.println("getDomainInfo: " + (query == null ? "No query: " : "Not ready: ") + queryId);
        return new ArrayList<File>();
    }

    @Override
    public void putPersistent(String key, String value) {
        this.application.putPersistent(key, value);
    }

    @Override
    public String getPersistent(String key) {
        return this.application.getPersistent(key);
    }

    @Override
    public void deletePersistent(String key) {
        this.application.deletePersistent(key);
    }

    @Override
    public void setMatrixUsage(boolean[][] matrix, String queryId) {
        this.matrixForId.put(queryId, matrix);
    }

    @Override
    public boolean[][] getMatrixUsage(String queryId) {
        return this.matrixForId.get(queryId);
    }
}

