/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.mfsearch;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import nl.mpi.annot.search.mfsearch.SearchListener;
import nl.mpi.annot.search.mfsearch.SearchMediator;
import nl.mpi.annot.search.mfsearch.SwingSearchFonts;

public final class SearchDomainPanel
extends JPanel
implements ActionListener,
Runnable {
    private static final long serialVersionUID = -1886987389051621515L;
    private SearchMediator mediator;
    private String queryId;
    private JPanel domainNamePanel;
    private JLabel domainLabel;
    private JProgressBar progressBar;
    private Color backgroundColor;
    private JButton domainButton;
    private JLabel nEafLabel;
    private SearchListener searchListener;

    public SearchDomainPanel(SearchMediator mediator, String queryId, SearchListener searchListener) {
        this.mediator = mediator;
        this.queryId = queryId;
        this.searchListener = searchListener;
        mediator.addDomainPanel(queryId, this);
        this.setLayout(new BoxLayout(this, 1));
        this.backgroundColor = mediator.getBackgroundColor();
        this.setBackground(this.backgroundColor);
        this.add(Box.createVerticalStrut(5));
        this.domainNamePanel = new JPanel();
        this.domainNamePanel.setBackground(this.backgroundColor);
        this.domainNamePanel.setLayout(new BoxLayout(this.domainNamePanel, 0));
        this.domainNamePanel.add(Box.createHorizontalStrut(5));
        this.domainLabel = new JLabel("Domain: ");
        this.domainLabel.setFont(SwingSearchFonts.bigBoldFont);
        this.domainNamePanel.add(this.domainLabel);
        this.add(this.domainNamePanel);
        this.nEafLabel = new JLabel();
        this.nEafLabel.setFont(SwingSearchFonts.normalFont);
        this.domainNamePanel.add(this.nEafLabel);
        this.domainNamePanel.add(Box.createHorizontalGlue());
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("Initializing");
        this.progressBar.setVisible(true);
        this.domainNamePanel.add(this.progressBar);
        this.domainNamePanel.add(Box.createHorizontalStrut(20));
        this.domainButton = new JButton("Define Domain");
        this.domainButton.addActionListener(this);
        this.domainButton.setEnabled(false);
        this.domainNamePanel.add(this.domainButton);
        this.domainNamePanel.add(Box.createHorizontalStrut(30));
        new Thread(this).start();
    }

    @Override
    public void run() {
        while (this.mediator.getDomainInitializationProgress(this.queryId) < 1.0f) {
            int pBarValue = (int)(this.mediator.getDomainInitializationProgress(this.queryId) * (float)this.progressBar.getMaximum());
            this.progressBar.setValue(pBarValue);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        List<File> domain = this.mediator.getDomainInfo(this.queryId);
        this.nEafLabel.setText(domain.size() + " eaf files");
        if (domain.size() > 0) {
            StringBuilder toolTipSB = new StringBuilder("<html><p width=\"800\">");
            boolean notFirst = false;
            for (File file : domain) {
                if (notFirst) {
                    toolTipSB.append(", ");
                }
                if (toolTipSB.length() > 4200) {
                    toolTipSB.append("...");
                    break;
                }
                toolTipSB.append(file.getName());
                notFirst = true;
            }
            toolTipSB.append("</p></html>");
            this.nEafLabel.setToolTipText(toolTipSB.toString());
        } else {
            this.nEafLabel.setToolTipText("No searchable files in domain");
        }
        this.domainButton.setEnabled(true);
        this.progressBar.setVisible(false);
        if (this.searchListener != null) {
            this.searchListener.domainChanged();
        }
        if ("0".equals(this.queryId)) {
            this.mediator.checkForDomainErrors(this.queryId);
        }
        this.validate();
    }

    public void newDomainFromOtherPanel() {
        this.domainButton.setEnabled(false);
        this.progressBar.setVisible(true);
        new Thread(this).start();
    }

    public int getDomainLabelWidth() {
        return this.getStringWidth(this.domainLabel.getText(), this.domainLabel.getFont());
    }

    private int getStringWidth(String str, Font fnt) {
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
        Rectangle2D rect = fnt.getStringBounds(str, frc);
        return (int)rect.getWidth();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.domainButton) {
            this.mediator.setQueryDomain(null, this.queryId);
        }
    }
}

