/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.mfsearch;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mpi.eudico.client.annotator.gui.FileChooser;
import nl.mpi.annot.search.mfsearch.MultipleLayerSearchPanel;
import nl.mpi.annot.search.mfsearch.SearchListener;
import nl.mpi.annot.search.mfsearch.SingleLayerSearchPanel;
import nl.mpi.annot.search.mfsearch.SwingSearchFonts;
import nl.mpi.annot.tools.util.XmlUtil;
import nl.mpi.util.FileExtension;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SearchHistoryPanel
extends JPanel
implements ActionListener {
    private static final String SPLITTER = "qzbxv";
    private static final String fileExtension = "xml";
    private static final String ENCODING = "UTF-8";
    private static final String SINGLE_LAYER_QUERY_TYPE = "singlelayer";
    private static final String MULTI_LAYER_QUERY_TYPE = "multilayer";
    private static final String SAVED_QUERY_VERSION = "1.0";
    private SearchListener searchListener;
    private ArrayList<String> history;
    private int currentItem;
    private JButton historyPrevious;
    private JLabel historyStatus;
    private JButton historyNext;
    private JButton saveQueryButton;
    private JButton loadQueryButton;
    private boolean persistentHistoryLoaded;

    public SearchHistoryPanel(SearchListener searchListener, Color backgroundColor) {
        this.searchListener = searchListener;
        this.history = new ArrayList();
        this.currentItem = 0;
        this.setBackground(backgroundColor);
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(5));
        JLabel historyLabel = new JLabel("Query History:");
        historyLabel.setFont(SwingSearchFonts.bigBoldFont);
        this.add(historyLabel);
        this.add(Box.createHorizontalStrut(10));
        this.historyPrevious = new JButton("<");
        if (System.getProperty("os.name").toUpperCase().contains("MAC")) {
            this.historyPrevious.setBackground(backgroundColor);
        }
        this.historyPrevious.addActionListener(this);
        this.add(this.historyPrevious);
        this.add(Box.createHorizontalStrut(15));
        this.historyNext = new JButton(">");
        if (System.getProperty("os.name").toUpperCase().contains("MAC")) {
            this.historyNext.setBackground(backgroundColor);
        }
        this.historyNext.addActionListener(this);
        this.add(this.historyNext);
        this.add(Box.createHorizontalStrut(15));
        this.historyStatus = new JLabel();
        this.historyStatus.setFont(SwingSearchFonts.normalFont);
        this.historyStatus.setText("Empty History");
        this.add(this.historyStatus);
        this.add(Box.createHorizontalGlue());
        this.saveQueryButton = new JButton("Save query");
        if (System.getProperty("os.name").toUpperCase().contains("MAC")) {
            this.saveQueryButton.setBackground(backgroundColor);
        }
        this.saveQueryButton.addActionListener(this);
        this.add(this.saveQueryButton);
        this.add(Box.createHorizontalStrut(5));
        this.loadQueryButton = new JButton("Load query");
        if (System.getProperty("os.name").toUpperCase().contains("MAC")) {
            this.loadQueryButton.setBackground(backgroundColor);
        }
        this.loadQueryButton.addActionListener(this);
        this.add(this.loadQueryButton);
        this.add(Box.createHorizontalStrut(30));
        this.setButtonsEnabled();
    }

    public void setHistory(String hist) {
        if (hist != null) {
            String[] his = new String[]{};
            if (!hist.isEmpty()) {
                his = hist.split(SPLITTER);
            }
            this.history.clear();
            Collections.addAll(this.history, his);
            this.currentItem = -1;
        }
        this.persistentHistoryLoaded = true;
        this.historyStatus.setText("Loaded " + this.history.size() + " Queries");
        this.setButtonsEnabled();
    }

    public void reset() {
        this.currentItem = -1;
        this.setButtonsEnabled();
    }

    public String getHistory() {
        if (this.history.size() == 0) {
            return "xxxNULL_STRINGxxx";
        }
        StringBuilder his = new StringBuilder("");
        for (int i = 0; i < this.history.size(); ++i) {
            if (i > 0) {
                his.append(SPLITTER);
            }
            his.append(this.history.get(i));
        }
        return his.toString();
    }

    public void remember(String item) {
        if (item.contains(SPLITTER)) {
            return;
        }
        if (this.history.size() == 0 || !item.equals(this.history.get(0))) {
            this.history.add(0, item);
            this.currentItem = 0;
            if (this.history.size() >= 20) {
                this.history.remove(this.history.size() - 1);
            }
            this.historyStatus.setText("New Query");
            this.setButtonsEnabled();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.historyPrevious) {
            if (this.currentItem + 1 < this.history.size()) {
                ++this.currentItem;
                this.setButtonsEnabled();
                this.searchListener.setQuery(this.history.get(this.currentItem));
                this.historyStatus.setText("Query " + (this.history.size() - this.currentItem) + " / " + this.history.size());
            }
        } else if (source == this.historyNext) {
            if (this.currentItem > 0) {
                --this.currentItem;
                this.setButtonsEnabled();
                this.searchListener.setQuery(this.history.get(this.currentItem));
                this.historyStatus.setText("Query " + (this.history.size() - this.currentItem) + " / " + this.history.size());
            }
        } else if (source == this.saveQueryButton) {
            this.saveCurrentQuery();
        } else if (source == this.loadQueryButton) {
            this.loadNewQuery();
        }
    }

    public void saveCurrentQuery() {
        if (this.searchListener instanceof MultipleLayerSearchPanel || this.searchListener instanceof SingleLayerSearchPanel) {
            String type;
            String queryString;
            if (this.searchListener instanceof MultipleLayerSearchPanel) {
                queryString = ((MultipleLayerSearchPanel)this.searchListener).makeSaveableQuery();
                type = MULTI_LAYER_QUERY_TYPE;
            } else {
                queryString = ((SingleLayerSearchPanel)this.searchListener).makeSaveableQuery();
                type = SINGLE_LAYER_QUERY_TYPE;
            }
            FileChooser fc = new FileChooser((Component)this);
            fc.createAndShowFileDialog(null, 1, FileExtension.XML_EXT, "");
            if (fc.getSelectedFile() != null) {
                Object selectedFile = fc.getSelectedFile().toString();
                if (!((String)selectedFile).endsWith(fileExtension)) {
                    selectedFile = (String)selectedFile + ".xml";
                }
                try {
                    File outputFile = new File((String)selectedFile);
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), ENCODING);
                    out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    out.write("<query version=\"1.0\" type=\"" + type + "\">\n");
                    out.write(XmlUtil.escapeXML((String)queryString) + "\n");
                    out.write("</query>");
                    out.close();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "cannot write query file", 0);
                }
            }
        }
    }

    public void loadNewQuery() {
        FileChooser fc = new FileChooser((Component)this);
        fc.createAndShowFileDialog(null, 0, FileExtension.XML_EXT, "");
        if (fc.getSelectedFile() != null) {
            String selectedFile = fc.getSelectedFile().toString();
            try {
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = docBuilder.parse(new File(selectedFile));
                Node queryElement = doc.getElementsByTagName("query").item(0);
                String versionString = queryElement.getAttributes().getNamedItem("version").getNodeValue();
                String typeString = queryElement.getAttributes().getNamedItem("type").getNodeValue();
                if (typeString.equals(SINGLE_LAYER_QUERY_TYPE) && this.searchListener instanceof SingleLayerSearchPanel || typeString.equals(MULTI_LAYER_QUERY_TYPE) && this.searchListener instanceof MultipleLayerSearchPanel) {
                    if (versionString.equals(SAVED_QUERY_VERSION)) {
                        this.searchListener.setQuery(queryElement.getTextContent().trim());
                    } else {
                        JOptionPane.showMessageDialog(this, "The version of the query format is unknown.", "cannot read query file", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "The type of the query does not match the current search method.", "query type mismatch", 0);
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "cannot read query file", 0);
            }
            catch (SAXException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "cannot read query file", 0);
            }
            catch (ParserConfigurationException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "cannot read query file", 0);
            }
        }
    }

    private void setButtonsEnabled() {
        this.historyNext.setEnabled(this.currentItem > 0);
        this.historyPrevious.setEnabled(this.currentItem + 1 < this.history.size());
    }
}

