/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.mfsearch;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import nl.mpi.annot.search.lib.HitField;
import nl.mpi.annot.search.lib.HitLayer;
import nl.mpi.annot.search.lib.SearchHit;
import nl.mpi.annot.search.mfsearch.SearchUtil;
import nl.mpi.annot.search.mfsearch.VisibleHitPanelList;

public class SearchHitPanel
extends JPanel {
    public static final List<String> alignmentViewColumnNames = Arrays.asList("Linguistic Type", "Annotator", "Participant", "Begin Time", "End Time", "Duration");
    private SearchHit hit;
    private int hitNumber;
    private JLabel fileNameLabel = new JLabel();
    private JLabel alignmentStartLabel = new JLabel();
    private JLabel alignmentSpanLabel = new JLabel();
    private JLabel alignmentEndLabel = new JLabel();
    private JLabel participantHeaderLabel = new JLabel();
    private JLabel tierTypeHeaderLabel = new JLabel();
    private JLabel annotatorHeaderLabel = new JLabel();
    private JLabel beginTimeHeaderLabel = new JLabel();
    private JLabel endTimeHeaderLabel = new JLabel();
    private JLabel durationHeaderLabel = new JLabel();
    private ArrayList<JLabel> tierNameLabels = new ArrayList();
    private ArrayList<JLabel> participantLabels = new ArrayList();
    private ArrayList<JLabel> tierTypeLabels = new ArrayList();
    private ArrayList<JLabel> annotatorLabels = new ArrayList();
    private ArrayList<JLabel> beginTimeLabels = new ArrayList();
    private ArrayList<JLabel> endTimeLabels = new ArrayList();
    private ArrayList<JLabel> durationTimeLabels = new ArrayList();
    private String toolTipText = "";
    private ArrayList<ArrayList<JLabel>> annotationValuesLabels = new ArrayList();
    private int nRows;
    private Color lightBlue = new Color(189, 221, 255);
    private AlignmentPainter alignmentPainter = new AlignmentPainter();
    private int maxNrofAnnotationsPerRow;
    private Insets gridInsets = new Insets(1, 3, 1, 3);
    private Insets enclosingPanelInsets = new Insets(1, 2, 1, 2);
    private int enclosingPanelBorderThickness = 1;
    private Border enclosingPanelBorder = BorderFactory.createLineBorder(Color.black, this.enclosingPanelBorderThickness);
    private boolean showHeaders = false;
    private boolean showAlignmentTimeLabels = false;
    private ArrayList<Component> infoColumnComponents = new ArrayList();

    public SearchHitPanel(SearchHit hit, int hitNumber, VisibleHitPanelList panelList) {
        this.hit = hit;
        this.hitNumber = hitNumber;
        this.fill();
        this.init();
    }

    private void init() {
        this.setToolTipText(this.toolTipText);
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = (Insets)this.gridInsets.clone();
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 1;
        c.insets.bottom = 0;
        c.insets.top = 0;
        JPanel timePanel = new JPanel();
        timePanel.setOpaque(false);
        BoxLayout bl = new BoxLayout(timePanel, 2);
        timePanel.setLayout(bl);
        this.alignmentStartLabel.setVisible(this.showAlignmentTimeLabels);
        timePanel.add(this.alignmentStartLabel);
        timePanel.add(Box.createHorizontalGlue());
        this.alignmentSpanLabel.setVisible(this.showAlignmentTimeLabels);
        timePanel.add(this.alignmentSpanLabel);
        timePanel.add(Box.createHorizontalGlue());
        this.alignmentEndLabel.setVisible(this.showAlignmentTimeLabels);
        timePanel.add(this.alignmentEndLabel);
        this.add((Component)timePanel, c);
        c.insets = this.gridInsets;
        c.gridy = 1;
        c.gridx = 0;
        this.add((Component)this.fileNameLabel, c);
        c.gridx = 1;
        c.ipady = this.alignmentPainter.getHeight();
        this.add((Component)this.alignmentPainter, c);
        c.ipady = 0;
        for (int row = 0; row < this.nRows; ++row) {
            c.gridy = row + 2;
            c.gridx = 0;
            this.add((Component)this.encloseInPanel(this.tierNameLabels.get(row), this.lightBlue), c);
            c.gridx = 1;
            c.weightx = 1.0;
            this.add((Component)this.generateAnnotationValuesRowPanel(row), c);
            c.weightx = 0.0;
        }
        this.initInfoColumns();
    }

    private void initInfoColumns() {
        for (Component c : this.infoColumnComponents) {
            this.remove(c);
        }
        this.infoColumnComponents.clear();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = (Insets)this.gridInsets.clone();
        gbc.fill = 2;
        gbc.gridy = 1;
        int columnStart = 2;
        for (int i = 0; i < alignmentViewColumnNames.size(); ++i) {
            if (!this.getHeaderLabel(alignmentViewColumnNames.get(i)).isVisible()) continue;
            gbc.gridx = columnStart++;
            JLabel headerLabel = this.getHeaderLabelByIndex(i);
            JPanel enclosingPanel = new JPanel();
            enclosingPanel.setOpaque(false);
            enclosingPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc2 = new GridBagConstraints();
            gbc2.insets = this.enclosingPanelInsets;
            enclosingPanel.add(headerLabel);
            this.add((Component)enclosingPanel, gbc);
        }
        gbc.gridy = 2;
        for (int row = 0; row < this.nRows; ++row) {
            columnStart = 2;
            for (int columnIndex = 0; columnIndex < alignmentViewColumnNames.size(); ++columnIndex) {
                if (!this.getHeaderLabel(alignmentViewColumnNames.get(columnIndex)).isVisible()) continue;
                gbc.gridx = columnStart++;
                JPanel c = this.encloseInPanel(this.getLabelListByIndex(columnIndex).get(row), this.lightBlue);
                this.add((Component)c, gbc);
                this.infoColumnComponents.add(c);
            }
            ++gbc.gridy;
        }
    }

    private void fill() {
        Object htmlInfo = "";
        this.alignmentStartLabel.setText("alignmentStart");
        Font smallFont = new Font("sansserif", 0, 9);
        this.alignmentStartLabel.setFont(smallFont);
        this.alignmentSpanLabel.setText("alignmentSpan");
        this.alignmentSpanLabel.setFont(smallFont);
        this.alignmentEndLabel.setText("alignmentEnd");
        this.alignmentEndLabel.setFont(smallFont);
        String fileBaseName = this.hit.transcriptionName.substring(this.hit.transcriptionName.lastIndexOf(File.separatorChar) + 1);
        if (fileBaseName.toLowerCase().endsWith(".eaf")) {
            fileBaseName = fileBaseName.substring(0, fileBaseName.length() - 4);
        }
        this.fileNameLabel.setText(fileBaseName);
        this.nRows = this.hit.layerTiers.size();
        for (int j = 0; j < this.hit.layerTiers.size(); ++j) {
            ArrayList<JLabel> annotationValuesRow = new ArrayList<JLabel>();
            this.tierNameLabels.add(new JLabel());
            this.tierTypeLabels.add(new JLabel());
            this.participantLabels.add(new JLabel());
            this.annotatorLabels.add(new JLabel());
            this.beginTimeLabels.add(new JLabel());
            this.endTimeLabels.add(new JLabel());
            this.durationTimeLabels.add(new JLabel());
            Long minBegin = null;
            Long maxEnd = null;
            for (int k = 0; k < ((List)this.hit.hitFields.get(j)).size(); ++k) {
                HitField hitField = (HitField)((List)this.hit.hitFields.get(j)).get(k);
                if (hitField != null) {
                    String annotation = hitField.annotation.equals("") ? " " : hitField.annotation;
                    annotationValuesRow.add(new JLabel(annotation));
                    int pos = hitField.positionInTier + 1;
                    String position = "" + pos;
                    while (position.length() < 4) {
                        position = "0" + position;
                    }
                    long bt = hitField.beginTime;
                    long et = hitField.endTime;
                    String beginTime = SearchUtil.HHMMSSmmmFormat(bt);
                    String endTime = SearchUtil.HHMMSSmmmFormat(et);
                    String duration = SearchUtil.HHMMSSmmmFormat(et - bt);
                    htmlInfo = (String)htmlInfo + "<tr><td colspan=\"2\"><b>" + annotation + "</b></td></tr><tr><td>Position:</td><td> " + position + "</td></tr><tr><td>Time:</td><td>" + beginTime + " - " + endTime + "</td></tr><tr><td>Duration:</td></td>" + duration + "</td></tr>";
                    this.alignmentPainter.addAnnotation(j, bt, et);
                    if (minBegin == null || bt < minBegin) {
                        minBegin = bt;
                    }
                    if (maxEnd == null || et > maxEnd) {
                        maxEnd = et;
                    }
                    this.beginTimeLabels.get(j).setText(SearchUtil.formatShortTimeString(minBegin));
                    this.endTimeLabels.get(j).setText(SearchUtil.formatShortTimeString(maxEnd));
                    this.durationTimeLabels.get(j).setText(SearchUtil.formatShortTimeString(maxEnd - minBegin));
                } else {
                    annotationValuesRow.add(null);
                }
                if (k != 0) continue;
                this.tierNameLabels.get(j).setText(((HitLayer)this.hit.layerTiers.get((int)j)).tierName);
                this.tierTypeLabels.get(j).setText(((HitLayer)this.hit.layerTiers.get((int)j)).tierType);
                this.participantLabels.get(j).setText(((HitLayer)this.hit.layerTiers.get((int)j)).participant == null || ((HitLayer)this.hit.layerTiers.get((int)j)).participant.equals("") ? " " : ((HitLayer)this.hit.layerTiers.get((int)j)).participant);
                this.annotatorLabels.get(j).setText(((HitLayer)this.hit.layerTiers.get((int)j)).annotator == null || ((HitLayer)this.hit.layerTiers.get((int)j)).annotator.equals("") ? " " : ((HitLayer)this.hit.layerTiers.get((int)j)).annotator);
            }
            this.maxNrofAnnotationsPerRow = annotationValuesRow.size() > this.maxNrofAnnotationsPerRow ? annotationValuesRow.size() : this.maxNrofAnnotationsPerRow;
            this.annotationValuesLabels.add(annotationValuesRow);
        }
        this.toolTipText = "<html><table border=\"0\"><tr><td>Transcription, hit #" + this.hitNumber + ":</td><td>" + this.hit.transcriptionName + "</td></tr>" + (String)htmlInfo + "</table></html>";
    }

    public void fillColumnHeaders() {
        this.showHeaders = true;
        for (int i = 0; i < alignmentViewColumnNames.size(); ++i) {
            this.getHeaderLabelByIndex(i).setText(alignmentViewColumnNames.get(i));
        }
    }

    private void setAlignmentTimeLabels() {
        long bt = this.alignmentPainter.getBeginTime();
        long span = this.alignmentPainter.getSpan();
        this.alignmentStartLabel.setText(SearchUtil.HHMMSSmmmFormat(bt));
        this.alignmentSpanLabel.setText(SearchUtil.HHMMSSmmmFormat(span));
        this.alignmentEndLabel.setText(SearchUtil.HHMMSSmmmFormat(bt + span));
    }

    private JPanel encloseInPanel(Component c, Color bgcolor) {
        JPanel enclosingPanel = new JPanel();
        enclosingPanel.setBackground(bgcolor);
        enclosingPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = this.enclosingPanelInsets;
        enclosingPanel.setBorder(this.enclosingPanelBorder);
        enclosingPanel.add(c, gbc);
        return enclosingPanel;
    }

    private JPanel generateAnnotationValuesRowPanel(int row) {
        JPanel annotationValuesRowPanel = new JPanel();
        annotationValuesRowPanel.setOpaque(false);
        int ncols = this.maxNrofAnnotationsPerRow;
        annotationValuesRowPanel.setLayout(new GridLayout(1, ncols, 1, 1));
        for (JLabel cell : this.annotationValuesLabels.get(row)) {
            if (cell == null) {
                annotationValuesRowPanel.add(new JLabel());
                continue;
            }
            annotationValuesRowPanel.add(this.encloseInPanel(cell, Color.WHITE));
        }
        for (int i = 0; i < this.maxNrofAnnotationsPerRow - this.annotationValuesLabels.get(row).size(); ++i) {
            annotationValuesRowPanel.add(new JLabel());
        }
        return annotationValuesRowPanel;
    }

    private ArrayList<JLabel> getLabelListByIndex(int i) {
        String columnName = alignmentViewColumnNames.get(i);
        return this.getLabelList(columnName);
    }

    private ArrayList<JLabel> getLabelList(String columnName) {
        if (columnName.equals("Participant")) {
            return this.participantLabels;
        }
        if (columnName.equals("Linguistic Type")) {
            return this.tierTypeLabels;
        }
        if (columnName.equals("Annotator")) {
            return this.annotatorLabels;
        }
        if (columnName.equals("Begin Time")) {
            return this.beginTimeLabels;
        }
        if (columnName.equals("End Time")) {
            return this.endTimeLabels;
        }
        if (columnName.equals("Duration")) {
            return this.durationTimeLabels;
        }
        return null;
    }

    private JLabel getHeaderLabelByIndex(int i) {
        String columnName = alignmentViewColumnNames.get(i);
        return this.getHeaderLabel(columnName);
    }

    private JLabel getHeaderLabel(String columnName) {
        if (columnName.equals("Participant")) {
            return this.participantHeaderLabel;
        }
        if (columnName.equals("Linguistic Type")) {
            return this.tierTypeHeaderLabel;
        }
        if (columnName.equals("Annotator")) {
            return this.annotatorHeaderLabel;
        }
        if (columnName.equals("Begin Time")) {
            return this.beginTimeHeaderLabel;
        }
        if (columnName.equals("End Time")) {
            return this.endTimeHeaderLabel;
        }
        if (columnName.equals("Duration")) {
            return this.durationHeaderLabel;
        }
        return null;
    }

    public void setColumnWidths(ArrayList<Integer> newWidths) {
        ArrayList<Integer> wss = new ArrayList<Integer>();
        GridBagLayout gbl = (GridBagLayout)this.getLayout();
        for (int i = 0; i < newWidths.size(); ++i) {
            int width = newWidths.get(i);
            if (width == -1) {
                this.setColumnVisibility(alignmentViewColumnNames.get(i - 2), false);
                continue;
            }
            wss.add(newWidths.get(i));
            if (i <= 1 || !this.showHeaders) continue;
            JLabel headerLabel = this.getHeaderLabelByIndex(i - 2);
            headerLabel.getParent().setMaximumSize(new Dimension(20, headerLabel.getParent().getHeight()));
            String headerText = alignmentViewColumnNames.get(i - 2);
            if (headerText.length() <= 0 || this.getStringWidth(headerText, headerLabel.getFont()) <= newWidths.get(i) - 2 * this.enclosingPanelBorderThickness - 4) continue;
            headerText = headerText.substring(0, headerText.length() - 1);
            while (headerText.length() > 0 && this.getStringWidth(headerText, headerLabel.getFont()) > newWidths.get(i) - 2 * this.enclosingPanelBorderThickness - 4) {
                headerText = headerText.substring(0, headerText.length() - 1);
            }
            headerLabel.setText(headerText);
        }
        this.initInfoColumns();
        int[] ws = new int[wss.size()];
        for (int i = 0; i < wss.size(); ++i) {
            ws[i] = (Integer)wss.get(i);
        }
        gbl.columnWidths = ws;
    }

    public int getColumnWidth(int index) {
        ArrayList<JLabel> list;
        if (index == 1) {
            return 0;
        }
        int width = 0;
        if (index == 0) {
            list = this.tierNameLabels;
            width = this.getStringWidth(this.fileNameLabel.getText(), this.fileNameLabel.getFont());
        } else {
            list = this.getLabelListByIndex(index - 2);
            JLabel jLabel = this.getHeaderLabelByIndex(index - 2);
        }
        for (int row = 0; row < this.nRows; ++row) {
            int w;
            if (row >= list.size() || (w = this.getStringWidth(list.get(row).getText(), this.tierNameLabels.get(0).getFont())) <= width) continue;
            width = w + 2 * this.enclosingPanelBorderThickness + this.enclosingPanelInsets.left + this.enclosingPanelInsets.right;
        }
        return width + this.gridInsets.left + this.gridInsets.right;
    }

    @Override
    public int getHeight() {
        int alignmentSpanHeight = this.showAlignmentTimeLabels ? this.getStringHeight("Aknoep", this.alignmentSpanLabel.getFont()) : 0;
        int alignmentPanelHeight = this.alignmentPainter.getSize().height;
        int labelHeight = this.getStringHeight("Aknoep", this.tierNameLabels.get(0).getFont());
        if (alignmentPanelHeight < labelHeight) {
            alignmentPanelHeight = labelHeight;
        }
        alignmentPanelHeight = alignmentPanelHeight + this.gridInsets.top + this.gridInsets.bottom;
        int annotationLabelRowHeight = labelHeight + this.enclosingPanelInsets.top + this.enclosingPanelInsets.bottom + this.enclosingPanelBorderThickness * 2 + this.gridInsets.top + this.gridInsets.bottom;
        int annotationLabelsGridHeight = this.nRows * annotationLabelRowHeight;
        int height = alignmentSpanHeight + alignmentPanelHeight + annotationLabelsGridHeight + 10;
        return height;
    }

    private int getStringHeight(String str, Font fnt) {
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
        Rectangle2D rect = fnt.getStringBounds(str, frc);
        return (int)rect.getHeight();
    }

    private int getStringWidth(String str, Font fnt) {
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
        Rectangle2D rect = fnt.getStringBounds(str, frc);
        return (int)rect.getWidth();
    }

    private void setColumnVisibility(String columnName, boolean isVisible) {
        this.getHeaderLabel(columnName).setVisible(isVisible);
        for (JLabel label : this.getLabelList(columnName)) {
            label.getParent().setVisible(isVisible);
        }
    }

    public void addColumn(String columnName) {
        this.setColumnVisibility(columnName, true);
    }

    public void removeColumn(String columnName) {
        this.setColumnVisibility(columnName, false);
    }

    public void setViewPortSpan(long viewPortSpan) {
        this.alignmentPainter.setViewPortSpan(viewPortSpan);
        this.alignmentPainter.repaint();
    }

    public long getDuration() {
        return this.alignmentPainter.getDuration();
    }

    public void setAlignmentTimeLabelsVisible(boolean visibility) {
        this.alignmentStartLabel.setVisible(visibility);
        this.alignmentSpanLabel.setVisible(visibility);
        this.alignmentEndLabel.setVisible(visibility);
        this.showAlignmentTimeLabels = visibility;
    }

    public void setTooltipVisible(boolean visibility) {
        if (!visibility) {
            this.setToolTipText(null);
        } else {
            this.setToolTipText(this.toolTipText);
        }
    }

    private class AlignmentPainter
    extends Component {
        private ArrayList<long[]> annotationTimes = new ArrayList();
        private long beginTime = -1L;
        private long endTime = -1L;
        private long maxTierIndex = -1L;
        private int barHeight = 5;
        private int barGap = 2;
        private long viewPortSpan = -1L;
        private float factor = 1.0f;

        private AlignmentPainter() {
        }

        public void addAnnotation(long tierIndex, long begin, long end) {
            long[] timeArray = new long[]{tierIndex, begin, end};
            this.annotationTimes.add(timeArray);
            if (tierIndex > this.maxTierIndex) {
                this.maxTierIndex = tierIndex;
                this.setSize(this.getWidth(), (this.barHeight + this.barGap) * (Long.valueOf(this.maxTierIndex).intValue() + 1) - this.barGap);
            }
            if (this.beginTime < 0L || begin < this.beginTime) {
                this.beginTime = begin;
            }
            if (this.endTime < 0L || end > this.endTime) {
                this.endTime = end;
            }
            if (this.viewPortSpan < 0L || this.endTime - this.beginTime > this.viewPortSpan) {
                this.viewPortSpan = this.endTime - this.beginTime;
            }
        }

        public long getBeginTime() {
            return this.beginTime;
        }

        public long getSpan() {
            return this.viewPortSpan;
        }

        public void setViewPortSpan(long viewPortSpan) {
            this.viewPortSpan = viewPortSpan;
        }

        public long getDuration() {
            return this.endTime - this.beginTime;
        }

        @Override
        public void paint(Graphics g) {
            Dimension size = this.getSize();
            this.factor = (float)size.width / (float)this.viewPortSpan;
            int[] rectBegins = new int[Long.valueOf(this.maxTierIndex).intValue() + 1];
            int i = 0;
            while ((long)i <= this.maxTierIndex) {
                rectBegins[i] = -1;
                ++i;
            }
            boolean colorIndex = false;
            boolean[] paintContinueIndicator = new boolean[(int)this.maxTierIndex + 1];
            boolean[] paintDroppedOffIndicator = new boolean[(int)this.maxTierIndex + 1];
            for (int i2 = this.annotationTimes.size() - 1; i2 >= 0; --i2) {
                Color currentColor = Color.BLUE;
                long annotIndex = this.annotationTimes.get(i2)[0];
                long annotBegin = this.annotationTimes.get(i2)[1];
                long annotEnd = this.annotationTimes.get(i2)[2];
                int beginOfRect = Math.round((float)(annotBegin - this.beginTime) * this.factor);
                Long tierIndex = this.annotationTimes.get(i2)[0];
                int yCoor = tierIndex.intValue() * (this.barHeight + this.barGap);
                if (beginOfRect <= size.width) {
                    int endOfRect = Math.round((float)(annotEnd - this.beginTime) * this.factor);
                    int widthOfRect = endOfRect - beginOfRect;
                    if (rectBegins[Long.valueOf(annotIndex).intValue()] - endOfRect <= 1) {
                        --widthOfRect;
                        --endOfRect;
                    }
                    rectBegins[Long.valueOf((long)annotIndex).intValue()] = beginOfRect;
                    if (widthOfRect < 1) {
                        widthOfRect = 1;
                    }
                    if (beginOfRect + widthOfRect < size.width) {
                        g.setColor(currentColor);
                        g.fillRect(beginOfRect, yCoor, widthOfRect, this.barHeight);
                        continue;
                    }
                    g.setColor(currentColor);
                    g.fillRect(beginOfRect, Long.valueOf(annotIndex).intValue() * (this.barHeight + this.barGap), size.width - beginOfRect - 4, this.barHeight);
                    paintContinueIndicator[tierIndex.intValue()] = true;
                    continue;
                }
                paintDroppedOffIndicator[tierIndex.intValue()] = true;
            }
            int j = 0;
            while ((long)j <= this.maxTierIndex) {
                int yCoor = j * (this.barHeight + this.barGap);
                if (paintDroppedOffIndicator[j]) {
                    g.setColor(Color.RED);
                    g.fillRect(size.width - 5, yCoor, 5, 5);
                    if (paintContinueIndicator[j]) {
                        g.setColor(Color.GREEN);
                        g.fillRect(size.width - 11, yCoor, 5, 5);
                    }
                } else if (paintContinueIndicator[j]) {
                    g.setColor(Color.GREEN);
                    g.fillRect(size.width - 5, yCoor, 5, 5);
                }
                ++j;
            }
            SearchHitPanel.this.setAlignmentTimeLabels();
        }

        public int getBarHeight() {
            return this.barHeight;
        }

        public void setBarHeight(int barHeight) {
            this.barHeight = barHeight;
        }

        public int getBarGap() {
            return this.barGap;
        }

        public void setBarGap(int barGap) {
            this.barGap = barGap;
        }
    }
}

