/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.mfsearch;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.filechooser.FileNameExtensionFilter;
import mpi.eudico.client.annotator.gui.JFontChooser;
import nl.mpi.annot.search.lib.FrequencyInfo;
import nl.mpi.annot.search.lib.HitField;
import nl.mpi.annot.search.lib.HitLayer;
import nl.mpi.annot.search.lib.SearchHit;
import nl.mpi.annot.search.lib.SearchStatistics;
import nl.mpi.annot.search.mfsearch.ExportHitsOptionsDialog;
import nl.mpi.annot.search.mfsearch.ExportResultStatsDialog;
import nl.mpi.annot.search.mfsearch.MultipleLayerSearchPanel;
import nl.mpi.annot.search.mfsearch.SaverAllHits;
import nl.mpi.annot.search.mfsearch.SaverFrequencyInfo;
import nl.mpi.annot.search.mfsearch.SaverHitStatistics;
import nl.mpi.annot.search.mfsearch.SaverInterface;
import nl.mpi.annot.search.mfsearch.SearchHitPanel;
import nl.mpi.annot.search.mfsearch.SearchMediator;
import nl.mpi.annot.search.mfsearch.SearchUtil;
import nl.mpi.annot.search.mfsearch.SwingSearchFonts;
import nl.mpi.annot.search.mfsearch.VisibleHitPanelList;

public class SearchResultPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 7741606554388972423L;
    private SearchMediator mediator;
    private String queryId;
    public static final int POLLING_INTERVAL = 500;
    public static final int CONCORDANCE_MODE = 0;
    public static final int FREQUENCY_MODE = 1;
    public static final int FREQUENCY_BY_COUNT_MODE = 2;
    public static final int ALIGNMENT_MODE = 3;
    private static final int N_EMPTY_HIT_LINES = 1;
    private static final int MAX_VISIBLE_HITS_PER_SCREEN = 100;
    private static final int HIT_DISPLAY_Y = 35;
    private static final int BASE_HIT_MARGIN = 55;
    private int HIT_HEIGHT;
    private MouseListener mouseListener;
    private Timer pollTimer;
    private Dimension dimension;
    private JProgressBar progressBar;
    private JLabel hitStatsLabel;
    private JButton cancelButton;
    private JButton nextButton;
    private JButton prevButton;
    private JButton saveHitsButton;
    private JMenu _contextSizeMenu;
    private JPopupMenu concordancePopup;
    private JPopupMenu frequencyPopup;
    private JPopupMenu frequencyByFreqPopup;
    private JPopupMenu alignmentPopup;
    private JMenuItem infoBalloonToggleMenuItemConcordance;
    private JMenuItem infoBalloonToggleMenuItemAlignment;
    private JLayeredPane hitPanel;
    private JLabel[] hitBackgrounds;
    private JLabel[] hitLabelsLeftContext;
    private JLabel[] prefixLabels;
    private JLabel[] hitLabels;
    private JLabel[] postfixLabels;
    private JLabel[] hitLabelsRightContext;
    private JLabel[] headerLabel;
    private JButton hitNrLabel;
    private VisibleHitPanelList searchHitPanels;
    private JLabel timeScaleLabel;
    private JComboBox timeScaleCombobox;
    private String[] timeScaleOptions = new String[]{"1 sec.", "2 sec.", "5 sec.", "10 sec.", "15 sec.", "20 sec.", "User defined", "Scale to fit"};
    private long userDefinedViewSpan = 0L;
    private JMenuItem toggleAlignmentTimeLabelsMenuItem;
    private DelayedNewLayout delayedNewLayout;
    private JMenu visColumnsMenu;
    private HashMap<Component, Object> labelToHit;
    private HashMap<Component, Color> previousColors;
    private int hitContextSize;
    private int nrOfVisibleHits;
    private int nHitsPrev;
    private boolean tooltipVisible;
    private SaverInterface currentSaver = null;
    private File lastSavedFile;
    private Object activeHit;
    private boolean simpleQueryMode = false;
    private int resultMode;
    private int firstVisibleHitIndex;
    private int firstVisibleFrequencyInfoIndex;

    public SearchResultPanel(SearchMediator mediator, String queryId) {
        int i;
        this.mediator = mediator;
        this.queryId = queryId;
        this.pollTimer = new Timer(500, this);
        mediator.addResultPanel(queryId, this);
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(mediator.getBackgroundColor());
        this.mouseListener = new MouseHandler();
        JPanel progressPanel = new JPanel();
        progressPanel.setLayout(new BoxLayout(progressPanel, 0));
        progressPanel.add(Box.createHorizontalStrut(30));
        this.hitStatsLabel = new JLabel("Found 0 hits in 0 annotations (of 0)");
        this.hitStatsLabel.setFont(SwingSearchFonts.normalFont);
        progressPanel.add(this.hitStatsLabel);
        progressPanel.add(Box.createHorizontalStrut(10));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        this.progressBar.setSize(150, 20);
        this.progressBar.setVisible(true);
        progressPanel.add(this.progressBar);
        progressPanel.add(Box.createHorizontalStrut(10));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setBackground(mediator.getBackgroundColor());
        this.cancelButton.addActionListener(this);
        progressPanel.add(this.cancelButton);
        this.cancelButton.setVisible(true);
        this.cancelButton.setEnabled(false);
        progressPanel.add(Box.createHorizontalStrut(30));
        progressPanel.setMaximumSize(new Dimension(4000, 30));
        this.add(progressPanel);
        this.hitPanel = new JLayeredPane();
        this.hitPanel.setOpaque(true);
        this.hitPanel.setBackground(mediator.getBackgroundColor());
        this.hitPanel.setLayout(null);
        this.hitPanel.addMouseListener(this.mouseListener);
        this.prevButton = new JButton("<");
        this.prevButton.setBackground(mediator.getBackgroundColor());
        this.prevButton.setEnabled(false);
        this.prevButton.addActionListener(this);
        this.hitPanel.add(this.prevButton);
        this.nextButton = new JButton(">");
        this.nextButton.setBackground(mediator.getBackgroundColor());
        this.nextButton.setEnabled(false);
        this.nextButton.addActionListener(this);
        this.hitPanel.add(this.nextButton);
        this.hitNrLabel = new JButton("No hits");
        this.hitNrLabel.setBackground(mediator.getBackgroundColor());
        this.hitNrLabel.setActionCommand("JumpToHit");
        this.hitNrLabel.addActionListener(this);
        this.hitNrLabel.setVisible(false);
        this.hitPanel.add(this.hitNrLabel);
        this.saveHitsButton = new JButton("Save hits");
        this.saveHitsButton.setActionCommand("  Save hits");
        this.saveHitsButton.setEnabled(false);
        this.saveHitsButton.setBackground(mediator.getBackgroundColor());
        this.saveHitsButton.setVisible(false);
        this.saveHitsButton.addActionListener(this);
        this.hitPanel.add(this.saveHitsButton);
        this.labelToHit = new HashMap();
        this.previousColors = new HashMap();
        this.hitBackgrounds = new JLabel[100];
        this.hitLabels = new JLabel[100];
        this.hitLabelsLeftContext = new JLabel[100];
        this.hitLabelsRightContext = new JLabel[100];
        this.prefixLabels = new JLabel[100];
        this.postfixLabels = new JLabel[100];
        this.timeScaleLabel = new JLabel("Time scale:");
        this.timeScaleLabel.setFont(SwingSearchFonts.normalFont);
        this.timeScaleLabel.setVisible(false);
        this.hitPanel.add(this.timeScaleLabel);
        this.timeScaleCombobox = new JComboBox<String>(this.timeScaleOptions);
        this.timeScaleCombobox.setBackground(mediator.getBackgroundColor());
        this.timeScaleCombobox.addActionListener(this);
        this.timeScaleCombobox.setVisible(false);
        this.hitPanel.add(this.timeScaleCombobox);
        this.searchHitPanels = new VisibleHitPanelList(this.hitPanel);
        Color backgroundA = mediator.getBackgroundColor();
        Color backgroundB = mediator.getBackgroundColor().brighter();
        for (i = 0; i < 100; ++i) {
            JLabel hitLabel = new JLabel();
            hitLabel.setFont(SwingSearchFonts.hitFont);
            hitLabel.addMouseListener(this.mouseListener);
            hitLabel.setBackground((i & 1) == 1 ? backgroundA : backgroundB);
            hitLabel.setOpaque(true);
            this.hitPanel.add((Component)hitLabel, 42);
            this.hitLabels[i] = hitLabel;
            JLabel prefix = new JLabel();
            prefix.setFont(SwingSearchFonts.normalFont);
            prefix.addMouseListener(this.mouseListener);
            prefix.setBackground((i & 1) == 1 ? backgroundA : backgroundB);
            prefix.setOpaque(true);
            this.hitPanel.add((Component)prefix, 23);
            this.prefixLabels[i] = prefix;
            JLabel postfix = new JLabel();
            postfix.setFont(SwingSearchFonts.normalFont);
            postfix.addMouseListener(this.mouseListener);
            postfix.setBackground((i & 1) == 1 ? backgroundA : backgroundB);
            postfix.setOpaque(true);
            this.hitPanel.add((Component)postfix, 23);
            this.postfixLabels[i] = postfix;
            JLabel hitLabelBefore = new JLabel();
            hitLabelBefore.setFont(SwingSearchFonts.italicFont);
            hitLabelBefore.addMouseListener(this.mouseListener);
            hitLabelBefore.setBackground((i & 1) == 1 ? backgroundA : backgroundB);
            hitLabelBefore.setOpaque(true);
            this.hitPanel.add((Component)hitLabelBefore, 12);
            this.hitLabelsLeftContext[i] = hitLabelBefore;
            JLabel hitLabelAfter = new JLabel();
            hitLabelAfter.setFont(SwingSearchFonts.italicFont);
            hitLabelAfter.addMouseListener(this.mouseListener);
            hitLabelAfter.setBackground((i & 1) == 1 ? backgroundA : backgroundB);
            hitLabelAfter.setOpaque(true);
            this.hitPanel.add((Component)hitLabelAfter, 12);
            this.hitLabelsRightContext[i] = hitLabelAfter;
            JLabel hitBackground = new JLabel();
            hitBackground.setFont(SwingSearchFonts.smallFont);
            hitBackground.setOpaque(true);
            hitBackground.setBackground((i & 1) == 1 ? backgroundA : backgroundB);
            hitBackground.addMouseListener(this.mouseListener);
            this.hitBackgrounds[i] = hitBackground;
            this.hitPanel.add((Component)hitBackground, -42);
        }
        this.headerLabel = new JLabel[3];
        for (i = 0; i < this.headerLabel.length; ++i) {
            this.headerLabel[i] = new JLabel();
            this.headerLabel[i].setFont(SwingSearchFonts.bigBoldFont);
            this.hitPanel.add((Component)this.headerLabel[i], 42);
        }
        this.add(this.hitPanel);
        this.tooltipVisible = Boolean.parseBoolean(mediator.getPersistent("MFS.ToolTipVisible"));
        this.infoBalloonToggleMenuItemConcordance = this.makeMenuItem(this.tooltipVisible ? "  Hide info balloons" : "  Show info balloons");
        this.infoBalloonToggleMenuItemAlignment = this.makeMenuItem(this.tooltipVisible ? "  Hide info balloons" : "  Show info balloons");
        this.hitContextSize = 3;
        String csPref = mediator.getPersistent("MFS.ContextSize");
        if (csPref != null) {
            try {
                this.hitContextSize = Integer.parseInt(csPref);
            }
            catch (NumberFormatException nfe) {
                this.hitContextSize = 3;
            }
        }
        this._contextSizeMenu = new JMenu("  Context Size");
        this._contextSizeMenu.setBackground(mediator.getBackgroundColor());
        ButtonGroup sizeGroup = new ButtonGroup();
        for (int size = 0; size <= 8; ++size) {
            JRadioButtonMenuItem sizeItem = new JRadioButtonMenuItem(Integer.toString(size));
            if (size == this.hitContextSize) {
                sizeItem.setSelected(true);
            }
            sizeGroup.add(sizeItem);
            this._contextSizeMenu.add(sizeItem);
            sizeItem.addActionListener(this);
        }
        this.visColumnsMenu = new JMenu("  Visible columns");
        this.searchHitPanels.setVisibleColumnsString(mediator.getPersistent("MFS.AlignmentMode.VisibleColumns"));
        for (String columnName : SearchHitPanel.alignmentViewColumnNames) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(columnName);
            menuItem.setSelected(this.searchHitPanels.isVisibleColumn(columnName));
            menuItem.setActionCommand("ShowColumn" + columnName);
            menuItem.addActionListener(this);
            this.visColumnsMenu.add(menuItem);
        }
        boolean showAlignmentTimeLabels = mediator.getPersistent("MFS.AlignmentMode.DisplayAlignmentTimes") == null ? true : !mediator.getPersistent("MFS.AlignmentMode.DisplayAlignmentTimes").equals("false");
        this.searchHitPanels.setAlignmentTimeLabelsVisible(showAlignmentTimeLabels);
        this.toggleAlignmentTimeLabelsMenuItem = this.makeMenuItem(showAlignmentTimeLabels ? "  Hide alignment times" : "  Show alignment times");
        this.concordancePopup = new JPopupMenu();
        this.concordancePopup.add(this.makeMenuItem("  Show Frequency view (by annotation)"));
        this.concordancePopup.add(this.makeMenuItem("  Show Frequency view (by frequency)"));
        this.concordancePopup.add(this.makeMenuItem("  Show Alignment view"));
        this.concordancePopup.addSeparator();
        this.concordancePopup.add(this.makeMenuItem("  Show hit in transcription"));
        this.concordancePopup.add(this.infoBalloonToggleMenuItemConcordance);
        this.concordancePopup.add(this._contextSizeMenu);
        this.concordancePopup.addSeparator();
        this.concordancePopup.add(this.makeMenuItem("  Font"));
        this.concordancePopup.addSeparator();
        this.concordancePopup.add(this.makeMenuItem("  Save hits"));
        this.concordancePopup.add(this.makeMenuItem("  Save hit statistics"));
        this.frequencyPopup = new JPopupMenu();
        this.frequencyPopup.add(this.makeMenuItem("  Show Concordance view"));
        this.frequencyPopup.add(this.makeMenuItem("  Show Frequency view (by frequency)"));
        this.frequencyPopup.add(this.makeMenuItem("  Show Alignment view"));
        this.frequencyPopup.addSeparator();
        this.frequencyPopup.add(this.makeMenuItem("  Show sample hit in transcription"));
        this.frequencyPopup.addSeparator();
        this.frequencyPopup.add(this.makeMenuItem("  Font"));
        this.frequencyPopup.addSeparator();
        this.frequencyPopup.add(this.makeMenuItem("  Save frequency info"));
        this.frequencyByFreqPopup = new JPopupMenu();
        this.frequencyByFreqPopup.add(this.makeMenuItem("  Show Concordance view"));
        this.frequencyByFreqPopup.add(this.makeMenuItem("  Show Frequency view (by annotation)"));
        this.frequencyByFreqPopup.add(this.makeMenuItem("  Show Alignment view"));
        this.frequencyByFreqPopup.addSeparator();
        this.frequencyByFreqPopup.add(this.makeMenuItem("  Show sample hit in transcription"));
        this.frequencyByFreqPopup.addSeparator();
        this.frequencyByFreqPopup.add(this.makeMenuItem("  Font"));
        this.frequencyByFreqPopup.addSeparator();
        this.frequencyByFreqPopup.add(this.makeMenuItem("  Save frequency info"));
        this.alignmentPopup = new JPopupMenu();
        this.alignmentPopup.add(this.makeMenuItem("  Show Concordance view"));
        this.alignmentPopup.add(this.makeMenuItem("  Show Frequency view (by annotation)"));
        this.alignmentPopup.add(this.makeMenuItem("  Show Frequency view (by frequency)"));
        this.alignmentPopup.addSeparator();
        this.alignmentPopup.add(this.makeMenuItem("  Show hit in transcription"));
        this.alignmentPopup.add(this.infoBalloonToggleMenuItemAlignment);
        this.alignmentPopup.addSeparator();
        this.alignmentPopup.add(this.visColumnsMenu);
        this.alignmentPopup.add(this.toggleAlignmentTimeLabelsMenuItem);
        this.alignmentPopup.addSeparator();
        this.alignmentPopup.add(this.makeMenuItem("  Save hits"));
        this.alignmentPopup.add(this.makeMenuItem("  Save hit statistics"));
        this.resultMode = 0;
        this.getResultModePreference();
        ToolTipManager.sharedInstance().setInitialDelay(100);
        String ff = mediator.getPersistent("MFS.FontFamily");
        if (ff != null) {
            String fs = mediator.getPersistent("MFS.FontSize");
            try {
                int size = Integer.parseInt(fs);
                this.setHitFont(ff, size);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.addComponentListener(new ComponentHandler());
        this.dimension = new Dimension(690, 300);
        this.setSize(this.dimension);
    }

    public void clear() {
        this.nHitsPrev = 0;
        this.firstVisibleHitIndex = 0;
        this.hitNrLabel.setVisible(false);
        this.prevButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.saveHitsButton.setEnabled(false);
        this.resultMode = 0;
        this.getResultModePreference();
        this.updateStatistics();
        this.newLayout();
    }

    public void startUpdating() {
        this.pollTimer.stop();
        this.nHitsPrev = 0;
        this.firstVisibleHitIndex = 0;
        this.firstVisibleFrequencyInfoIndex = 0;
        this.hitNrLabel.setVisible(false);
        this.prevButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.saveHitsButton.setEnabled(false);
        if (this.resultMode == 1 || this.resultMode == 2) {
            this.resultMode = 0;
        }
        this.updateStatistics();
        this.searchHitPanels.init();
        this.layoutTimeScaleMenu(false);
        this.searchHitPanels.setViewPortSpan(1000L);
        this.newLayout();
        this.cancelButton.setEnabled(true);
        this.progressBar.setValue(0);
        this.progressBar.setString("Progress");
        this.pollTimer.start();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        String command = event.getActionCommand();
        if (command == null) {
            command = "None";
        } else if (command.startsWith("  Save")) {
            if (this.mediator.getSearchStatistics((String)this.queryId).progress < 1.0f) {
                JOptionPane.showMessageDialog(null, "Results cannot be saved, need completed query", "Query in progress or no query", 1);
                return;
            }
            if (this.mediator.getSearchStatistics((String)this.queryId).nHits < 1) {
                JOptionPane.showMessageDialog(null, "The last query had no results, nothing to save", "No data", 1);
                return;
            }
        }
        if (source instanceof JRadioButtonMenuItem) {
            try {
                this.hitContextSize = Integer.parseInt(command);
                this.mediator.putPersistent("MFS.ContextSize", String.valueOf(this.hitContextSize));
                this.newLayout();
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("  Font".equals(command)) {
            Font currentFont = this.hitLabels[0].getFont();
            JPopupMenu popupMenu = (JPopupMenu)((JMenuItem)source).getParent();
            Component invoker = popupMenu.getInvoker();
            JComponent invokerAsJComponent = (JComponent)invoker;
            Container topLevel = invokerAsJComponent.getTopLevelAncestor();
            try {
                JFontChooser chooser = new JFontChooser(JFontChooser.FONT_SIZE);
                Font font = chooser.showDialog((JFrame)topLevel, true, currentFont);
                if (font != null) {
                    this.mediator.putPersistent("MFS.FontFamily", font.getFamily());
                    this.mediator.putPersistent("MFS.FontSize", String.valueOf(font.getSize()));
                    this.setHitFont(font.getFamily(), font.getSize());
                }
            }
            catch (MissingResourceException mre) {
                JOptionPane.showMessageDialog(null, "Cannot start ELAN font chooser: " + mre, "Font Chooser Locale Data Missing", 0);
                System.out.println("Cannot start ELAN FontChooser: " + mre);
            }
        } else if ("  Show Concordance view".equals(command)) {
            this.resultMode = 0;
            this.mediator.putPersistent("MFS.ResultMode", String.valueOf(this.resultMode));
            this.enableToolTips(this.tooltipVisible);
        } else if (command.startsWith("  Show Frequency view")) {
            if (this.mediator.getSearchStatistics((String)this.queryId).progress < 1.0f) {
                JOptionPane.showMessageDialog(null, "Frequency info can only be used with a complete result set", "Query in progress or no query", 1);
                return;
            }
            this.resultMode = 1;
            if ("  Show Frequency view (by frequency)".equals(command)) {
                this.resultMode = 2;
            }
            this.mediator.putPersistent("MFS.ResultMode", String.valueOf(this.resultMode));
            this.newLayout();
        } else if ("  Show Alignment view".equals(command)) {
            this.resultMode = 3;
            this.mediator.putPersistent("MFS.ResultMode", String.valueOf(this.resultMode));
            this.newLayout();
        } else if (source == this.infoBalloonToggleMenuItemConcordance || source == this.infoBalloonToggleMenuItemAlignment) {
            this.enableToolTips(this.infoBalloonToggleMenuItemConcordance.getText().equals("  Show info balloons"));
            this.mediator.putPersistent("MFS.ToolTipVisible", String.valueOf(this.tooltipVisible));
        } else if ("  Show hit in transcription".equals(command) || "  Show sample hit in transcription".equals(command)) {
            if (this.activeHit != null) {
                this.mediator.showInViewer(this.activeHit, this.queryId);
            } else {
                JOptionPane.showMessageDialog(null, "You have to select a hit first", "No hit selected", 1);
            }
        } else if ("  Save hits".equals(command)) {
            if (this.currentSaver != null && this.currentSaver.getSaving()) {
                JOptionPane.showMessageDialog(null, "Already saving, press Cancel button to interrupt", "Save Hits", 1);
                return;
            }
            if (this.simpleQueryMode) {
                Window w = SwingUtilities.getWindowAncestor(this);
                ExportHitsOptionsDialog opDialog = w instanceof Frame ? new ExportHitsOptionsDialog((Frame)w, null, this.mediator, false) : (w instanceof Dialog ? new ExportHitsOptionsDialog((Dialog)w, null, this.mediator, false) : new ExportHitsOptionsDialog((Frame)null, null, this.mediator, false));
                opDialog.setVisible(true);
            } else {
                Window w = SwingUtilities.getWindowAncestor(this);
                ExportHitsOptionsDialog opcDialog = w instanceof Frame ? new ExportHitsOptionsDialog((Frame)w, null, this.mediator, true) : (w instanceof Dialog ? new ExportHitsOptionsDialog((Dialog)w, null, this.mediator, true) : new ExportHitsOptionsDialog((Frame)null, null, this.mediator, true));
                opcDialog.setVisible(true);
            }
            File saveFile = this.commonSaverPreparations("Save Hits", "LastMFSaveDir");
            if (saveFile != null) {
                this.currentSaver = new SaverAllHits(saveFile, this.mediator.getSearchStatistics((String)this.queryId).nHits, this.mediator, this.queryId, this.hitContextSize);
                new Thread(this.currentSaver).start();
                this.progressBar.setString("Saving hits");
            }
        } else if ("  Save hit statistics".equals(command)) {
            if (this.currentSaver != null && this.currentSaver.getSaving()) {
                JOptionPane.showMessageDialog(null, "Already saving, press Cancel button to interrupt", "Save Hits", 1);
                return;
            }
            ExportResultStatsDialog exDialog = null;
            Window w = SwingUtilities.getWindowAncestor(this);
            exDialog = w instanceof Frame ? new ExportResultStatsDialog((Frame)w, null, this.mediator) : (w instanceof Dialog ? new ExportResultStatsDialog((Dialog)w, null, this.mediator) : new ExportResultStatsDialog((Frame)null, null, this.mediator));
            exDialog.setVisible(true);
            File saveFile = this.commonSaverPreparations("Save Hits", "LastMFSaveDir");
            if (saveFile != null) {
                this.currentSaver = new SaverHitStatistics(saveFile, this.mediator.getSearchStatistics((String)this.queryId).nHits, this.mediator, this.queryId, exDialog.distinguishHits, exDialog.includeFileName, exDialog.includeFilePath, exDialog.msFormat);
                new Thread(this.currentSaver).start();
                this.progressBar.setString("Saving hit statistics");
            }
        } else if ("  Save frequency info".equals(command)) {
            boolean sortByFreq = this.resultMode == 2;
            File saveFile = this.commonSaverPreparations("Save Frequency Info", null);
            if (saveFile != null) {
                this.currentSaver = new SaverFrequencyInfo(saveFile, this.mediator.getSearchStatistics((String)this.queryId).nFrequencyInfoItems, this.mediator, this.queryId, sortByFreq);
                new Thread(this.currentSaver).start();
                this.progressBar.setString("Saving frequency info");
            }
        } else if (command != null && command.startsWith("ShowColumn")) {
            String columnName = command.substring("ShowColumn".length());
            if (((JCheckBoxMenuItem)source).isSelected()) {
                this.searchHitPanels.addColumn(columnName);
            } else {
                this.searchHitPanels.removeColumn(columnName);
            }
            this.mediator.putPersistent("MFS.AlignmentMode.VisibleColumns", this.searchHitPanels.getVisibleColumnsString());
        } else if ("  Hide alignment times".equals(command)) {
            this.toggleAlignmentTimeLabelsMenuItem.setText("  Show alignment times");
            this.toggleAlignmentTimeLabelsMenuItem.setActionCommand(this.toggleAlignmentTimeLabelsMenuItem.getText());
            this.searchHitPanels.setAlignmentTimeLabelsVisible(false);
            this.newLayout();
        } else if ("  Show alignment times".equals(command)) {
            this.toggleAlignmentTimeLabelsMenuItem.setText("  Hide alignment times");
            this.toggleAlignmentTimeLabelsMenuItem.setActionCommand(this.toggleAlignmentTimeLabelsMenuItem.getText());
            this.searchHitPanels.setAlignmentTimeLabelsVisible(true);
            this.newLayout();
        } else if (source == this.prevButton) {
            if (this.currentSaver != null && this.currentSaver.getSaving()) {
                return;
            }
            if (this.resultMode == 0 || this.resultMode == 3) {
                this.firstVisibleHitIndex -= this.nrOfVisibleHits;
            } else if (this.resultMode == 1 || this.resultMode == 2) {
                this.firstVisibleFrequencyInfoIndex -= this.nrOfVisibleHits;
            }
            this.newLayout();
        } else if (source == this.nextButton) {
            if (this.currentSaver != null && this.currentSaver.getSaving()) {
                return;
            }
            if (this.resultMode == 0 || this.resultMode == 3) {
                this.firstVisibleHitIndex += this.nrOfVisibleHits;
            } else if (this.resultMode == 1 || this.resultMode == 2) {
                this.firstVisibleFrequencyInfoIndex += this.nrOfVisibleHits;
            }
            this.newLayout();
        } else if ("JumpToHit".equals(command)) {
            if (this.currentSaver != null && this.currentSaver.getSaving()) {
                return;
            }
            int nHits = this.mediator.getSearchStatistics((String)this.queryId).nHits;
            int nFreq = this.mediator.getSearchStatistics((String)this.queryId).nFrequencyInfoItems;
            if (this.mediator.getSearchStatistics((String)this.queryId).progress < 1.0f) {
                nFreq = 0;
            }
            if (nHits <= 0) {
                return;
            }
            if (this.resultMode == 0 || this.resultMode == 3) {
                String value = JOptionPane.showInputDialog(this, "Enter a hit number to jump to another place in the hit list. Range: 1 - " + nHits, this.firstVisibleHitIndex + 1);
                int newFirst = -1;
                try {
                    newFirst = Integer.parseInt(value) - 1;
                }
                catch (NumberFormatException nfe) {
                    newFirst = -1;
                }
                if (newFirst >= 0 && newFirst < nHits) {
                    this.firstVisibleHitIndex = newFirst;
                    this.newLayout();
                }
            } else if (nFreq > 0) {
                String value = JOptionPane.showInputDialog(this, "Enter a frequency list item number to jump to another place in the hit list. Range: 1 - " + nFreq, this.firstVisibleFrequencyInfoIndex + 1);
                int newFirst = -1;
                try {
                    newFirst = Integer.parseInt(value) - 1;
                }
                catch (NumberFormatException nfe) {
                    newFirst = -1;
                }
                if (newFirst >= 0 && newFirst < nFreq) {
                    this.firstVisibleFrequencyInfoIndex = newFirst;
                    this.newLayout();
                }
            }
        } else if (source == this.timeScaleCombobox) {
            this.changeTimeScale();
        } else if (source == this.cancelButton) {
            if (this.currentSaver != null && this.currentSaver.getSaving()) {
                this.currentSaver.cancel();
                this.stopUpdating();
                JOptionPane.showMessageDialog(null, "Stopped saving results", "Save Results", 1);
                return;
            }
            this.mediator.cancelQuery(this.queryId);
            this.stopUpdating();
            if (this.mediator.getSearchStatistics((String)this.queryId).nHits > 0) {
                this.saveHitsButton.setEnabled(true);
            }
            this.updateStatistics();
            this.progressBar.setString("Canceled");
        } else if (source == this.pollTimer) {
            if (this.currentSaver != null && this.currentSaver.getSaving() && this.currentSaver.getProgress() == -1.0f) {
                this.pollTimer.stop();
                this.progressBar.setValue(0);
                this.progressBar.setString("");
                this.cancelButton.setEnabled(false);
            }
            if (this.currentSaver != null && this.currentSaver.getSaving()) {
                int pBarValue = (int)(this.currentSaver.getProgress() * (float)this.progressBar.getMaximum());
                this.progressBar.setValue(pBarValue < 0 ? 0 : (pBarValue > 100 ? 100 : pBarValue));
                return;
            }
            this.updateStatistics();
            int currentNumberofHits = this.mediator.getSearchStatistics((String)this.queryId).nHits;
            if (currentNumberofHits > this.nHitsPrev) {
                this.newLayout();
            }
            this.nHitsPrev = currentNumberofHits;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.dimension;
    }

    private void getResultModePreference() {
        String rModePref = this.mediator.getPersistent("MFS.ResultMode");
        if (rModePref != null) {
            try {
                this.resultMode = Integer.parseInt(rModePref);
            }
            catch (NumberFormatException nfe) {
                this.resultMode = 0;
                this.mediator.putPersistent("MFS.ResultMode", String.valueOf(this.resultMode));
            }
        }
    }

    private void removeHighlights() {
        this.activeHit = null;
        for (Map.Entry<Component, Color> item : this.previousColors.entrySet()) {
            item.getKey().setBackground(item.getValue());
        }
        this.previousColors.clear();
        for (JLabel background : this.hitBackgrounds) {
            this.hitPanel.moveToBack(background);
        }
    }

    private void stopUpdating() {
        this.pollTimer.stop();
        this.cancelButton.setEnabled(false);
        this.getResultModePreference();
        this.newLayout();
    }

    private void updateStatistics() {
        SearchStatistics stat = this.mediator.getSearchStatistics(this.queryId);
        this.hitStatsLabel.setText("Found " + stat.nHits + " hits in " + stat.nAnnotationsWithHit + " annotations (of " + stat.nAnnotationsSearched + ")");
        int pBarValue = (int)(stat.progress * (float)this.progressBar.getMaximum());
        this.progressBar.setValue(pBarValue < 0 ? 0 : (pBarValue > 100 ? 100 : pBarValue));
        if (stat.progress <= 0.0f) {
            this.progressBar.setString("");
        } else if (stat.progress >= 1.0f) {
            this.progressBar.setString("Ready");
            this.stopUpdating();
            this.saveHitsButton.setEnabled(stat.nHits > 0);
        }
        this.newLayout();
    }

    private File commonSaverPreparations(String topic, String key) {
        String lastDir;
        if (this.currentSaver != null && this.currentSaver.getSaving()) {
            JOptionPane.showMessageDialog(null, "Already saving, press Cancel button to interrupt", topic, 1);
            return null;
        }
        if (key != null && (lastDir = this.mediator.getPersistent(key)) != null) {
            this.lastSavedFile = new File(lastDir);
        }
        JFileChooser chooser = new JFileChooser(this.lastSavedFile);
        chooser.setFileFilter(new FileNameExtensionFilter("Text & CSV files", "txt", "csv"));
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal != 0) {
            return null;
        }
        File saveFile = chooser.getSelectedFile();
        if (!saveFile.getName().toLowerCase().endsWith(".txt") && !saveFile.getName().toLowerCase().endsWith(".csv") && saveFile.getParentFile() != null) {
            saveFile = new File(saveFile.getParentFile(), saveFile.getName() + ".csv");
            System.out.println("File had neither .txt nor .csv extension, added .csv: " + saveFile);
        }
        if (saveFile.exists() && (returnVal = JOptionPane.showConfirmDialog(null, saveFile.getName() + " already exists, overwrite?", topic, 0)) != 0) {
            return null;
        }
        this.cancelButton.setEnabled(true);
        this.lastSavedFile = saveFile;
        if (key != null) {
            this.mediator.putPersistent(key, chooser.getCurrentDirectory().getAbsolutePath());
        }
        this.pollTimer.start();
        return saveFile;
    }

    private void setHitFont(String fontFamily, int fontSize) {
        Font bFont = new Font(fontFamily, 1, fontSize);
        Font pFont = new Font(fontFamily, 0, fontSize);
        Font iFont = new Font(fontFamily, 2, fontSize);
        for (int i = 0; i < 100; ++i) {
            this.hitLabels[i].setFont(bFont);
            this.prefixLabels[i].setFont(pFont);
            this.postfixLabels[i].setFont(pFont);
            this.hitLabelsLeftContext[i].setFont(iFont);
            this.hitLabelsRightContext[i].setFont(iFont);
        }
        this.newLayout();
    }

    private synchronized void enableToolTips(boolean enabled) {
        if (enabled && !ToolTipManager.sharedInstance().isEnabled()) {
            ToolTipManager.sharedInstance().setEnabled(true);
        }
        if (enabled) {
            this.infoBalloonToggleMenuItemConcordance.setText("  Hide info balloons");
            this.infoBalloonToggleMenuItemAlignment.setText("  Hide info balloons");
        } else {
            this.infoBalloonToggleMenuItemConcordance.setText("  Show info balloons");
            this.infoBalloonToggleMenuItemAlignment.setText("  Show info balloons");
        }
        this.infoBalloonToggleMenuItemConcordance.setActionCommand(this.infoBalloonToggleMenuItemConcordance.getText());
        this.infoBalloonToggleMenuItemAlignment.setActionCommand(this.infoBalloonToggleMenuItemAlignment.getText());
        this.tooltipVisible = enabled;
        this.newLayout();
    }

    private void newLayout() {
        this.hitPanel.setVisible(false);
        if (this.resultMode == 0 || this.resultMode == 3) {
            this.saveHitsButton.setText("Save hits");
            this.saveHitsButton.setActionCommand("  Save hits");
        } else {
            this.saveHitsButton.setText("Save frequencies");
            this.saveHitsButton.setActionCommand("  Save frequency info");
        }
        this.layoutHitNavigation("");
        for (JLabel header : this.headerLabel) {
            header.setVisible(false);
        }
        this.newSizeLayout();
        this.hitPanel.setVisible(true);
    }

    private void newSizeLayout() {
        this.hitPanel.setVisible(false);
        int panelMiddle = this.hitPanel.getWidth() / 2;
        if (this.resultMode == 0) {
            this.layoutTimeScaleMenu(false);
            this.newConcordanceLayout(panelMiddle);
        } else if (this.resultMode == 1 || this.resultMode == 2) {
            this.layoutTimeScaleMenu(false);
            this.newFrequencyLayout(panelMiddle, this.resultMode == 2);
        } else if (this.resultMode == 3) {
            this.newAlignmentLayout();
            this.changeTimeScale();
        }
        this.hitPanel.setVisible(true);
    }

    private void layoutHitNavigation(String hitNrLabelText) {
        this.hitNrLabel.setText(hitNrLabelText);
        int hitNrWidth = this.getStringWidth(hitNrLabelText, this.hitNrLabel.getFont()) + 55;
        this.prevButton.setBounds(30, 15, 55, 25);
        this.nextButton.setBounds(100, 15, 55, 25);
        this.hitNrLabel.setBounds(170, 15, hitNrWidth, 25);
        int saveHitsWidth = this.getStringWidth(this.saveHitsButton.getText(), this.saveHitsButton.getFont()) + 55;
        this.saveHitsButton.setBounds(170 + hitNrWidth + 15, 15, saveHitsWidth, 25);
        if (this.tooltipVisible) {
            this.prevButton.setToolTipText("Previous page");
            this.nextButton.setToolTipText("Next page");
            this.hitNrLabel.setToolTipText("Click to jump to any position in the list");
            this.saveHitsButton.setToolTipText("Click to export data as CSV");
        } else {
            this.prevButton.setToolTipText(null);
            this.nextButton.setToolTipText(null);
            this.hitNrLabel.setToolTipText(null);
            this.saveHitsButton.setToolTipText(null);
        }
        this.hitNrLabel.setVisible(true);
        this.saveHitsButton.setVisible(true);
    }

    private void layoutTimeScaleMenu(boolean visible) {
        this.timeScaleCombobox.setVisible(false);
        this.timeScaleLabel.setVisible(false);
        if (visible) {
            int zoomLevelWidth = this.getStringWidth(this.timeScaleLabel.getText(), this.timeScaleLabel.getFont());
            int zoomLevelHeight = this.getStringHeight(this.timeScaleLabel.getText(), this.timeScaleLabel.getFont());
            int xCoor = (int)(this.saveHitsButton.getBounds().getX() + this.saveHitsButton.getBounds().getWidth() + 25.0);
            int yCoor = 15 + (25 - zoomLevelHeight) / 2;
            this.timeScaleLabel.setBounds(xCoor, yCoor, zoomLevelWidth, zoomLevelHeight);
            yCoor = (int)this.nextButton.getBounds().getY();
            this.timeScaleCombobox.setBounds(xCoor + zoomLevelWidth + 10, yCoor, 150, 25);
            if (this.tooltipVisible) {
                this.timeScaleCombobox.setToolTipText("Select zoom level for alignment bar graph display");
            } else {
                this.timeScaleCombobox.setToolTipText(null);
            }
            this.timeScaleCombobox.setVisible(true);
            this.timeScaleLabel.setVisible(true);
        }
    }

    private void newFrequencyLayout(int panelMiddle, boolean sortByFrequency) {
        int yMargin = 55;
        this.HIT_HEIGHT = this.getStringHeight("Aknoep", this.hitLabels[0].getFont()) + 5;
        this.labelToHit.clear();
        this.removeHighlights();
        this.searchHitPanels.clear();
        SearchStatistics searchStatistics = this.mediator.getSearchStatistics(this.queryId);
        int prevNrOfVisibleHits = this.nrOfVisibleHits;
        this.nrOfVisibleHits = (this.hitPanel.getHeight() - yMargin) / this.HIT_HEIGHT - 1;
        if (this.nrOfVisibleHits <= 0) {
            this.nrOfVisibleHits = 0;
            this.prevButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            if (searchStatistics.nFrequencyInfoItems > 0) {
                this.layoutHitNavigation("Cannot show " + searchStatistics.nFrequencyInfoItems + " frequency items, need more space");
            }
            this.clearHitRows(0, prevNrOfVisibleHits);
            return;
        }
        if (this.firstVisibleFrequencyInfoIndex <= 0) {
            this.firstVisibleFrequencyInfoIndex = 0;
        } else if (this.firstVisibleFrequencyInfoIndex > searchStatistics.nFrequencyInfoItems - 1) {
            this.firstVisibleFrequencyInfoIndex = searchStatistics.nFrequencyInfoItems - 1;
        }
        this.prevButton.setEnabled(this.firstVisibleFrequencyInfoIndex > 0);
        int lastVisibleFrequencyInfoIndex = this.firstVisibleFrequencyInfoIndex + this.nrOfVisibleHits;
        if (lastVisibleFrequencyInfoIndex > searchStatistics.nFrequencyInfoItems - 1) {
            lastVisibleFrequencyInfoIndex = searchStatistics.nFrequencyInfoItems - 1;
            this.nextButton.setEnabled(false);
        } else {
            this.nextButton.setEnabled(true);
        }
        int count = 1 + lastVisibleFrequencyInfoIndex - this.firstVisibleFrequencyInfoIndex;
        List<Object> frequencyStatistics = new ArrayList();
        if (searchStatistics.nFrequencyInfoItems > 0) {
            frequencyStatistics = this.mediator.getFrequencyInfo(this.firstVisibleFrequencyInfoIndex, count, this.queryId, sortByFrequency);
        }
        FrequencyInfo freqInfo = null;
        if (frequencyStatistics.size() > 0) {
            freqInfo = (FrequencyInfo)frequencyStatistics.get(0);
        }
        if (freqInfo != null && freqInfo.numberOfHits < 0) {
            this.clearHitRows(0, this.nrOfVisibleHits + 1);
            this.hitLabels[0].setText(freqInfo.annotation);
            this.hitLabels[0].setBounds(50, 100, 1000, this.HIT_HEIGHT);
            this.hitLabels[0].setVisible(true);
            this.nextButton.setEnabled(false);
            return;
        }
        this.headerLabel[0].setText("Percentage");
        int percentageLabelWidth = this.getStringWidth(this.headerLabel[0].getText(), this.headerLabel[0].getFont());
        this.headerLabel[0].setBounds(5, 55, percentageLabelWidth + 25, this.HIT_HEIGHT);
        this.headerLabel[1].setText("Count");
        int countLabelWidth = this.getStringWidth(this.headerLabel[1].getText(), this.headerLabel[1].getFont());
        this.headerLabel[1].setBounds(5 + percentageLabelWidth + 25, 55, percentageLabelWidth + 20, this.HIT_HEIGHT);
        int annoAreaStart = 5 + percentageLabelWidth + 25 + countLabelWidth;
        int annoAreaWidth = this.hitPanel.getWidth() - annoAreaStart;
        int annoAreaCenter = annoAreaStart + annoAreaWidth / 2;
        this.headerLabel[2].setText("Annotation");
        int annotationLabelWidth = this.getStringWidth(this.headerLabel[2].getText(), this.headerLabel[2].getFont());
        this.headerLabel[2].setBounds(annoAreaStart + (annoAreaWidth - (annotationLabelWidth + 25)) / 2, 55, annotationLabelWidth + 25, this.HIT_HEIGHT);
        for (JLabel header : this.headerLabel) {
            header.setVisible(true);
        }
        if (searchStatistics.nFrequencyInfoItems > 0) {
            this.layoutHitNavigation("Frequency " + (this.firstVisibleFrequencyInfoIndex + 1) + " - " + (this.firstVisibleFrequencyInfoIndex + this.nrOfVisibleHits) + " of " + searchStatistics.nFrequencyInfoItems);
        }
        int cleanStart = frequencyStatistics.size() < this.nrOfVisibleHits ? frequencyStatistics.size() : this.nrOfVisibleHits;
        this.clearHitRows(cleanStart, prevNrOfVisibleHits);
        for (int i = 0; i < this.nrOfVisibleHits; ++i) {
            String itemTooltip = "Item #" + (this.firstVisibleFrequencyInfoIndex + i + 1);
            if (i >= frequencyStatistics.size()) {
                this.layoutHitNavigation("Frequency " + (this.firstVisibleFrequencyInfoIndex + 1) + " - " + (this.firstVisibleFrequencyInfoIndex + i) + " of " + searchStatistics.nFrequencyInfoItems);
                break;
            }
            this.clearHitRows(i, i);
            freqInfo = (FrequencyInfo)frequencyStatistics.get(i);
            JLabel hitLabel = this.hitLabels[i];
            JLabel prefixLabel = this.prefixLabels[i];
            JLabel postfixLabel = this.postfixLabels[i];
            JLabel percentageLabel = this.hitLabelsLeftContext[i];
            JLabel countLabel = this.hitLabelsRightContext[i];
            this.labelToHit.put(hitLabel, freqInfo);
            this.labelToHit.put(prefixLabel, freqInfo);
            this.labelToHit.put(postfixLabel, freqInfo);
            this.labelToHit.put(percentageLabel, freqInfo);
            this.labelToHit.put(countLabel, freqInfo);
            if (freqInfo.hitLength == 0) {
                String prefixString = freqInfo.annotation;
                Object shorterString = prefixString;
                int shorten = 0;
                int prefixX = -1;
                int prefixW = 0;
                while ((prefixX = annoAreaCenter - (prefixW = this.getStringWidth((String)(shorterString = (shorten > 0 ? "..." : "") + prefixString.substring(shorten)), prefixLabel.getFont())) / 2) < annoAreaStart && ++shorten < prefixString.length()) {
                }
                prefixLabel.setText((String)shorterString);
                prefixLabel.setToolTipText(null);
                prefixLabel.setBounds(prefixX, yMargin + (i + 1) * this.HIT_HEIGHT, prefixW, this.HIT_HEIGHT);
            } else {
                String hitString = freqInfo.annotation.substring(freqInfo.hitPositionInAnnotation, freqInfo.hitPositionInAnnotation + freqInfo.hitLength);
                hitLabel.setText(hitString);
                int hitW = this.getStringWidth(hitString, hitLabel.getFont());
                int hitX = annoAreaCenter - hitW / 2;
                hitLabel.setToolTipText(null);
                hitLabel.setBounds(hitX, yMargin + (i + 1) * this.HIT_HEIGHT, hitW, this.HIT_HEIGHT);
                String prefixString = freqInfo.annotation.substring(0, freqInfo.hitPositionInAnnotation);
                Object shorterString = prefixString;
                int shorten = 0;
                int prefixX = -1;
                int prefixW = 0;
                while ((prefixX = hitX - (prefixW = this.getStringWidth((String)(shorterString = (shorten > 0 ? "..." : "") + prefixString.substring(shorten)), prefixLabel.getFont()))) < annoAreaStart && ++shorten < prefixString.length()) {
                }
                prefixLabel.setText((String)shorterString);
                prefixLabel.setToolTipText(null);
                prefixLabel.setBounds(prefixX, yMargin + (i + 1) * this.HIT_HEIGHT, prefixW, this.HIT_HEIGHT);
                String postfixString = freqInfo.annotation.substring(freqInfo.hitPositionInAnnotation + freqInfo.hitLength);
                postfixLabel.setText(postfixString);
                int postfixW = this.getStringWidth(postfixString, postfixLabel.getFont());
                int postfixX = hitX + hitW;
                postfixLabel.setToolTipText(null);
                postfixLabel.setBounds(postfixX, yMargin + (i + 1) * this.HIT_HEIGHT, postfixW, this.HIT_HEIGHT);
                if (this.tooltipVisible) {
                    hitLabel.setToolTipText(itemTooltip);
                    postfixLabel.setToolTipText(itemTooltip);
                }
                hitLabel.setVisible(true);
                postfixLabel.setVisible(true);
            }
            float percentage = 100.0f * (float)freqInfo.numberOfHits / (float)searchStatistics.nAnnotationsWithHit;
            String fmt = "##0.00";
            DecimalFormat df = new DecimalFormat(fmt);
            String percentageString = df.format(percentage) + "%";
            int percentageStringWidth = this.getStringWidth(percentageString, percentageLabel.getFont());
            percentageLabel.setText(percentageString);
            percentageLabel.setToolTipText(null);
            percentageLabel.setBounds(5 + percentageLabelWidth + 25 - (percentageStringWidth + 50), yMargin + (i + 1) * this.HIT_HEIGHT, percentageStringWidth, this.HIT_HEIGHT);
            String countString = Integer.toString(freqInfo.numberOfHits);
            int countStringWidth = this.getStringWidth(countString, countLabel.getFont());
            countLabel.setText(countString);
            countLabel.setToolTipText(null);
            countLabel.setBounds(annoAreaStart - (countStringWidth + 50), yMargin + (i + 1) * this.HIT_HEIGHT, countStringWidth, this.HIT_HEIGHT);
            this.hitBackgrounds[i].setBounds(0, yMargin + (i + 1) * this.HIT_HEIGHT, this.getWidth(), this.HIT_HEIGHT);
            if (this.tooltipVisible) {
                this.hitBackgrounds[i].setToolTipText(itemTooltip);
                percentageLabel.setToolTipText(itemTooltip);
                countLabel.setToolTipText(itemTooltip);
                prefixLabel.setToolTipText(itemTooltip);
            }
            prefixLabel.setVisible(true);
            percentageLabel.setVisible(true);
            countLabel.setVisible(true);
            this.hitBackgrounds[i].setVisible(true);
        }
    }

    private void newConcordanceLayout(int panelMiddle) {
        int yMargin = 25;
        this.tooltipVisible = !this.infoBalloonToggleMenuItemConcordance.getText().equals("  Show info balloons");
        this.HIT_HEIGHT = this.getStringHeight("Aknoep", this.hitLabels[0].getFont()) + 5;
        this.labelToHit.clear();
        this.removeHighlights();
        this.searchHitPanels.clear();
        int nHits = this.mediator.getSearchStatistics((String)this.queryId).nHits;
        int prevNrOfVisibleHits = this.nrOfVisibleHits;
        this.nrOfVisibleHits = (this.hitPanel.getHeight() - yMargin) / this.HIT_HEIGHT - 1;
        if (nHits <= 0) {
            this.prevButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            this.layoutHitNavigation("No hits");
        }
        if (this.nrOfVisibleHits <= 0) {
            this.nrOfVisibleHits = 0;
            this.prevButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            if (nHits > 0) {
                this.layoutHitNavigation("Cannot show " + nHits + " hits, need more space");
            }
            this.clearHitRows(0, prevNrOfVisibleHits);
            return;
        }
        if (this.firstVisibleHitIndex <= 0) {
            this.firstVisibleHitIndex = 0;
        } else if (this.firstVisibleHitIndex > nHits - 1) {
            this.firstVisibleHitIndex = nHits - 1;
        }
        this.prevButton.setEnabled(this.firstVisibleHitIndex > 0);
        int lastVisibleHitIndex = this.firstVisibleHitIndex + this.nrOfVisibleHits;
        if (lastVisibleHitIndex > nHits - 1) {
            lastVisibleHitIndex = nHits - 1;
            this.nextButton.setEnabled(false);
        } else {
            this.nextButton.setEnabled(true);
        }
        int count = 1 + lastVisibleHitIndex - this.firstVisibleHitIndex;
        List<SearchHit> hits = this.mediator.getHits(this.firstVisibleHitIndex, count, 8, this.queryId);
        if (nHits > 0) {
            this.layoutHitNavigation("Hit " + (this.firstVisibleHitIndex + 1) + " - " + (this.firstVisibleHitIndex + this.nrOfVisibleHits) + " of " + nHits);
        }
        boolean[][] cellsInUse = this.mediator.getMatrixUsage(this.queryId);
        boolean anyComplexHits = false;
        int cleanStart = hits.size() < this.nrOfVisibleHits ? hits.size() : this.nrOfVisibleHits;
        this.clearHitRows(cleanStart, prevNrOfVisibleHits);
        for (int i = 0; i < this.nrOfVisibleHits; ++i) {
            JLabel hitLabel;
            if (i >= hits.size()) {
                if (hits.size() <= 0) break;
                this.layoutHitNavigation("Hit " + (this.firstVisibleHitIndex + 1) + " - " + (this.firstVisibleHitIndex + i) + " of " + nHits);
                break;
            }
            this.clearHitRows(i, i);
            SearchHit hit = hits.get(i);
            if (hit.isComplex()) {
                hitLabel = this.hitLabels[i];
                this.labelToHit.put(hitLabel, hit);
                Object hitString = "";
                Object htmlInfo = "";
                anyComplexHits = true;
                for (int j = 0; j < hit.layerTiers.size(); ++j) {
                    hitString = (String)hitString + " #" + (j + 1) + " ";
                    for (int k = 0; k < ((List)hit.hitFields.get(j)).size(); ++k) {
                        boolean doProcess;
                        HitField hitField = (HitField)((List)hit.hitFields.get(j)).get(k);
                        boolean bl = cellsInUse != null ? cellsInUse[j][k] : (doProcess = hitField.annotation.charAt(1) != '|');
                        if (doProcess) {
                            Object annotation = hitField.annotation;
                            if (((String)annotation).length() > 15) {
                                annotation = ((String)annotation).substring(0, 15) + "...";
                            } else if (((String)annotation).length() == 0) {
                                annotation = "";
                            }
                            annotation = "|" + (String)annotation + "|";
                            int pos = hitField.positionInTier;
                            String position = "" + (pos + 1);
                            while (position.length() < 4) {
                                position = "0" + position;
                            }
                            long bt = hitField.beginTime;
                            long et = hitField.endTime;
                            String beginTime = SearchUtil.HHMMSSmmmFormat(bt);
                            String endTime = SearchUtil.HHMMSSmmmFormat(et);
                            String duration = SearchUtil.HHMMSSmmmFormat(et - bt);
                            hitString = (String)hitString + (String)annotation + " ";
                            htmlInfo = (String)htmlInfo + "<tr><td>" + hitField.annotation + "</td><td>&nbsp;&nbsp;Position: " + position + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Time: " + beginTime + "&nbsp;-&nbsp;" + endTime + "&nbsp;&nbsp;&nbsp;Duration: " + duration + "</td></tr>";
                            continue;
                        }
                        hitString = (String)hitString + "|| ";
                    }
                }
                this.clearHitRows(i, i);
                hitLabel.setText((String)hitString);
                String toolTipText = "<html><table border=\"0\"><tr><td> Transcription, hit #" + (this.firstVisibleHitIndex + i + 1) + ": </td><td>&nbsp;&nbsp;" + hit.transcriptionName + "</td></tr>" + (String)htmlInfo + "</table></html>";
                int hitW = this.getStringWidth(hitLabel);
                int hitX = panelMiddle - hitW / 2;
                hitLabel.setToolTipText((String)((Object)(this.tooltipVisible ? toolTipText : null)));
                hitLabel.setBounds(hitX, yMargin + (i + 1) * this.HIT_HEIGHT, hitW, this.HIT_HEIGHT);
                hitLabel.setVisible(true);
            } else {
                hitLabel = this.hitLabels[i];
                JLabel prefixLabel = this.prefixLabels[i];
                JLabel postfixLabel = this.postfixLabels[i];
                JLabel hitBeforeLabel = this.hitLabelsLeftContext[i];
                JLabel hitAfterLabel = this.hitLabelsRightContext[i];
                this.labelToHit.put(hitLabel, hit);
                this.labelToHit.put(prefixLabel, hit);
                this.labelToHit.put(postfixLabel, hit);
                this.labelToHit.put(hitBeforeLabel, hit);
                this.labelToHit.put(hitAfterLabel, hit);
                this.simpleQueryMode = true;
                Object hitString = "";
                HitField hitField = (HitField)((List)hit.hitFields.get(0)).get(0);
                HitLayer hitLayer = (HitLayer)hit.layerTiers.get(0);
                hitString = hitField.hitPositionInAnnotation > -1 && hitField.hitPositionInAnnotation + hitField.hitLength <= hitField.annotation.length() ? hitField.annotation.substring(hitField.hitPositionInAnnotation, hitField.hitPositionInAnnotation + hitField.hitLength) : "[" + hitField.hitPositionInAnnotation + "-" + hitField.hitLength + "] " + hitField.annotation;
                if (((String)hitString).length() == 0) {
                    hitString = "...";
                }
                hitLabel.setText((String)hitString);
                String toolTipText = "<html><table border=\"0\"><tr><td> Transcription, hit #" + (this.firstVisibleHitIndex + i + 1) + ": </td><td>" + hit.transcriptionName + "</td></tr><tr><td> Tier name: </td><td>" + hitLayer.tierName + "</td></tr><tr><td> Tier type: </td><td>" + hitLayer.tierType + "</td></tr>" + (String)(hitLayer.participant != null ? "<tr><td> Participant: </td><td>" + hitLayer.participant + "</td></tr>" : "") + (String)(hitLayer.annotator != null ? "<tr><td> Annotator: </td><td>" + hitLayer.annotator + "</td></tr>" : "") + "<tr><td> Position in tier: </td><td>" + (hitField.positionInTier + 1) + "</td></tr>";
                toolTipText = hitLayer.aligned ? toolTipText + "<tr><td> Begin time: </td><td>" + SearchUtil.HHMMSSmmmFormat(hit.beginTime) + "</td></tr><tr><td> End time: </td><td>" + SearchUtil.HHMMSSmmmFormat(hit.endTime) + "</td></tr><tr><td> Duration: </td><td>" + SearchUtil.HHMMSSmmmFormat(hit.endTime - hit.beginTime) + "</td></tr>" : toolTipText + "<tr><td> alignment: </td><td> not aligned </td></tr>";
                toolTipText = toolTipText + "</table></html>";
                int hitW = this.getStringWidth((String)hitString, hitLabel.getFont());
                int hitX = panelMiddle - hitW / 2;
                hitLabel.setToolTipText((String)((Object)(this.tooltipVisible ? toolTipText : null)));
                hitLabel.setBounds(hitX, yMargin + (i + 1) * this.HIT_HEIGHT, hitW, this.HIT_HEIGHT);
                String prefixString = hitField.annotation.substring(0, hitField.hitPositionInAnnotation);
                prefixLabel.setText(prefixString);
                int prefixW = this.getStringWidth(prefixString, prefixLabel.getFont());
                int prefixX = hitX - prefixW;
                prefixLabel.setToolTipText((String)((Object)(this.tooltipVisible ? toolTipText : null)));
                prefixLabel.setBounds(prefixX, yMargin + (i + 1) * this.HIT_HEIGHT, prefixW, this.HIT_HEIGHT);
                String postfixString = hitField.annotation.substring(hitField.hitPositionInAnnotation + hitField.hitLength);
                postfixLabel.setText(postfixString);
                int postfixW = this.getStringWidth(postfixString, postfixLabel.getFont());
                int postfixX = hitX + hitW;
                postfixLabel.setToolTipText((String)((Object)(this.tooltipVisible ? toolTipText : null)));
                postfixLabel.setBounds(postfixX, yMargin + (i + 1) * this.HIT_HEIGHT, postfixW, this.HIT_HEIGHT);
                int totalHitW = prefixW + hitW + postfixW;
                int totalHitX = prefixX;
                Object beforeString = "";
                int maxLeftContext = this.hitContextSize <= hit.leftContext.size() ? this.hitContextSize : hit.leftContext.size();
                for (int j = 0; j < maxLeftContext; ++j) {
                    beforeString = (String)hit.leftContext.get(j) + "  " + (String)beforeString;
                }
                hitBeforeLabel.setText((String)beforeString);
                int beforeW = this.getStringWidth((String)beforeString, hitBeforeLabel.getFont());
                int beforeX = totalHitX - beforeW;
                hitBeforeLabel.setToolTipText((String)((Object)(this.tooltipVisible ? toolTipText : null)));
                hitBeforeLabel.setBounds(beforeX, yMargin + (i + 1) * this.HIT_HEIGHT, beforeW, this.HIT_HEIGHT);
                StringBuilder afterString = new StringBuilder("");
                int maxRightContext = this.hitContextSize <= hit.rightContext.size() ? this.hitContextSize : hit.rightContext.size();
                for (int j = 0; j < maxRightContext; ++j) {
                    afterString.append("  ");
                    afterString.append((String)hit.rightContext.get(j));
                }
                hitAfterLabel.setText(afterString.toString());
                int afterW = this.getStringWidth(afterString.toString(), hitAfterLabel.getFont());
                hitAfterLabel.setToolTipText((String)((Object)(this.tooltipVisible ? toolTipText : null)));
                hitAfterLabel.setBounds(totalHitX + totalHitW, yMargin + (i + 1) * this.HIT_HEIGHT, afterW, this.HIT_HEIGHT);
                hitLabel.setVisible(true);
                prefixLabel.setVisible(true);
                postfixLabel.setVisible(true);
                hitBeforeLabel.setVisible(true);
                hitAfterLabel.setVisible(true);
            }
            this.hitBackgrounds[i].setBounds(0, yMargin + (i + 1) * this.HIT_HEIGHT, this.getWidth(), this.HIT_HEIGHT);
            this.hitBackgrounds[i].setToolTipText("Hit #" + (this.firstVisibleHitIndex + i + 1));
            this.hitBackgrounds[i].setVisible(true);
        }
        this._contextSizeMenu.setEnabled(!anyComplexHits);
    }

    private void newAlignmentLayout() {
        List<SearchHit> hits;
        this.tooltipVisible = !this.infoBalloonToggleMenuItemAlignment.getText().equals("  Show info balloons");
        this.HIT_HEIGHT = this.getStringHeight("Aknoep", this.hitLabels[0].getFont()) + 5;
        this.nrOfVisibleHits = (this.hitPanel.getHeight() - 25) / this.HIT_HEIGHT - 1;
        this.clearHitRows(0, this.nrOfVisibleHits + 1);
        int yMargin = 55;
        int nHits = this.mediator.getSearchStatistics((String)this.queryId).nHits;
        if (nHits > 0 && (hits = this.mediator.getHits(0, 1, 8, this.queryId)).size() > 0) {
            SearchHitPanel testPanel = new SearchHitPanel(hits.get(0), 1, this.searchHitPanels);
            testPanel.setAlignmentTimeLabelsVisible(this.toggleAlignmentTimeLabelsMenuItem.getActionCommand().equals("  Hide alignment times"));
            this.HIT_HEIGHT = testPanel.getHeight();
        }
        this.nrOfVisibleHits = (this.hitPanel.getHeight() - yMargin) / this.HIT_HEIGHT;
        if (nHits <= 0) {
            this.layoutTimeScaleMenu(false);
            this.prevButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            this.layoutHitNavigation("No hits");
        }
        if (this.nrOfVisibleHits <= 0) {
            this.nrOfVisibleHits = 0;
            this.layoutTimeScaleMenu(false);
            this.prevButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            if (nHits > 0) {
                this.layoutHitNavigation("Cannot show " + nHits + " hits, need more space");
            }
            this.searchHitPanels.clear();
            return;
        }
        if (this.firstVisibleHitIndex <= 0) {
            this.firstVisibleHitIndex = 0;
        } else if (this.firstVisibleHitIndex > nHits - 1) {
            this.firstVisibleHitIndex = nHits - 1;
        }
        this.prevButton.setEnabled(this.firstVisibleHitIndex > 0);
        int lastVisibleHitIndex = this.firstVisibleHitIndex + this.nrOfVisibleHits;
        if (lastVisibleHitIndex > nHits - 1) {
            lastVisibleHitIndex = nHits - 1;
            this.nextButton.setEnabled(false);
        } else {
            this.nextButton.setEnabled(true);
        }
        int count = 1 + lastVisibleHitIndex - this.firstVisibleHitIndex;
        List<SearchHit> hits2 = this.mediator.getHits(this.firstVisibleHitIndex, count, 8, this.queryId);
        this.labelToHit.clear();
        this.removeHighlights();
        this.searchHitPanels.clear();
        this.searchHitPanels.setTooltipsVisible(this.tooltipVisible);
        this.layoutHitNavigation("Hit " + (this.firstVisibleHitIndex + 1) + " - " + (this.firstVisibleHitIndex + this.nrOfVisibleHits) + " of " + nHits);
        this.layoutTimeScaleMenu(true);
        for (int i = 0; i < this.nrOfVisibleHits; ++i) {
            if (i >= hits2.size()) {
                if (hits2.size() <= 0) break;
                this.layoutHitNavigation("Hit " + (this.firstVisibleHitIndex + 1) + " - " + (this.firstVisibleHitIndex + i) + " of " + nHits);
                break;
            }
            SearchHit hit = hits2.get(i);
            SearchHitPanel searchHitPanel = new SearchHitPanel(hit, this.firstVisibleHitIndex + i + 1, this.searchHitPanels);
            searchHitPanel.setVisible(false);
            searchHitPanel.setAlignmentTimeLabelsVisible(this.toggleAlignmentTimeLabelsMenuItem.getActionCommand().equals("  Hide alignment times"));
            if (i == 0) {
                searchHitPanel.fillColumnHeaders();
            }
            searchHitPanel.addMouseListener(this.mouseListener);
            searchHitPanel.setTooltipVisible(this.tooltipVisible);
            this.labelToHit.put(searchHitPanel, hit);
            int panelHeight = searchHitPanel.getHeight();
            searchHitPanel.setBounds(0, yMargin + i * panelHeight, this.hitPanel.getWidth(), panelHeight);
            searchHitPanel.setVisible(true);
            this.searchHitPanels.add(searchHitPanel);
        }
        this.searchHitPanels.straightenColumns();
        this._contextSizeMenu.setEnabled(false);
    }

    private void changeTimeScale() {
        String scale = (String)this.timeScaleCombobox.getSelectedItem();
        if (scale.equals("Scale to fit")) {
            this.searchHitPanels.setViewPortSpan(null);
        } else if (scale.startsWith("User defined")) {
            String currentValue = SearchUtil.HHMMSSmmmFormat(this.userDefinedViewSpan);
            String value = JOptionPane.showInputDialog(this, "<html> Enter a time scale as: <ul> <li> milliseconds <li> hours:minutes:seconds.milliseconds </ul> <p> Enter a value <= 0 to undefine the time scale</html>", currentValue);
            if (value != null) {
                this.userDefinedViewSpan = SearchUtil.parseTimeString(value);
                if (this.userDefinedViewSpan == 98373696L) {
                    JOptionPane.showMessageDialog(null, "Could not interpret: " + value, "Illegal number format", 0);
                    this.userDefinedViewSpan = 0L;
                } else if (this.userDefinedViewSpan <= 0L) {
                    this.timeScaleCombobox.getModel().setSelectedItem("1 sec.");
                    this.userDefinedViewSpan = 1000L;
                } else if (this.userDefinedViewSpan > 0L) {
                    this.timeScaleCombobox.getModel().setSelectedItem(SearchUtil.HHMMSSmmmFormat(this.userDefinedViewSpan));
                }
            }
            this.timeScaleCombobox.setSize(this.timeScaleCombobox.getPreferredSize().width, this.timeScaleCombobox.getPreferredSize().height);
            this.searchHitPanels.scaleTo(this.userDefinedViewSpan);
        } else {
            Long viewSpan = 1000L * (long)Integer.parseInt(scale.replaceAll("\\D+", ""));
            this.searchHitPanels.scaleTo(viewSpan);
        }
    }

    private void clearHitRows(int first, int last) {
        first = first < 0 ? 0 : first;
        last = last > 99 ? 99 : last;
        int count = last + 1 - first;
        for (int i = first; i < first + count; ++i) {
            this.clearLabel(this.hitLabels[i]);
            this.clearLabel(this.prefixLabels[i]);
            this.clearLabel(this.postfixLabels[i]);
            this.clearLabel(this.hitLabelsLeftContext[i]);
            this.clearLabel(this.hitLabelsRightContext[i]);
            this.hitBackgrounds[i].setVisible(false);
        }
    }

    private void clearLabel(JLabel label) {
        if (label.isVisible()) {
            label.setVisible(false);
            label.setText("");
            label.setToolTipText(null);
        }
    }

    private int getStringWidth(JLabel label) {
        return label.getFontMetrics(label.getFont()).stringWidth(label.getText()) + 1;
    }

    private int getStringWidth(String str, Font fnt) {
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
        Rectangle2D rect = fnt.getStringBounds(str, frc);
        return (int)rect.getWidth() + 1;
    }

    private int getStringHeight(String str, Font fnt) {
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
        Rectangle2D rect = fnt.getStringBounds(str, frc);
        return (int)rect.getHeight();
    }

    private JMenuItem makeMenuItem(String label) {
        JMenuItem item = new JMenuItem(label);
        item.setActionCommand(label);
        item.addActionListener(this);
        return item;
    }

    private class MouseHandler
    extends MouseInputAdapter
    implements Serializable {
        private static final long serialVersionUID = -2609311710203931645L;

        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                if (SearchResultPanel.this.resultMode == 0) {
                    SearchResultPanel.this.concordancePopup.show(e.getComponent(), e.getX(), e.getY());
                } else if (SearchResultPanel.this.resultMode == 1) {
                    SearchResultPanel.this.frequencyPopup.show(e.getComponent(), e.getX(), e.getY());
                } else if (SearchResultPanel.this.resultMode == 2) {
                    SearchResultPanel.this.frequencyByFreqPopup.show(e.getComponent(), e.getX(), e.getY());
                } else if (SearchResultPanel.this.resultMode == 3) {
                    SearchResultPanel.this.alignmentPopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Component whatClicked = e.getComponent();
            if (whatClicked == null) {
                return;
            }
            Color highlightBackground = MultipleLayerSearchPanel.CONSTRAINT_LABEL_COLOR;
            SearchResultPanel.this.removeHighlights();
            if (whatClicked instanceof JLabel) {
                for (int i = 0; i < 100; ++i) {
                    if (whatClicked != SearchResultPanel.this.hitLabels[i] && whatClicked != SearchResultPanel.this.prefixLabels[i] && whatClicked != SearchResultPanel.this.postfixLabels[i] && whatClicked != SearchResultPanel.this.hitLabelsLeftContext[i] && whatClicked != SearchResultPanel.this.hitLabelsRightContext[i] && whatClicked != SearchResultPanel.this.hitBackgrounds[i]) continue;
                    SearchResultPanel.this.previousColors.put(SearchResultPanel.this.hitBackgrounds[i], SearchResultPanel.this.hitBackgrounds[i].getBackground());
                    SearchResultPanel.this.previousColors.put(SearchResultPanel.this.hitLabels[i], SearchResultPanel.this.hitLabels[i].getBackground());
                    SearchResultPanel.this.previousColors.put(SearchResultPanel.this.prefixLabels[i], SearchResultPanel.this.prefixLabels[i].getBackground());
                    SearchResultPanel.this.previousColors.put(SearchResultPanel.this.postfixLabels[i], SearchResultPanel.this.postfixLabels[i].getBackground());
                    SearchResultPanel.this.previousColors.put(SearchResultPanel.this.hitLabelsLeftContext[i], SearchResultPanel.this.hitLabelsLeftContext[i].getBackground());
                    SearchResultPanel.this.previousColors.put(SearchResultPanel.this.hitLabelsRightContext[i], SearchResultPanel.this.hitLabelsRightContext[i].getBackground());
                    break;
                }
            } else if (whatClicked instanceof SearchHitPanel) {
                SearchHitPanel alignedHit = (SearchHitPanel)whatClicked;
                SearchResultPanel.this.previousColors.put(alignedHit, alignedHit.getBackground());
            }
            Color c = highlightBackground;
            for (Component item : SearchResultPanel.this.previousColors.keySet()) {
                item.setBackground(c);
            }
            SearchResultPanel.this.activeHit = SearchResultPanel.this.labelToHit.get(whatClicked);
            if (e.getClickCount() == 2 && SearchResultPanel.this.activeHit != null) {
                SearchResultPanel.this.mediator.showInViewer(SearchResultPanel.this.activeHit, SearchResultPanel.this.queryId);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (SearchResultPanel.this.infoBalloonToggleMenuItemConcordance.getText().equals("  Show info balloons")) {
                if (SearchResultPanel.this.tooltipVisible) {
                    SearchResultPanel.this.enableToolTips(false);
                }
            } else if (!SearchResultPanel.this.tooltipVisible) {
                SearchResultPanel.this.enableToolTips(true);
            }
        }
    }

    private class DelayedNewLayout
    extends Thread {
        private DelayedNewLayout() {
        }

        @Override
        public void run() {
            try {
                DelayedNewLayout.sleep(100L);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SearchResultPanel.this.newSizeLayout();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class ComponentHandler
    extends ComponentAdapter {
        private ComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Dimension changedDimension = new Dimension(SearchResultPanel.this.getWidth(), SearchResultPanel.this.getHeight());
            SearchResultPanel.this.dimension = changedDimension;
            if (SearchResultPanel.this.delayedNewLayout != null) {
                SearchResultPanel.this.delayedNewLayout.interrupt();
            }
            SearchResultPanel.this.delayedNewLayout = new DelayedNewLayout();
            SearchResultPanel.this.delayedNewLayout.start();
        }
    }
}

