/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.mfsearch;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nl.mpi.annot.search.mfsearch.SearchDomainPanel;
import nl.mpi.annot.search.mfsearch.SearchHistoryPanel;
import nl.mpi.annot.search.mfsearch.SearchListener;
import nl.mpi.annot.search.mfsearch.SearchMediator;
import nl.mpi.annot.search.mfsearch.SearchResultPanel;
import nl.mpi.annot.search.mfsearch.SwingSearchFonts;

public class SingleLayerSearchPanel
extends JPanel
implements SearchListener,
ActionListener,
ItemListener {
    private static final long serialVersionUID = 3587487938284474772L;
    private SearchMediator mediator;
    private String queryId;
    private Color backgroundColor;
    private String[] targetModes;
    private String[] caseModes;
    private String[] matchModes;
    private JComboBox targetModeChooser;
    private JComboBox caseModeChooser;
    private JComboBox matchModeChooser;
    private JComboBox tierConstraintsChooser;
    private JButton findButton;
    private JTextField queryField;
    private SearchResultPanel resultPanel;
    private SearchHistoryPanel historyPanel;

    public SingleLayerSearchPanel(SearchMediator mediator) {
        this.mediator = mediator;
        this.backgroundColor = mediator.getBackgroundColor();
        this.setBackground(this.backgroundColor);
        this.queryId = mediator.createQuery();
        this.setLayout(new BorderLayout());
        JPanel definitionPanel = new JPanel();
        definitionPanel.setLayout(new BoxLayout(definitionPanel, 1));
        definitionPanel.setBackground(this.backgroundColor);
        SearchDomainPanel domainPanel = new SearchDomainPanel(mediator, this.queryId, this);
        definitionPanel.add(domainPanel);
        definitionPanel.add(Box.createVerticalStrut(15));
        this.historyPanel = new SearchHistoryPanel(this, this.backgroundColor);
        this.historyPanel.setHistory(mediator.getPersistent("singleTierHistory"));
        definitionPanel.add(this.historyPanel);
        definitionPanel.add(Box.createVerticalStrut(15));
        JPanel modePanel = new JPanel();
        modePanel.setBackground(this.backgroundColor);
        modePanel.setLayout(new BoxLayout(modePanel, 0));
        JLabel modeLabel = new JLabel("Mode:");
        modeLabel.setFont(SwingSearchFonts.bigBoldFont);
        modePanel.add(Box.createHorizontalStrut(5));
        modePanel.add(modeLabel);
        modePanel.add(Box.createHorizontalStrut(10));
        List<String> searchModes = mediator.getSearchModes(this.queryId);
        int i = 0;
        int nTargetModes = Integer.parseInt(searchModes.get(i));
        this.targetModes = new String[nTargetModes];
        for (int j = 0; j < nTargetModes; ++j) {
            this.targetModes[j] = searchModes.get(++i);
        }
        this.targetModeChooser = new JComboBox<String>(this.targetModes);
        if (System.getProperty("os.name").toUpperCase().contains("MAC")) {
            this.targetModeChooser.setBackground(this.backgroundColor);
        }
        this.targetModeChooser.addItemListener(this);
        modePanel.add(this.targetModeChooser);
        modePanel.add(Box.createHorizontalStrut(5));
        int nCaseModes = Integer.parseInt(searchModes.get(++i));
        this.caseModes = new String[nCaseModes];
        for (int j = 0; j < nCaseModes; ++j) {
            this.caseModes[j] = searchModes.get(++i);
        }
        this.caseModeChooser = new JComboBox<String>(this.caseModes);
        if (System.getProperty("os.name").toUpperCase().contains("MAC")) {
            this.caseModeChooser.setBackground(this.backgroundColor);
        }
        this.caseModeChooser.addItemListener(this);
        modePanel.add(this.caseModeChooser);
        modePanel.add(Box.createHorizontalStrut(5));
        int nMatchModes = Integer.parseInt(searchModes.get(++i));
        this.matchModes = new String[nMatchModes - 1];
        int j = 0;
        while (j < nMatchModes - 1) {
            String oneMatchMode;
            if ((oneMatchMode = searchModes.get(++i)).equals(" variable match")) continue;
            this.matchModes[j] = oneMatchMode;
            ++j;
        }
        this.matchModeChooser = new JComboBox<String>(this.matchModes);
        if (System.getProperty("os.name").toUpperCase().contains("MAC")) {
            this.matchModeChooser.setBackground(this.backgroundColor);
        }
        this.matchModeChooser.addItemListener(this);
        modePanel.add(this.matchModeChooser);
        modePanel.add(Box.createHorizontalStrut(30));
        definitionPanel.add(modePanel);
        definitionPanel.add(Box.createVerticalStrut(15));
        JPanel queryPanel = new JPanel();
        queryPanel.setBackground(this.backgroundColor);
        queryPanel.setLayout(new BoxLayout(queryPanel, 0));
        queryPanel.add(Box.createHorizontalStrut(30));
        this.findButton = new JButton("Find");
        if (System.getProperty("os.name").toUpperCase().contains("MAC")) {
            this.findButton.setBackground(this.backgroundColor);
        }
        this.findButton.addActionListener(this);
        queryPanel.add(this.findButton);
        queryPanel.add(Box.createHorizontalStrut(10));
        this.queryField = new JTextField();
        this.queryField.setFont(SwingSearchFonts.normalFont);
        this.queryField.addActionListener(this);
        this.queryField.requestFocus();
        queryPanel.add(this.queryField);
        queryPanel.add(Box.createHorizontalStrut(10));
        Dimension comboSize = new Dimension(250, 25);
        this.tierConstraintsChooser = new JComboBox();
        if (System.getProperty("os.name").toUpperCase().contains("MAC")) {
            this.tierConstraintsChooser.setBackground(this.backgroundColor);
        }
        this.tierConstraintsChooser.setPreferredSize(comboSize);
        this.tierConstraintsChooser.setMaximumRowCount(20);
        queryPanel.add(this.tierConstraintsChooser);
        queryPanel.add(Box.createHorizontalStrut(30));
        definitionPanel.add(queryPanel);
        definitionPanel.add(Box.createVerticalStrut(15));
        this.add((Component)definitionPanel, "North");
        this.resultPanel = new SearchResultPanel(mediator, this.queryId);
        this.add((Component)this.resultPanel, "Center");
        this.queryField.requestFocus();
    }

    public void fillTierConstraintsCombo() {
        while (this.tierConstraintsChooser == null) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.tierConstraintsChooser.removeAllItems();
        this.tierConstraintsChooser.addItem(" All Tiers ");
        for (String tierType : this.mediator.getTierTypes(this.queryId)) {
            this.tierConstraintsChooser.addItem(" Tier Type: " + tierType);
        }
        for (String tierName : this.mediator.getTierNames(this.queryId)) {
            this.tierConstraintsChooser.addItem(" Tier Name: " + tierName);
        }
        for (String participant : this.mediator.getParticipants(this.queryId)) {
            this.tierConstraintsChooser.addItem(" Participant: " + participant);
        }
        for (String annotator : this.mediator.getAnnotators(this.queryId)) {
            this.tierConstraintsChooser.addItem(" Annotator: " + annotator);
        }
    }

    @Override
    public void domainChanged() {
        this.fillTierConstraintsCombo();
        this.validate();
    }

    @Override
    public void queryStopped() {
        this.queryField.requestFocus();
    }

    public String makeSaveableQuery() {
        String keyword = this.queryField.getText();
        if (keyword == null) {
            keyword = "";
        }
        if (keyword.contains("xxxSAFE_SPLITTERxxx")) {
            keyword = "[UNPRINTABLE]";
        }
        return (String)this.targetModeChooser.getSelectedItem() + "xxxSAFE_SPLITTERxxx" + (String)this.caseModeChooser.getSelectedItem() + "xxxSAFE_SPLITTERxxx" + (String)this.matchModeChooser.getSelectedItem() + "xxxSAFE_SPLITTERxxx" + keyword + "xxxSAFE_SPLITTERxxx" + (String)this.tierConstraintsChooser.getSelectedItem();
    }

    @Override
    public void setQuery(String savedQuery) {
        String[] q = savedQuery.split("xxxSAFE_SPLITTERxxx");
        this.targetModeChooser.setSelectedItem(q[0]);
        this.caseModeChooser.setSelectedItem(q[1]);
        this.matchModeChooser.setSelectedItem(q[2]);
        this.queryField.setText(q[3]);
        this.tierConstraintsChooser.setSelectedItem(q[4]);
    }

    private String encodeQuery() {
        String mode = (String)this.targetModeChooser.getSelectedItem() + "xxxMODE_SPLITTERxxx" + (String)this.caseModeChooser.getSelectedItem() + "xxxMODE_SPLITTERxxx" + (String)this.matchModeChooser.getSelectedItem();
        Object query = "0, 0, 0, 0, 1, 1, 1xxxSAFE_SPLITTERxxx";
        String keyword = this.queryField.getText();
        if (keyword == null) {
            keyword = "";
        }
        if (keyword.contains("xxxSAFE_SPLITTERxxx")) {
            keyword = "[UNPRINTABLE]";
        }
        query = (String)query + keyword.trim() + "xxxSAFE_SPLITTERxxx" + mode + "xxxSAFE_SPLITTERxxxcns nonexxxSAFE_SPLITTERxxxcns nonexxxSAFE_SPLITTERxxx";
        query = (String)query + this.tierConstraintsChooser.getSelectedItem();
        return query;
    }

    private boolean checkQueryValidity() {
        String matchMode;
        int i;
        String targetMode = (String)this.targetModeChooser.getSelectedItem();
        String queryString = this.queryField.getText().trim();
        if (!targetMode.equals(" Annotation")) {
            String[] parts = queryString.split(" +");
            boolean onlyWildcards = true;
            for (i = 0; i < parts.length; ++i) {
                if (!parts[i].equals("#")) {
                    onlyWildcards = false;
                }
                if (!parts[i].equals("NOT()")) continue;
                JOptionPane.showMessageDialog(null, "A NOT() must have a value between ( and ) ", "Illegal NOT() pattern", 0);
                this.queryField.requestFocus();
                return false;
            }
            if (onlyWildcards) {
                JOptionPane.showMessageDialog(null, "An n-gram pattern must contain at least one character other than #", "Only wildcards in pattern", 0);
                this.queryField.requestFocus();
                return false;
            }
        }
        if ((matchMode = (String)this.matchModeChooser.getSelectedItem()).equals(" regular expression")) {
            String[] queryParts = new String[]{queryString};
            if (((String)this.targetModeChooser.getSelectedItem()).toLowerCase().contains("gram")) {
                queryParts = queryString.split(" ");
            }
            for (i = 0; i < queryParts.length; ++i) {
                try {
                    Pattern.compile(queryParts[i]);
                    continue;
                }
                catch (PatternSyntaxException e) {
                    JOptionPane.showMessageDialog(null, "Not a valid regular expression:\n\n     " + queryParts[i], "Error", 0);
                    this.queryField.requestFocus();
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object source = actionEvent.getSource();
        if (source == this.findButton || source == this.queryField) {
            if (this.queryField.getText().length() != 0 && !this.queryField.getText().equals("Error, empty query string") && !this.queryField.getText().startsWith("Not a valid regular expression")) {
                if (this.checkQueryValidity()) {
                    this.mediator.doQuery(this.encodeQuery(), this.queryId);
                    this.resultPanel.startUpdating();
                    this.historyPanel.remember(this.makeSaveableQuery());
                    this.mediator.putPersistent("singleTierHistory", this.historyPanel.getHistory());
                }
            } else {
                this.queryField.requestFocus();
                this.queryField.setText("Error, empty query string");
                this.queryField.setSelectionStart(0);
                this.queryField.setSelectionEnd(100);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.queryField.requestFocus();
    }
}

