/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.mfsearch;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import nl.mpi.annot.search.mfsearch.SearchHitPanel;

public class VisibleHitPanelList {
    private ArrayList<SearchHitPanel> list = new ArrayList();
    private Container searchResultPanel;
    private Long viewPortSpan = -1L;
    private ArrayList<Integer> maxWidths = new ArrayList();
    private boolean alignmentTimeLabelsVisible;
    private ArrayList<String> visibleColumns = new ArrayList();

    public VisibleHitPanelList(Container searchResultPanel) {
        this.searchResultPanel = searchResultPanel;
        this.initMaxWidths();
    }

    public void init() {
        this.clear();
        this.initMaxWidths();
        this.viewPortSpan = -1L;
    }

    private void initMaxWidths() {
        this.maxWidths.clear();
        for (int i = 0; i < 8; ++i) {
            int width = 0;
            if (i > 1 && !this.isVisibleColumn(SearchHitPanel.alignmentViewColumnNames.get(i - 2))) {
                width = -1;
            }
            this.maxWidths.add(width);
        }
    }

    public void add(SearchHitPanel searchHitPanel) {
        searchHitPanel.setAlignmentTimeLabelsVisible(this.alignmentTimeLabelsVisible);
        this.list.add(searchHitPanel);
        this.searchResultPanel.add(searchHitPanel);
        if (this.viewPortSpan != null) {
            searchHitPanel.setViewPortSpan(this.viewPortSpan);
        }
        for (int i = 0; i < 8; ++i) {
            if (this.maxWidths.get(i) == -1 || this.maxWidths.get(i) >= searchHitPanel.getColumnWidth(i)) continue;
            this.maxWidths.set(i, searchHitPanel.getColumnWidth(i));
        }
        this.straightenColumns();
    }

    public SearchHitPanel get(int i) {
        return this.list.get(i);
    }

    public void remove(int i) {
        this.searchResultPanel.remove(this.list.get(i));
        this.list.remove(i);
    }

    public void removeTail(int i) {
        for (int j = this.list.size() - 1; j >= i; --j) {
            this.remove(j);
        }
    }

    public int size() {
        return this.list.size();
    }

    public void clear() {
        for (Component component : this.list) {
            this.searchResultPanel.remove(component);
        }
        this.list.clear();
    }

    public long getViewPortSpan() {
        return this.viewPortSpan;
    }

    public boolean setViewPortSpan(Long viewPortSpan) {
        if (viewPortSpan == null) {
            this.viewPortSpan = null;
            this.scaleToFit();
            return false;
        }
        this.viewPortSpan = viewPortSpan;
        this.reAlignAll();
        return true;
    }

    public void scaleTo(Long milliseconds) {
        this.viewPortSpan = milliseconds;
        this.reAlignAll();
    }

    public void recalculateMaxDuration() {
        this.viewPortSpan = -1L;
        for (SearchHitPanel searchHitPanel : this.list) {
            if (searchHitPanel.getDuration() <= this.viewPortSpan) continue;
            this.viewPortSpan = searchHitPanel.getDuration();
        }
        this.reAlignAll();
    }

    public void reAlignAll() {
        for (SearchHitPanel searchHitPanel : this.list) {
            searchHitPanel.setViewPortSpan(this.viewPortSpan);
        }
    }

    public void addColumn(String columnName) {
        if (!this.visibleColumns.contains(columnName)) {
            this.visibleColumns.add(columnName);
        }
        int index = SearchHitPanel.alignmentViewColumnNames.indexOf(columnName) + 2;
        for (SearchHitPanel searchHitPanel : this.list) {
            searchHitPanel.addColumn(columnName);
            if (this.maxWidths.get(index) >= searchHitPanel.getColumnWidth(index)) continue;
            this.maxWidths.set(index, searchHitPanel.getColumnWidth(index));
        }
        this.straightenColumns();
    }

    public void removeColumn(String columnName) {
        if (this.visibleColumns.contains(columnName)) {
            this.visibleColumns.remove(this.visibleColumns.indexOf(columnName));
        }
        for (SearchHitPanel searchHitPanel : this.list) {
            searchHitPanel.removeColumn(columnName);
        }
        int index = SearchHitPanel.alignmentViewColumnNames.indexOf(columnName) + 2;
        this.maxWidths.set(index, -1);
        this.straightenColumns();
    }

    public void straightenColumns() {
        for (SearchHitPanel searchHitPanel : this.list) {
            searchHitPanel.setColumnWidths(this.maxWidths);
        }
    }

    public void scaleToFit() {
        for (SearchHitPanel searchHitPanel : this.list) {
            searchHitPanel.setViewPortSpan(searchHitPanel.getDuration());
        }
    }

    public void setAlignmentTimeLabelsVisible(boolean visibility) {
        for (SearchHitPanel searchHitPanel : this.list) {
            searchHitPanel.setAlignmentTimeLabelsVisible(visibility);
        }
        this.alignmentTimeLabelsVisible = visibility;
    }

    public String getVisibleColumnsString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.visibleColumns.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.visibleColumns.get(i));
        }
        return sb.toString();
    }

    public void setVisibleColumnsString(String visColsString) {
        if (visColsString == null) {
            for (String columnName : SearchHitPanel.alignmentViewColumnNames) {
                this.addColumn(columnName);
            }
        } else {
            String[] visCols;
            for (String columnName : SearchHitPanel.alignmentViewColumnNames) {
                this.removeColumn(columnName);
            }
            for (String columnName : visCols = visColsString.split(",")) {
                this.addColumn(columnName);
            }
        }
    }

    public boolean isVisibleColumn(String columnName) {
        return this.visibleColumns.indexOf(columnName) != -1;
    }

    public void setTooltipsVisible(boolean visibility) {
        for (SearchHitPanel searchHitPanel : this.list) {
            searchHitPanel.setTooltipVisible(visibility);
        }
    }
}

