/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.api.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

public class HandleUtil {
    public static final Pattern HANDLE_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
    public static final String HANDLE_PROXY_URL = "http://hdl.handle.net/";

    public boolean isHandleUri(URI handleUri) {
        return "hdl".equalsIgnoreCase(handleUri.getScheme()) && this.isHandle(handleUri.getSchemeSpecificPart());
    }

    public boolean isHandle(String handleString) {
        return HANDLE_PATTERN.matcher(handleString).matches();
    }

    public URI createHandleUri(String handleUri) {
        if (handleUri != null) {
            String handleUriLowerCase = handleUri.toLowerCase();
            if (handleUriLowerCase.startsWith("hdl:")) {
                try {
                    URI uri = new URI(handleUri);
                    if (this.isHandleUri(uri)) {
                        return uri;
                    }
                }
                catch (URISyntaxException ex) {
                    return null;
                }
            }
            if (handleUriLowerCase.startsWith(HANDLE_PROXY_URL)) {
                return this.createHandleUri(handleUri.substring(HANDLE_PROXY_URL.length()));
            }
            if (this.isHandle(handleUri)) {
                try {
                    return new URI("hdl:" + handleUri);
                }
                catch (URISyntaxException ex) {
                    return null;
                }
            }
        }
        return null;
    }
}

