/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api;

import java.io.File;
import nl.mpi.metadata.cmdi.api.CMDIApi;
import nl.mpi.metadata.cmdi.api.model.CMDIDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;

public class CMDIApiRunner {
    private static final Logger logger = LoggerFactory.getLogger(CMDIApiRunner.class);

    public static void main(String[] args) throws Exception {
        if (args.length == 2 && args[0].equals("-v")) {
            CMDIApiRunner.validate(args[1]);
            System.exit(0);
        }
        System.err.println("Options: \n -v <filename>           validate file");
        System.exit(1);
    }

    private static void validate(String file) throws Exception {
        logger.info("------ Instantiating API...");
        CMDIApi api = new CMDIApi();
        logger.info("------ Opening metadata document");
        CMDIDocument document = api.getMetadataDocument(new File(file).toURI().toURL());
        logger.info("------ Validating metadata document");
        api.validateMetadataDocument(document, (ErrorHandler)new DefaultHandler2(){

            @Override
            public void warning(SAXParseException e) throws SAXException {
                logger.warn("SAX warning", (Throwable)e);
            }

            @Override
            public void error(SAXParseException e) throws SAXException {
                logger.error("SAX error", (Throwable)e);
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                logger.error("SAX fatal error", (Throwable)e);
            }
        });
        logger.info("------ Validation finished");
    }
}

