/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api.dom;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import nl.mpi.metadata.api.MetadataException;
import nl.mpi.metadata.api.type.MetadataElementAttributeType;
import nl.mpi.metadata.cmdi.api.model.Attribute;
import nl.mpi.metadata.cmdi.api.model.CMDIContainerMetadataElement;
import nl.mpi.metadata.cmdi.api.model.CMDIDocument;
import nl.mpi.metadata.cmdi.api.model.CMDIMetadataElement;
import nl.mpi.metadata.cmdi.api.model.CMDIMetadataElementFactory;
import nl.mpi.metadata.cmdi.api.model.Element;
import nl.mpi.metadata.cmdi.api.model.MultilingualElement;
import nl.mpi.metadata.cmdi.api.type.CMDIAttributeType;
import nl.mpi.metadata.cmdi.api.type.CMDIProfile;
import nl.mpi.metadata.cmdi.api.type.CMDIProfileElement;
import nl.mpi.metadata.cmdi.api.type.ComponentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMDIComponentReader {
    private static Logger logger = LoggerFactory.getLogger(CMDIComponentReader.class);
    private CMDIMetadataElementFactory elementFactory;

    public CMDIComponentReader(CMDIMetadataElementFactory elementFactory) {
        this.elementFactory = elementFactory;
    }

    public void readComponents(CMDIDocument cmdiDocument, Document domDocument, XPath xPath) throws DOMException, MetadataException {
        Node rootComponentNode = CMDIComponentReader.getRootComponentNode(cmdiDocument, domDocument, xPath);
        CMDIProfile profile = cmdiDocument.getType();
        this.readElement(rootComponentNode, cmdiDocument, profile);
    }

    public static Node getRootComponentNode(CMDIDocument cmdiDocument, Document domDocument, XPath xPath) throws MetadataException {
        String rootComponentNodePath = cmdiDocument.getType().getPathString();
        try {
            Node rootComponentNode = (Node)xPath.evaluate(rootComponentNodePath, domDocument, XPathConstants.NODE);
            if (rootComponentNode == null) {
                throw new MetadataException(String.format("Root component node not found at specified path: %1$s", rootComponentNodePath));
            }
            logger.debug("Found documentNode at {}", (Object)rootComponentNodePath);
            return rootComponentNode;
        }
        catch (XPathExpressionException ex) {
            throw new MetadataException(String.format("XPathExpressionException while looking up root component node at specified path: %1$s", rootComponentNodePath), ex);
        }
    }

    private void readElement(Node domNode, CMDIMetadataElement element, CMDIProfileElement type) throws MetadataException {
        if (element instanceof CMDIContainerMetadataElement) {
            if (type instanceof ComponentType) {
                logger.debug("Reading child elements for component");
                this.readChildElements(domNode, (CMDIContainerMetadataElement)element, (ComponentType)type);
            } else {
                throw new AssertionError((Object)"Found Component node but specified type is not a ComponentType");
            }
        }
        this.readAttributes(domNode, element, type);
        element.setDirty(false);
    }

    private void readChildElements(Node parentNode, CMDIContainerMetadataElement parentElement, ComponentType parentType) throws MetadataException {
        NodeList childNodes = parentNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode instanceof org.w3c.dom.Element) {
                logger.debug("Found DOM Element node {}, will create CMDI metadata element", (Object)childNode);
                CMDIProfileElement childType = parentType.getType(childNode.getLocalName());
                if (childType == null) {
                    throw new MetadataException(String.format("Cannot infer component type for DOM node: %1$s", childNode));
                }
                CMDIMetadataElement childElement = this.createElementInstance(parentElement, childNode, childType);
                parentElement.addChildElement(childElement);
                this.readElement(childNode, childElement, childType);
                continue;
            }
            logger.debug("Skipping non-element node {}", (Object)childNode);
        }
    }

    private CMDIMetadataElement createElementInstance(CMDIContainerMetadataElement parentElement, Node instanceNode, CMDIProfileElement type) throws AssertionError {
        CMDIMetadataElement elementInstance = this.elementFactory.createNewMetadataElement(parentElement, type);
        if (elementInstance instanceof Element) {
            ((Element)elementInstance).setValue(instanceNode.getTextContent());
        }
        return elementInstance;
    }

    private void readAttributes(Node instanceNode, CMDIMetadataElement metadataElement, CMDIProfileElement metadataType) {
        NamedNodeMap attributesMap = instanceNode.getAttributes();
        if (attributesMap.getLength() > 0) {
            for (MetadataElementAttributeType attributeType : metadataType.getAllAttributes()) {
                Node attributeNode = this.getAttributeNodeByType(attributesMap, attributeType);
                if (attributeNode == null) continue;
                String localName = attributeNode.getLocalName();
                if ("ref".equals(localName)) {
                    this.readProxyReferenceAttribute(attributeNode, metadataElement);
                    continue;
                }
                if (metadataElement instanceof MultilingualElement && "http://www.w3.org/XML/1998/namespace".equals(attributeNode.getNamespaceURI()) && "lang".equals(localName)) {
                    this.readLanguageAttribute(attributeNode, (MultilingualElement)metadataElement);
                    continue;
                }
                this.readElementAttribute((CMDIAttributeType)attributeType, attributeNode, metadataElement);
            }
        }
    }

    private Node getAttributeNodeByType(NamedNodeMap attributesMap, MetadataElementAttributeType attributeType) throws DOMException {
        String namespaceURI = attributeType.getNamespaceURI();
        String name = attributeType.getName();
        if (namespaceURI == null || namespaceURI.length() == 0) {
            return attributesMap.getNamedItem(name);
        }
        return attributesMap.getNamedItemNS(namespaceURI, name);
    }

    private void readLanguageAttribute(Node attributeNode, MultilingualElement metadataElement) throws DOMException {
        String elementLanguage = attributeNode.getNodeValue();
        metadataElement.setLanguage(elementLanguage);
    }

    private void readProxyReferenceAttribute(Node attributeNode, CMDIMetadataElement metadataElement) throws DOMException {
        String[] refs;
        for (String ref : refs = attributeNode.getNodeValue().split("\\s+")) {
            metadataElement.addDocumentResourceProxyReference(ref);
        }
    }

    private void readElementAttribute(CMDIAttributeType attributeType, Node attributeNode, CMDIMetadataElement metadataElement) throws DOMException {
        Attribute<String> attribute = this.elementFactory.createAttribute(metadataElement, attributeType);
        attribute.setValue(attributeNode.getNodeValue());
        metadataElement.addAttribute(attribute);
    }
}

