/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api.dom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nl.mpi.metadata.api.MetadataDocumentException;
import nl.mpi.metadata.api.MetadataException;
import nl.mpi.metadata.api.dom.DomBuildingMode;
import nl.mpi.metadata.api.dom.MetadataDOMBuilder;
import nl.mpi.metadata.api.model.HeaderInfo;
import nl.mpi.metadata.api.model.MetadataElement;
import nl.mpi.metadata.api.model.Reference;
import nl.mpi.metadata.api.type.MetadataElementAttributeType;
import nl.mpi.metadata.cmdi.api.dom.CMDINamespaceContext;
import nl.mpi.metadata.cmdi.api.dom.DOMBuilderFactory;
import nl.mpi.metadata.cmdi.api.model.Attribute;
import nl.mpi.metadata.cmdi.api.model.CMDIContainerMetadataElement;
import nl.mpi.metadata.cmdi.api.model.CMDIDocument;
import nl.mpi.metadata.cmdi.api.model.CMDIMetadataElement;
import nl.mpi.metadata.cmdi.api.model.Element;
import nl.mpi.metadata.cmdi.api.model.MultilingualElement;
import nl.mpi.metadata.cmdi.api.model.ResourceProxy;
import nl.mpi.metadata.cmdi.api.type.CMDIAttributeType;
import nl.mpi.metadata.cmdi.util.CMDIEntityResolver;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class CMDIDomBuilder
implements MetadataDOMBuilder<CMDIDocument> {
    private static final BigInteger DUMMY_NUMBER_TO_ADD = BigInteger.valueOf(3L);
    private static final Logger logger = LoggerFactory.getLogger(CMDIDomBuilder.class);
    private final EntityResolver entityResolver;
    private final DOMBuilderFactory domBuilderFactory;

    public CMDIDomBuilder(EntityResolver entityResolver, DOMBuilderFactory domBuilderFactory) {
        this.entityResolver = entityResolver;
        this.domBuilderFactory = domBuilderFactory;
    }

    @Override
    public Document buildDomForDocument(CMDIDocument metadataDocument) throws MetadataDocumentException {
        Document domDocument = this.getBaseDocument(metadataDocument);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        if (metadataDocument.getHeaderDirtyState().isDirty()) {
            this.pruneHeader(metadataDocument, domDocument, xPathFactory);
            this.setHeaders(metadataDocument, domDocument, xPathFactory);
        }
        if (metadataDocument.getResourceProxiesDirtyState().isDirty()) {
            this.pruneResourceProxies(metadataDocument, domDocument, xPathFactory);
            this.buildProxies(metadataDocument, domDocument, xPathFactory);
        }
        this.buildComponents(metadataDocument, domDocument, xPathFactory);
        return domDocument;
    }

    protected Document getBaseDocument(CMDIDocument metadataDocument) throws MetadataDocumentException {
        if (metadataDocument.getFileLocation() != null) {
            try {
                return this.domBuilderFactory.newDOMBuilder().parse(metadataDocument.getFileLocation().toString());
            }
            catch (IOException ioEx) {
                throw new MetadataDocumentException(metadataDocument, "IOException while trying to parse original document file", ioEx);
            }
            catch (SAXException sEx) {
                throw new MetadataDocumentException(metadataDocument, "SAXException while trying to parse original document file", sEx);
            }
        }
        try {
            return this.createDomFromSchema(metadataDocument.getType().getSchemaLocation(), DomBuildingMode.EMPTY);
        }
        catch (IOException ioEx) {
            throw new MetadataDocumentException(metadataDocument, "IOException while trying to create new DOM from schema", ioEx);
        }
        catch (XmlException xEx) {
            throw new MetadataDocumentException(metadataDocument, "XmlException while trying to create new DOM from schema", xEx);
        }
    }

    private void pruneHeader(CMDIDocument metadataDocument, Document domDocument, XPathFactory xPathFactory) throws DOMException, MetadataDocumentException {
        try {
            Node headerNode = (Node)this.newXPath(xPathFactory).evaluate("/cmd:CMD/cmd:Header", domDocument, XPathConstants.NODE);
            this.removeChildren(headerNode);
        }
        catch (XPathExpressionException tEx) {
            throw new MetadataDocumentException(metadataDocument, "XPathExpressionException while preparing for building metadata DOM", tEx);
        }
        catch (MetadataException mdEx) {
            throw new MetadataDocumentException(metadataDocument, "MetadataException while preparing for building metadata DOM", mdEx);
        }
    }

    private void pruneResourceProxies(CMDIDocument metadataDocument, Document domDocument, XPathFactory xPathFactory) throws DOMException, MetadataDocumentException {
        try {
            Node resourceProxyListNode = (Node)this.newXPath(xPathFactory).evaluate("/cmd:CMD/cmd:Resources/cmd:ResourceProxyList", domDocument, XPathConstants.NODE);
            this.removeChildren(resourceProxyListNode);
        }
        catch (XPathExpressionException tEx) {
            throw new MetadataDocumentException(metadataDocument, "XPathExpressionException while preparing for building metadata DOM", tEx);
        }
        catch (MetadataException mdEx) {
            throw new MetadataDocumentException(metadataDocument, "MetadataException while preparing for building metadata DOM", mdEx);
        }
    }

    private void removeChildren(Node parent) throws DOMException, MetadataException {
        parent.getParentNode().replaceChild(parent.cloneNode(false), parent);
    }

    private void setHeaders(CMDIDocument metadataDocument, Document domDocument, XPathFactory xPathFactory) throws MetadataDocumentException {
        try {
            Node headerNode = (Node)this.newXPath(xPathFactory).evaluate("/cmd:CMD/cmd:Header", domDocument, XPathConstants.NODE);
            for (HeaderInfo header : metadataDocument.getHeaderInformation()) {
                org.w3c.dom.Element headerItemNode = domDocument.createElementNS("http://www.clarin.eu/cmd/", header.getName());
                headerItemNode.setTextContent(header.getValue());
                for (Map.Entry<String, String> attribute : header.getAttributes().entrySet()) {
                    headerItemNode.setAttribute(attribute.getKey(), attribute.getValue());
                }
                headerNode.appendChild(headerItemNode);
            }
            metadataDocument.getHeaderDirtyState().setDirty(false);
        }
        catch (XPathExpressionException tEx) {
            throw new MetadataDocumentException(metadataDocument, "XPathExpressionException while setting headers in metadata DOM", tEx);
        }
    }

    private void buildProxies(CMDIDocument metadataDocument, Document domDocument, XPathFactory xPathFactory) throws MetadataDocumentException {
        List<Reference> documentResourceProxies = metadataDocument.getDocumentReferences();
        if (documentResourceProxies.size() > 0) {
            try {
                Node proxiesNode = (Node)this.newXPath(xPathFactory).evaluate("/cmd:CMD/cmd:Resources/cmd:ResourceProxyList", domDocument, XPathConstants.NODE);
                for (Reference resourceProxy : documentResourceProxies) {
                    this.buildResourceProxy(domDocument, proxiesNode, (ResourceProxy)resourceProxy);
                }
                metadataDocument.getResourceProxiesDirtyState().setDirty(false);
            }
            catch (XPathExpressionException tEx) {
                throw new MetadataDocumentException(metadataDocument, "XPathExpressionException while building resource proxies in DOM", tEx);
            }
        }
    }

    private void buildResourceProxy(Document domDocument, Node proxiesNode, ResourceProxy resourceProxy) throws MetadataDocumentException, DOMException {
        org.w3c.dom.Element proxyNode = domDocument.createElementNS("http://www.clarin.eu/cmd/", "ResourceProxy");
        proxyNode.setAttribute("id", resourceProxy.getId());
        proxiesNode.appendChild(proxyNode);
        org.w3c.dom.Element resourceTypeNode = domDocument.createElementNS("http://www.clarin.eu/cmd/", "ResourceType");
        resourceTypeNode.setTextContent(resourceProxy.getType());
        if (resourceProxy.getMimetype() != null) {
            resourceTypeNode.setAttribute("mimetype", resourceProxy.getMimetype());
        }
        proxyNode.appendChild(resourceTypeNode);
        org.w3c.dom.Element resourceRefNode = domDocument.createElementNS("http://www.clarin.eu/cmd/", "ResourceRef");
        URI resourceProxyUri = resourceProxy.getURI();
        String resourceProxyUriStr = "";
        if (resourceProxyUri != null) {
            resourceProxyUriStr = resourceProxyUri.toString();
        }
        resourceRefNode.setTextContent(resourceProxyUriStr);
        if (resourceProxy.getLocation() != null) {
            resourceRefNode.setAttributeNS("http://lat.mpi.nl/", "lat:localURI", resourceProxy.getLocation().toString());
        }
        proxyNode.appendChild(resourceRefNode);
    }

    private void buildComponents(CMDIDocument metadataDocument, Document domDocument, XPathFactory xPathFactory) throws MetadataDocumentException {
        try {
            String schemaLocation = metadataDocument.getType().getSchemaLocation().toString();
            Node componentsNode = (Node)this.newXPath(xPathFactory).evaluate("/cmd:CMD/cmd:Components", domDocument, XPathConstants.NODE);
            this.buildMetadataElement(domDocument, componentsNode, metadataDocument, schemaLocation, xPathFactory, false);
        }
        catch (DOMException domEx) {
            throw new MetadataDocumentException(metadataDocument, "DOMException while building components in DOM", domEx);
        }
        catch (XPathExpressionException tEx) {
            throw new MetadataDocumentException(metadataDocument, "XPathExpressionException while building components in DOM", tEx);
        }
    }

    private void buildMetadataElement(Document domDocument, Node parentNode, CMDIMetadataElement metadataElement, String schemaLocation, XPathFactory xPathFactory, boolean forceDirty) throws DOMException, XPathExpressionException {
        boolean dirty;
        org.w3c.dom.Element elementNode;
        logger.debug("Building metadata element [{}]", (Object)metadataElement);
        SchemaProperty elementSchemaProperty = metadataElement.getType().getSchemaElement();
        try {
            elementNode = parentNode == null ? (org.w3c.dom.Element)this.newXPath(xPathFactory).evaluate(metadataElement.getPathString(), domDocument, XPathConstants.NODE) : (org.w3c.dom.Element)this.newXPath(xPathFactory).evaluate(metadataElement.getPathString(), parentNode, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            logger.error("XPathExpressionException encountered looking up {} in document {}, parent node {}", new Object[]{metadataElement.getPathString(), domDocument, parentNode});
            throw ex;
        }
        boolean bl = dirty = metadataElement.isDirty() || forceDirty;
        if (dirty) {
            logger.debug("Metadata element is dirty. Rewriting component in DOM.");
            if (elementNode != null) {
                parentNode.removeChild(elementNode);
            }
            elementNode = this.appendElementNode(domDocument, schemaLocation, parentNode, elementSchemaProperty, false);
            if (metadataElement instanceof Element) {
                Object elementValue = ((Element)metadataElement).getValue();
                elementNode.setTextContent(elementValue == null ? "" : elementValue.toString());
            }
            this.buildElementAttributes(domDocument, elementNode, metadataElement);
            this.buildProxyReferences(metadataElement, elementNode);
            metadataElement.setDirty(false);
        } else {
            logger.debug("Metadata element not marked dirty. Leaving as is in DOM.");
        }
        if (metadataElement instanceof CMDIContainerMetadataElement) {
            if (logger.isDebugEnabled()) {
                logger.debug("Element is container. Iterating over {} child elements", (Object)((CMDIContainerMetadataElement)metadataElement).getChildrenCount());
            }
            for (MetadataElement child : ((CMDIContainerMetadataElement)metadataElement).getChildren()) {
                this.buildMetadataElement(domDocument, elementNode, (CMDIMetadataElement)child, schemaLocation, xPathFactory, dirty);
            }
        }
    }

    private void buildElementAttributes(Document domDocument, org.w3c.dom.Element elementNode, CMDIMetadataElement metadataElement) throws DOMException {
        for (Attribute attribute : metadataElement.getAttributes()) {
            if (attribute.getType() instanceof CMDIAttributeType) {
                Attr attrNode = this.appendAttributeNode(domDocument, elementNode, ((CMDIAttributeType)attribute.getType()).getSchemaElement());
                attrNode.setNodeValue(attribute.getValue().toString());
                continue;
            }
            logger.info("Found attribute of type other than CMDIAttributeType. Skipping attribute {}", (Object)attribute);
        }
        if (metadataElement instanceof MultilingualElement) {
            this.buildLanguageAttribute(domDocument, elementNode, (MultilingualElement)metadataElement);
        }
    }

    private void buildLanguageAttribute(Document domDocument, org.w3c.dom.Element elementNode, MultilingualElement metadataElement) throws DOMException {
        MetadataElementAttributeType languageAttributeType;
        if (metadataElement.getLanguage() != null && (languageAttributeType = metadataElement.getType().getAttributeTypeByName("http://www.w3.org/XML/1998/namespace", "lang")) instanceof CMDIAttributeType) {
            Attr attrNode = this.appendAttributeNode(domDocument, elementNode, ((CMDIAttributeType)languageAttributeType).getSchemaElement());
            attrNode.setNodeValue(metadataElement.getLanguage());
        }
    }

    private void buildProxyReferences(CMDIMetadataElement metadataElement, org.w3c.dom.Element elementNode) throws DOMException {
        List<Reference> references = metadataElement.getReferences();
        if (references.size() > 0) {
            StringBuilder refBuilder = new StringBuilder();
            for (Reference resourceProxy : references) {
                refBuilder.append(((ResourceProxy)resourceProxy).getId()).append(" ");
            }
            elementNode.setAttribute("ref", refBuilder.toString().trim());
        }
    }

    public final Document createDomFromSchema(URI xsdFile, DomBuildingMode buildingMode) throws FileNotFoundException, XmlException, MalformedURLException, IOException {
        Document workingDocument = this.domBuilderFactory.newDOMBuilder().newDocument();
        SchemaType schemaType = this.getFirstSchemaType(xsdFile);
        this.constructXml(schemaType.getElementProperties()[0], workingDocument, xsdFile.toString(), null, buildingMode);
        return this.reloadDom(workingDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaType getFirstSchemaType(URI uri) throws FileNotFoundException, XmlException, MalformedURLException, IOException {
        InputStream inputStream = CMDIEntityResolver.getInputStreamForURI(this.entityResolver, uri);
        try {
            XmlOptions xmlOptions = new XmlOptions();
            xmlOptions.setCharacterEncoding("UTF-8");
            xmlOptions.setEntityResolver(this.getEntityResolver());
            SchemaTypeSystem sts = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{XmlObject.Factory.parse((InputStream)inputStream, (XmlOptions)xmlOptions)}, (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), (XmlOptions)xmlOptions);
            SchemaType schemaType = sts.documentTypes()[0];
            return schemaType;
        }
        finally {
            inputStream.close();
        }
    }

    private Node constructXml(SchemaProperty currentSchemaProperty, Document workingDocument, String nameSpaceUri, org.w3c.dom.Element parentElement, DomBuildingMode buildingMode) {
        SchemaType currentSchemaType = currentSchemaProperty.getType();
        Node currentElement = this.appendNode(workingDocument, nameSpaceUri, parentElement, currentSchemaProperty, true);
        if (DomBuildingMode.EMPTY != buildingMode || !this.shouldTerminateEmptyModeBuilding(currentElement)) {
            for (SchemaProperty schemaProperty : currentSchemaType.getElementProperties()) {
                BigInteger maxNumberToAdd;
                if (DomBuildingMode.DUMMY == buildingMode) {
                    maxNumberToAdd = schemaProperty.getMaxOccurs();
                    if (maxNumberToAdd == null) {
                        maxNumberToAdd = DUMMY_NUMBER_TO_ADD;
                    } else if (DUMMY_NUMBER_TO_ADD.compareTo(maxNumberToAdd) == -1) {
                        maxNumberToAdd = DUMMY_NUMBER_TO_ADD;
                    }
                } else {
                    maxNumberToAdd = schemaProperty.getMinOccurs();
                    if (maxNumberToAdd == null) {
                        maxNumberToAdd = BigInteger.ZERO;
                    }
                }
                if (!(currentElement instanceof org.w3c.dom.Element)) continue;
                BigInteger addNodeCounter = BigInteger.ZERO;
                while (addNodeCounter.compareTo(maxNumberToAdd) < 0) {
                    this.constructXml(schemaProperty, workingDocument, nameSpaceUri, (org.w3c.dom.Element)currentElement, buildingMode);
                    addNodeCounter = addNodeCounter.add(BigInteger.ONE);
                }
            }
        }
        return currentElement;
    }

    private boolean shouldTerminateEmptyModeBuilding(Node currentElement) {
        return currentElement.getParentNode().getNodeName().equals("Components");
    }

    private Node appendNode(Document workingDocument, String nameSpaceUri, org.w3c.dom.Element parentElement, SchemaProperty schemaProperty, boolean addRequiredAttributes) {
        if (schemaProperty.isAttribute()) {
            return this.appendAttributeNode(workingDocument, parentElement, schemaProperty);
        }
        return this.appendElementNode(workingDocument, nameSpaceUri, parentElement, schemaProperty, addRequiredAttributes);
    }

    private Attr appendAttributeNode(Document workingDocument, org.w3c.dom.Element parentElement, SchemaProperty schemaProperty) {
        Attr currentAttribute = workingDocument.createAttributeNS(schemaProperty.getName().getNamespaceURI(), this.getPrefixedName(schemaProperty));
        if (schemaProperty.getDefaultText() != null) {
            currentAttribute.setNodeValue(schemaProperty.getDefaultText());
        }
        parentElement.setAttributeNode(currentAttribute);
        return currentAttribute;
    }

    private org.w3c.dom.Element appendElementNode(Document workingDocument, String nameSpaceUri, Node parentElement, SchemaProperty schemaProperty, boolean addRequiredAttributes) {
        org.w3c.dom.Element currentElement = workingDocument.createElementNS(schemaProperty.getName().getNamespaceURI(), this.getPrefixedName(schemaProperty));
        SchemaType currentSchemaType = schemaProperty.getType();
        if (addRequiredAttributes) {
            for (SchemaProperty attributesProperty : currentSchemaType.getAttributeProperties()) {
                if (attributesProperty.getMinOccurs() == null || attributesProperty.getMinOccurs().equals(BigInteger.ZERO)) continue;
                currentElement.setAttributeNS(attributesProperty.getName().getNamespaceURI(), attributesProperty.getName().getLocalPart(), attributesProperty.getDefaultText());
            }
        }
        if (parentElement == null) {
            currentElement.setAttribute("CMDVersion", "1.1");
            currentElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            currentElement.setAttribute("xsi:schemaLocation", "http://www.clarin.eu/cmd/ " + nameSpaceUri);
            workingDocument.appendChild(currentElement);
        } else {
            parentElement.appendChild(currentElement);
        }
        return currentElement;
    }

    private Document reloadDom(Document document) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            StreamResult xmlOutput = new StreamResult(outputStream);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(document), xmlOutput);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            return this.domBuilderFactory.newDOMBuilder().parse(inputStream);
        }
        catch (IOException ex) {
            throw new RuntimeException("Exception while reloading DOM", ex);
        }
        catch (SAXException ex) {
            throw new RuntimeException("Exception while reloading DOM", ex);
        }
        catch (TransformerException ex) {
            throw new RuntimeException("Exception while reloading DOM", ex);
        }
        catch (TransformerFactoryConfigurationError ex) {
            throw new RuntimeException("Exception while reloading DOM", ex);
        }
    }

    private String getPrefixedName(SchemaProperty schemaProperty) {
        String name = schemaProperty.getName().getLocalPart();
        if ("http://www.w3.org/XML/1998/namespace".equals(schemaProperty.getName().getNamespaceURI())) {
            name = "xml:" + name;
        }
        return name;
    }

    private EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    private XPath newXPath(XPathFactory factory) {
        XPath xPath = factory.newXPath();
        xPath.setNamespaceContext(new CMDINamespaceContext());
        return xPath;
    }
}

