/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api.model;

import java.net.URI;
import nl.mpi.metadata.api.model.DirtyStateProvider;
import nl.mpi.metadata.api.model.HandleCarrier;
import nl.mpi.metadata.api.model.Reference;
import nl.mpi.metadata.api.util.HandleUtil;

public abstract class ResourceProxy
implements Reference,
HandleCarrier,
DirtyStateProvider {
    private final String id;
    private final String type;
    private URI uri;
    private URI location;
    private String mimeType;
    private boolean dirty;
    private final HandleUtil handleUtil = new HandleUtil();

    public ResourceProxy(String id, URI uri, String type, String mimeType) {
        this(id, uri, null, type, mimeType);
    }

    public ResourceProxy(String id, URI uri, URI location, String type, String mimeType) {
        this.id = id;
        this.uri = uri;
        this.location = location;
        this.mimeType = mimeType;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public void setURI(URI uri) {
        this.uri = uri;
        this.setDirty(true);
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(URI url) {
        this.location = url;
        this.setDirty(true);
    }

    @Override
    public String getMimetype() {
        return this.mimeType;
    }

    @Override
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
        this.setDirty(true);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceProxy other = (ResourceProxy)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return this.uri == other.uri || this.uri != null && this.uri.equals(other.uri);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 53 * hash + (this.uri != null ? this.uri.hashCode() : 0);
        return hash;
    }

    @Override
    public URI getHandle() {
        return this.handleUtil.createHandleUri(String.valueOf(this.getURI()));
    }

    @Override
    public void setHandle(URI handle) throws IllegalArgumentException {
        if (!this.handleUtil.isHandleUri(handle)) {
            throw new IllegalArgumentException("Illegal handle URI: " + handle.toString());
        }
        this.setURI(handle);
    }

    public String toString() {
        return String.format("{%1$s} %2$s", this.getId(), this.getURI());
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

