/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api.model.impl;

import nl.mpi.metadata.api.type.MetadataElementAttributeType;
import nl.mpi.metadata.cmdi.api.model.Attribute;
import nl.mpi.metadata.cmdi.api.model.CMDIMetadataElement;
import nl.mpi.metadata.cmdi.api.model.impl.CMDIMetadataElementImpl;
import nl.mpi.metadata.cmdi.api.type.impl.CMDIAttributeTypeImpl;

public class AttributeImpl<T>
implements Attribute<T> {
    private final MetadataElementAttributeType type;
    private final CMDIMetadataElement parent;
    private transient String pathString;
    private T value;

    public AttributeImpl(MetadataElementAttributeType type, CMDIMetadataElement parent) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("Type cannot be null for a new Attribute");
        }
        this.type = type;
        this.parent = parent;
    }

    @Override
    public MetadataElementAttributeType getType() {
        return this.type;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
        this.parent.setDirty(true);
    }

    @Override
    public synchronized String getPathString() {
        if (this.pathString == null) {
            String nsURI = this.getType().getNamespaceURI();
            String localPart = this.getType().getName();
            this.pathString = this.parent instanceof CMDIMetadataElementImpl ? CMDIAttributeTypeImpl.createAttributePathString(((CMDIMetadataElementImpl)this.parent).getPathCharSequence(), nsURI, localPart) : CMDIAttributeTypeImpl.createAttributePathString(this.parent.getPathString(), nsURI, localPart);
        }
        return this.pathString;
    }

    public String toString() {
        return String.format("[@%1$s=%2$s]", this.getType().getName(), this.getValue());
    }
}

