/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api.model.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import nl.mpi.metadata.api.MetadataElementException;
import nl.mpi.metadata.api.MetadataException;
import nl.mpi.metadata.api.events.MetadataDocumentListener;
import nl.mpi.metadata.api.model.HeaderInfo;
import nl.mpi.metadata.api.model.MetadataElement;
import nl.mpi.metadata.api.model.Reference;
import nl.mpi.metadata.api.util.HandleUtil;
import nl.mpi.metadata.cmdi.api.model.CMDIDocument;
import nl.mpi.metadata.cmdi.api.model.CMDIMetadataElement;
import nl.mpi.metadata.cmdi.api.model.DataResourceProxy;
import nl.mpi.metadata.cmdi.api.model.MetadataResourceProxy;
import nl.mpi.metadata.cmdi.api.model.ResourceProxy;
import nl.mpi.metadata.cmdi.api.model.SettableDirtyStateProvider;
import nl.mpi.metadata.cmdi.api.model.impl.CMDIContainerMetadataElementImpl;
import nl.mpi.metadata.cmdi.api.model.impl.SettableDirtyStateProviderImpl;
import nl.mpi.metadata.cmdi.api.type.CMDIProfile;
import nl.mpi.metadata.cmdi.api.type.CMDIProfileElement;
import nl.mpi.metadata.cmdi.api.type.CMDITypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMDIDocumentImpl
extends CMDIContainerMetadataElementImpl
implements CMDIDocument {
    private static final Logger logger = LoggerFactory.getLogger(CMDIDocumentImpl.class);
    private final CMDIProfile profile;
    private final List<HeaderInfo> headerInfo;
    private final Map<String, ResourceProxy> resourceProxies;
    private final Map<Reference, Collection<CMDIMetadataElement>> resourceProxyReferences;
    private final Collection<MetadataDocumentListener> listeners;
    private final SettableDirtyStateProvider headerDirtyState;
    private final SettableDirtyStateProvider resourceProxiesDirtyState;
    private URI fileLocation;
    private final HandleUtil handleUtil = new HandleUtil();

    public CMDIDocumentImpl(CMDIProfile profile) {
        this(profile, null);
    }

    public CMDIDocumentImpl(CMDIProfile profile, URI fileLocation) {
        super(profile);
        this.profile = profile;
        this.fileLocation = fileLocation;
        this.headerInfo = new LinkedList<HeaderInfo>();
        this.resourceProxies = new LinkedHashMap<String, ResourceProxy>();
        this.resourceProxyReferences = new HashMap<Reference, Collection<CMDIMetadataElement>>();
        this.listeners = new HashSet<MetadataDocumentListener>();
        this.headerDirtyState = new SettableDirtyStateProviderImpl(true);
        this.resourceProxiesDirtyState = new ResourceProxyDirtyStateProvider(true);
    }

    @Override
    public CMDIProfile getType() {
        return this.profile;
    }

    @Override
    public CMDIProfile getDocumentType() {
        return this.getType();
    }

    @Override
    public URI getFileLocation() {
        return this.fileLocation;
    }

    @Override
    public void setFileLocation(URI location) {
        this.fileLocation = location;
    }

    @Override
    public synchronized void putHeaderInformation(HeaderInfo headerInfoItem) throws CMDITypeException, MetadataElementException {
        if (this.profile.getHeaderNames().contains(headerInfoItem.getName())) {
            HeaderInfo oldInfo = this.getHeaderInformation(headerInfoItem.getName());
            if (oldInfo == null) {
                logger.debug("Creating new header {} on {}", (Object)headerInfoItem, (Object)this);
                this.addNewHeaderInfo(headerInfoItem);
            } else {
                logger.debug("Replacing old header {} with {} on {}", new Object[]{oldInfo, headerInfoItem, this});
                this.replaceHeaderInfo(oldInfo, headerInfoItem);
            }
        } else {
            throw new CMDITypeException((CMDIProfileElement)this.profile, "Profile does not support header with name " + headerInfoItem.getName());
        }
        this.headerDirtyState.setDirty(true);
    }

    private void addNewHeaderInfo(HeaderInfo headerInfoItem) throws MetadataElementException {
        HeaderInfo insertBeforeHeaderInfo = this.getInsertBeforeHeaderInfo(headerInfoItem);
        if (insertBeforeHeaderInfo == null) {
            if (!this.headerInfo.add(headerInfoItem)) {
                throw new MetadataElementException((MetadataElement)this, String.format("Failed to add header info item %1$s", headerInfoItem));
            }
        } else {
            this.headerInfo.add(this.headerInfo.indexOf(insertBeforeHeaderInfo), headerInfoItem);
        }
    }

    private HeaderInfo getInsertBeforeHeaderInfo(HeaderInfo headerInfoItem) {
        String itemName = headerInfoItem.getName();
        List<String> profileHeaderNames = this.profile.getHeaderNames();
        for (int index = profileHeaderNames.indexOf(itemName) + 1; index < profileHeaderNames.size(); ++index) {
            HeaderInfo nextItem = this.getHeaderInformation(profileHeaderNames.get(index));
            if (nextItem == null) continue;
            return nextItem;
        }
        return null;
    }

    private void replaceHeaderInfo(HeaderInfo oldInfo, HeaderInfo newInfo) {
        int index = this.headerInfo.indexOf(oldInfo);
        this.headerInfo.remove(oldInfo);
        this.headerInfo.add(index, newInfo);
    }

    @Override
    public synchronized HeaderInfo getHeaderInformation(String name) {
        for (HeaderInfo info : this.headerInfo) {
            if (!info.getName().equals(name)) continue;
            return info;
        }
        return null;
    }

    @Override
    public synchronized void removeHeaderInformation(String name) {
        HeaderInfo info = this.getHeaderInformation(name);
        if (info != null) {
            this.headerInfo.remove(info);
            this.headerDirtyState.setDirty(true);
        }
    }

    @Override
    public synchronized List<HeaderInfo> getHeaderInformation() {
        return Collections.unmodifiableList(this.headerInfo);
    }

    @Override
    public synchronized ResourceProxy getDocumentResourceProxy(String id) {
        return this.resourceProxies.get(id);
    }

    @Override
    public synchronized ResourceProxy getDocumentReferenceByURI(URI uri) {
        for (ResourceProxy proxy : this.resourceProxies.values()) {
            if (!proxy.getURI().equals(uri)) continue;
            return proxy;
        }
        return null;
    }

    @Override
    public synchronized ResourceProxy getDocumentReferenceByLocation(URI location) {
        for (ResourceProxy proxy : this.resourceProxies.values()) {
            if (proxy.getLocation() == null || !proxy.getLocation().equals(location)) continue;
            return proxy;
        }
        return null;
    }

    @Override
    public synchronized void addDocumentResourceProxy(ResourceProxy resourceProxy) {
        this.resourceProxies.put(resourceProxy.getId(), resourceProxy);
        this.resourceProxiesDirtyState.setDirty(true);
    }

    @Override
    public synchronized DataResourceProxy createDocumentResourceReference(URI uri, String type, String mimetype) throws MetadataException {
        return this.newResourceReference(uri, null, type, mimetype);
    }

    @Override
    public synchronized DataResourceProxy createDocumentResourceReference(URI uri, URI location, String type, String mimetype) throws MetadataException {
        return this.newResourceReference(uri, location, type, mimetype);
    }

    @Override
    public synchronized Collection<MetadataElement> getResourceProxyReferences(Reference proxy) {
        Collection<CMDIMetadataElement> references = this.resourceProxyReferences.get(proxy);
        if (references == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(references);
    }

    @Override
    public synchronized void registerResourceProxyReference(ResourceProxy proxy, CMDIMetadataElement referencingElement) {
        Collection<CMDIMetadataElement> references = this.resourceProxyReferences.get(proxy);
        if (references == null) {
            references = new HashSet<CMDIMetadataElement>();
            this.resourceProxyReferences.put(proxy, references);
        }
        references.add(referencingElement);
    }

    @Override
    public synchronized boolean unregisterResourceProxyReference(ResourceProxy proxy, CMDIMetadataElement referencingElement) {
        Collection<CMDIMetadataElement> references = this.resourceProxyReferences.get(proxy);
        if (references != null) {
            return references.remove(referencingElement);
        }
        return false;
    }

    @Override
    public MetadataResourceProxy createDocumentMetadataReference(URI uri, String mimetype) throws MetadataException {
        return this.newMetadataReference(uri, null, mimetype);
    }

    @Override
    public MetadataResourceProxy createDocumentMetadataReference(URI uri, URI location, String mimetype) throws MetadataException {
        return this.newMetadataReference(uri, location, mimetype);
    }

    private static String newResourceProxyId(String prefix) {
        return prefix + UUID.randomUUID().toString();
    }

    @Override
    public synchronized void removeDocumentResourceProxy(String id) {
        this.resourceProxies.remove(id);
        this.resourceProxiesDirtyState.setDirty(true);
    }

    @Override
    public ResourceProxy removeDocumentReference(ResourceProxy reference) {
        this.removeDocumentResourceProxy(reference.getId());
        return reference;
    }

    @Override
    public int getDocumentReferencesCount() {
        return this.resourceProxies.size();
    }

    @Override
    public List<Reference> getDocumentReferences() {
        Collection<ResourceProxy> proxies = this.resourceProxies.values();
        if (proxies instanceof List) {
            return Collections.unmodifiableList((List)proxies);
        }
        return Collections.unmodifiableList(new ArrayList<ResourceProxy>(proxies));
    }

    @Override
    public synchronized void addMetadataDocumentListener(MetadataDocumentListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeMetadataDocumentListener(MetadataDocumentListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Collection<MetadataDocumentListener> getMetadataDocumentListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    @Override
    public CMDIDocument getMetadataDocument() {
        return this;
    }

    @Override
    public URI getHandle() {
        HeaderInfo handleInfo = this.getHeaderInformation("MdSelfLink");
        if (handleInfo != null && handleInfo.getValue() != null) {
            return this.handleUtil.createHandleUri(handleInfo.getValue().toString());
        }
        return null;
    }

    @Override
    public void setHandle(URI handle) throws MetadataException {
        if (handle == null) {
            logger.debug("Removing handle of {}", (Object)this);
            this.removeHeaderInformation("MdSelfLink");
        } else if (this.handleUtil.isHandleUri(handle)) {
            logger.debug("Setting handle of {} to {}", (Object)this, (Object)handle);
            this.putHeaderInformation(new HeaderInfo("MdSelfLink", handle.toString()));
        } else {
            throw new IllegalArgumentException("Illegal handle URI: " + handle.toString());
        }
    }

    @Override
    protected final CharSequence getPathCharSequence() {
        return this.getType().getPath();
    }

    @Override
    public void setAllClean() {
        logger.trace("Marking {} all clean", (Object)this);
        this.setDirty(false);
        this.headerDirtyState.setDirty(false);
        this.resourceProxiesDirtyState.setDirty(false);
    }

    @Override
    public SettableDirtyStateProvider getHeaderDirtyState() {
        return this.headerDirtyState;
    }

    @Override
    public SettableDirtyStateProvider getResourceProxiesDirtyState() {
        return this.resourceProxiesDirtyState;
    }

    private MetadataResourceProxy newMetadataReference(URI uri, URI location, String mimetype) throws MetadataException {
        ResourceProxy resourceProxy = this.getDocumentReferenceByURI(uri);
        if (resourceProxy == null) {
            MetadataResourceProxy newResourceProxy = new MetadataResourceProxy(CMDIDocumentImpl.newResourceProxyId("m"), uri, location, mimetype);
            this.addDocumentResourceProxy(newResourceProxy);
            return newResourceProxy;
        }
        if (resourceProxy instanceof MetadataResourceProxy) {
            return (MetadataResourceProxy)resourceProxy;
        }
        throw new MetadataException(String.format("Resource proxy conflict: %1$s found while trying to add MetadataResourceProxy", resourceProxy.getClass()));
    }

    private DataResourceProxy newResourceReference(URI uri, URI location, String type, String mimetype) throws MetadataException {
        ResourceProxy resourceProxy = this.getDocumentReferenceByURI(uri);
        if (resourceProxy == null) {
            if (type == null) {
                type = "Resource";
            }
            DataResourceProxy newResourceProxy = new DataResourceProxy(CMDIDocumentImpl.newResourceProxyId("r"), uri, location, type, mimetype);
            this.addDocumentResourceProxy(newResourceProxy);
            return newResourceProxy;
        }
        if (resourceProxy instanceof DataResourceProxy) {
            return (DataResourceProxy)resourceProxy;
        }
        throw new MetadataException(String.format("Resource proxy conflict: %1$s found while trying to add DataResourceProxy", resourceProxy.getClass()));
    }

    @Override
    public String getDisplayValue() {
        String displayValue = null;
        displayValue = super.getDisplayValue();
        return displayValue;
    }

    private class ResourceProxyDirtyStateProvider
    extends SettableDirtyStateProviderImpl {
        public ResourceProxyDirtyStateProvider(boolean dirty) {
            super(dirty);
        }

        @Override
        public boolean isDirty() {
            return super.isDirty() || this.documentHasDirtyHeaders();
        }

        private boolean documentHasDirtyHeaders() {
            for (ResourceProxy proxy : CMDIDocumentImpl.this.resourceProxies.values()) {
                if (!proxy.isDirty()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void setDirty(boolean dirty) {
            super.setDirty(dirty);
            if (!dirty) {
                for (ResourceProxy proxy : CMDIDocumentImpl.this.resourceProxies.values()) {
                    proxy.setDirty(dirty);
                }
            }
        }
    }
}

