/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api.model.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import nl.mpi.metadata.api.MetadataException;
import nl.mpi.metadata.api.model.ContainedMetadataElement;
import nl.mpi.metadata.api.model.MetadataElement;
import nl.mpi.metadata.api.model.Reference;
import nl.mpi.metadata.cmdi.api.model.Attribute;
import nl.mpi.metadata.cmdi.api.model.CMDIMetadataElement;
import nl.mpi.metadata.cmdi.api.model.DataResourceProxy;
import nl.mpi.metadata.cmdi.api.model.MetadataResourceProxy;
import nl.mpi.metadata.cmdi.api.model.ResourceProxy;
import nl.mpi.metadata.cmdi.api.model.impl.CMDIContainerMetadataElementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CMDIMetadataElementImpl
implements CMDIMetadataElement {
    private static final Logger logger = LoggerFactory.getLogger(CMDIMetadataElementImpl.class);
    private final Collection<Attribute> attributes = new HashSet<Attribute>();
    private final List<ResourceProxy> resourceProxies = new ArrayList<ResourceProxy>();
    private CharSequence pathCharSequence = null;
    private boolean dirty = true;

    protected CMDIMetadataElementImpl() {
    }

    @Override
    public synchronized boolean addAttribute(Attribute attribute) {
        if (this.attributes.add(attribute)) {
            this.setDirty(true);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeAttribute(Attribute attribute) {
        if (this.attributes.remove(attribute)) {
            this.setDirty(true);
            return true;
        }
        return false;
    }

    @Override
    public synchronized Collection<Attribute> getAttributes() {
        return Collections.unmodifiableCollection(this.attributes);
    }

    @Override
    public synchronized ResourceProxy addDocumentResourceProxyReference(String id) {
        ResourceProxy resourceProxy = this.getMetadataDocument().getDocumentResourceProxy(id);
        if (resourceProxy != null && this.resourceProxies.add(resourceProxy)) {
            this.setDirty(true);
            this.getMetadataDocument().registerResourceProxyReference(resourceProxy, this);
            return resourceProxy;
        }
        return null;
    }

    @Override
    public synchronized ResourceProxy removeDocumentResourceProxyReference(String id) {
        ResourceProxy resourceProxy = this.getMetadataDocument().getDocumentResourceProxy(id);
        if (resourceProxy != null && this.resourceProxies.remove(resourceProxy)) {
            this.setDirty(true);
            if (!this.getMetadataDocument().unregisterResourceProxyReference(resourceProxy, this)) {
                logger.warn("Removed resource proxy with id {} was not registered with document!");
            }
            return resourceProxy;
        }
        return null;
    }

    @Override
    public int getReferencesCount() {
        return this.resourceProxies.size();
    }

    @Override
    public List<Reference> getReferences() {
        return Collections.unmodifiableList(this.resourceProxies);
    }

    @Override
    public DataResourceProxy createResourceReference(URI uri, String type, String mimetype) throws MetadataException {
        DataResourceProxy resourceProxy = this.getMetadataDocument().createDocumentResourceReference(uri, type, mimetype);
        return (DataResourceProxy)this.addDocumentResourceProxyReference(resourceProxy.getId());
    }

    @Override
    public MetadataResourceProxy createMetadataReference(URI uri, String mimetype) throws MetadataException {
        MetadataResourceProxy resourceProxy = this.getMetadataDocument().createDocumentMetadataReference(uri, mimetype);
        return (MetadataResourceProxy)this.addDocumentResourceProxyReference(resourceProxy.getId());
    }

    @Override
    public ResourceProxy removeReference(ResourceProxy reference) throws MetadataException {
        return this.removeDocumentResourceProxyReference(reference.getId());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public final String getPathString() {
        return this.getPathCharSequence().toString();
    }

    protected synchronized CharSequence getPathCharSequence() throws AssertionError {
        if (this.pathCharSequence == null) {
            if (this instanceof ContainedMetadataElement) {
                CMDIContainerMetadataElementImpl parentContainer = (CMDIContainerMetadataElementImpl)((ContainedMetadataElement)((Object)this)).getParent();
                List<MetadataElement> siblings = parentContainer.getChildren(this.getType());
                int index = siblings.indexOf(this);
                if (index < 0) {
                    throw new RuntimeException("Node not found in parent's children");
                }
                StringBuilder pathStringBuilder = new StringBuilder(parentContainer.getPathCharSequence());
                pathStringBuilder.append("/cmd:").append(this.getType().getName());
                pathStringBuilder.append("[").append(index + 1).append("]");
                this.pathCharSequence = pathStringBuilder;
            } else {
                throw new AssertionError((Object)("Element path cannot be determined for class " + this.getClass() + " because it does not implement ContainedMetadataElement"));
            }
        }
        return this.pathCharSequence;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }
}

