/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api.model.impl;

import nl.mpi.metadata.api.events.MetadataElementListener;
import nl.mpi.metadata.cmdi.api.model.CMDIContainerMetadataElement;
import nl.mpi.metadata.cmdi.api.model.CMDIDocument;
import nl.mpi.metadata.cmdi.api.model.Element;
import nl.mpi.metadata.cmdi.api.model.impl.CMDIMetadataElementImpl;
import nl.mpi.metadata.cmdi.api.model.impl.DisplayValueStrategy;
import nl.mpi.metadata.cmdi.api.type.ElementType;

public class ElementImpl<T>
extends CMDIMetadataElementImpl
implements Element<T> {
    private final CMDIDocument metadataDocument;
    private final CMDIContainerMetadataElement parent;
    private final ElementType elementType;
    private T value;

    public ElementImpl(ElementType elementType, CMDIContainerMetadataElement parent) {
        this(elementType, parent, null);
    }

    public ElementImpl(ElementType elementType, CMDIContainerMetadataElement parent, T value) {
        this.elementType = elementType;
        this.value = value;
        this.parent = parent;
        this.metadataDocument = parent.getMetadataDocument();
    }

    @Override
    public String getName() {
        return this.elementType.getName();
    }

    @Override
    public String getDisplayValue() {
        return this.getValue() == null ? null : this.getValue().toString();
    }

    @Override
    public String getDisplayValue(DisplayValueStrategy strategy) {
        return this.getValue() == null ? null : this.getValue().toString();
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        if (value != null && !value.equals(this.value) || value == null && this.value != null) {
            this.setDirty(true);
        }
        this.value = value;
    }

    public CMDIContainerMetadataElement getParent() {
        return this.parent;
    }

    @Override
    public ElementType getType() {
        return this.elementType;
    }

    @Override
    public CMDIDocument getMetadataDocument() {
        return this.metadataDocument;
    }

    @Override
    public void addMetadataElementListener(MetadataElementListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeMetadataElementListener(MetadataElementListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String toString() {
        return String.format("[%1$s=%2$s]", this.getType().getName(), this.getValue());
    }
}

