/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api.type.impl;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import nl.mpi.metadata.api.MetadataTypeException;
import nl.mpi.metadata.api.type.MetadataDocumentTypeReader;
import nl.mpi.metadata.cmdi.api.type.CMDIProfile;
import nl.mpi.metadata.cmdi.api.type.CMDIProfileContainer;

public class CMDIProfileContainerImpl
implements CMDIProfileContainer {
    private final Map<URI, CMDIProfile> profileMap;
    private final MetadataDocumentTypeReader<CMDIProfile> profileReader;

    public CMDIProfileContainerImpl(MetadataDocumentTypeReader<CMDIProfile> profileReader) {
        this.profileReader = profileReader;
        this.profileMap = new HashMap<URI, CMDIProfile>();
    }

    @Override
    public synchronized CMDIProfile getProfile(URI profileUri) throws IOException, MetadataTypeException {
        CMDIProfile profile = this.profileMap.get(profileUri);
        if (profile == null) {
            profile = this.profileReader.read(profileUri);
            this.profileMap.put(profileUri, profile);
        }
        return profile;
    }

    @Override
    public synchronized boolean containsProfile(URI profileUri) {
        return this.profileMap.containsKey(profileUri);
    }

    @Override
    public synchronized boolean containsProfile(CMDIProfile profile) {
        return this.profileMap.containsValue(profile);
    }
}

