/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.identifierresolver;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import nl.mpi.metadata.api.model.MetadataDocument;
import nl.mpi.metadata.identifierresolver.IdentifierResolutionException;
import nl.mpi.metadata.identifierresolver.IdentifierResolver;

public class HandleResolver
implements IdentifierResolver {
    public static final String HANDLE_PROXY_SERVER = "hdl.handle.net";

    @Override
    public boolean canResolve(MetadataDocument document, URI identifier) {
        return identifier.isAbsolute() && identifier.getScheme().equalsIgnoreCase("hdl");
    }

    @Override
    public URL resolveIdentifier(MetadataDocument document, URI identifier) throws IdentifierResolutionException {
        if ("hdl".equalsIgnoreCase(identifier.getScheme())) {
            try {
                return new URL("http", HANDLE_PROXY_SERVER, "/" + identifier.getSchemeSpecificPart());
            }
            catch (MalformedURLException ex) {
                throw new IdentifierResolutionException("Could not resolve handle", ex);
            }
        }
        throw new IdentifierResolutionException("Cannot resolve handle with scheme other than 'hdl': " + identifier.getScheme());
    }
}

