/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.tools.data;

public class AnnexFileTypes {
    private static final String[] fileTypeNames = new String[]{"eaf", "chat", "shoebox", "plainText", "htmlText", "xmlText", "csvText", "pdf", "subRip", "textGrid"};
    public static final int UNKNOWN_TYPE = -1;
    public static final int EAF_TYPE = 0;
    public static final int CHAT_TYPE = 1;
    public static final int SHOEBOX_TYPE = 2;
    public static final int TEXT_PLAIN_TYPE = 3;
    public static final int TEXT_HTML_TYPE = 4;
    public static final int TEXT_XML_TYPE = 5;
    public static final int TEXT_CSV_TYPE = 6;
    public static final int PDF_TYPE = 7;
    public static final int TEXT_SUBRIP_TYPE = 8;
    public static final int TEXT_TEXTGRID_TYPE = 9;
    public static final int EOF_TYPE = 42;

    public static String getFileTypeName(int type) {
        return type >= 0 && type < fileTypeNames.length ? fileTypeNames[type] : "UNKNOWN";
    }

    public static int getFileTypeCount() {
        return fileTypeNames.length;
    }

    public static int getTypeFor(String format) {
        if (format.equals("text/x-eaf+xml")) {
            return 0;
        }
        if (format.equals("text/x-chat")) {
            return 1;
        }
        if (format.equals("text/x-shoebox-text")) {
            return 2;
        }
        if (format.equals("text/x-toolbox-text")) {
            return 2;
        }
        if (format.equals("text/plain")) {
            return 3;
        }
        if (format.equals("text/xml")) {
            return 5;
        }
        if (format.equals("text/html")) {
            return 4;
        }
        if (format.equals("text/csv")) {
            return 6;
        }
        if (format.equals("application/pdf")) {
            return 7;
        }
        if (format.equals("text/x-subrip")) {
            return 8;
        }
        if (format.equals("text/praat-textgrid")) {
            return 9;
        }
        return -1;
    }

    public static String[] getMimeTypesForParserType(int type) {
        String[] mimeTypes = new String[1];
        switch (type) {
            case 0: {
                mimeTypes[0] = "text/x-eaf+xml";
                return mimeTypes;
            }
            case 1: {
                mimeTypes[0] = "text/x-chat";
                return mimeTypes;
            }
            case 2: {
                mimeTypes = new String[]{"text/x-shoebox-text", "text/x-toolbox-text"};
                return mimeTypes;
            }
            case 3: {
                mimeTypes[0] = "text/plain";
                return mimeTypes;
            }
            case 4: {
                mimeTypes[0] = "text/html";
                return mimeTypes;
            }
            case 5: {
                mimeTypes[0] = "text/xml";
                return mimeTypes;
            }
            case 6: {
                mimeTypes[0] = "text/csv";
                return mimeTypes;
            }
            case 7: {
                mimeTypes[0] = "application/pdf";
                return mimeTypes;
            }
            case 8: {
                mimeTypes[0] = "text/x-subrip";
                return mimeTypes;
            }
            case 9: {
                mimeTypes[0] = "text/praat-textgrid";
                return mimeTypes;
            }
        }
        return new String[0];
    }
}

