/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.tools.data;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import nl.mpi.annot.tools.data.AnnexMediaDescriptor;
import nl.mpi.annot.tools.data.AnnexParser;
import nl.mpi.annot.tools.data.AnnexTier;

public class AnnexTranscription
implements Serializable {
    private static final long serialVersionUID = 1367076256466204760L;
    private final String _nodeId;
    private final boolean _valid;
    private boolean _hasVirtualTime;
    private ArrayList<AnnexMediaDescriptor> _mediaDescriptors;
    private ArrayList<AnnexTier> _tiers;
    private final int _type;
    private String _info;

    public AnnexTranscription(String nodeId, int type, File file) {
        this._nodeId = nodeId;
        this._type = type;
        this._mediaDescriptors = new ArrayList();
        this._tiers = new ArrayList();
        this._valid = AnnexParser.parse(file, this._type, this);
        this.updateHasVirtualTime();
    }

    public AnnexTranscription(String nodeId, File file, File typFile) {
        this._nodeId = nodeId;
        this._type = 2;
        this._mediaDescriptors = new ArrayList();
        this._tiers = new ArrayList();
        AnnexParser.setTypFile(typFile);
        this._valid = AnnexParser.parse(file, this._type, this);
        this.updateHasVirtualTime();
    }

    private void updateHasVirtualTime() {
        this._hasVirtualTime = false;
        for (int i = 0; i < this._tiers.size(); ++i) {
            AnnexTier tier = this._tiers.get(i);
            if (!tier.hasVirtualTime) continue;
            this._hasVirtualTime = true;
            break;
        }
    }

    public boolean hasVirtualTime() {
        return this._hasVirtualTime;
    }

    public boolean isValid() {
        return this._valid;
    }

    public String getNodeId() {
        return this._nodeId;
    }

    public int getType() {
        return this._type;
    }

    public String getInfo() {
        return this._info;
    }

    public void setInfo(String info) {
        this._info = info;
    }

    public ArrayList<AnnexMediaDescriptor> getMediaDescriptors() {
        return this._mediaDescriptors;
    }

    public ArrayList<AnnexTier> getTiers() {
        return this._tiers;
    }

    public ArrayList<AnnexTier> getRealTiers() {
        ArrayList<AnnexTier> realTiers = new ArrayList<AnnexTier>();
        for (int i = 0; i < this._tiers.size(); ++i) {
            AnnexTier tier = this._tiers.get(i);
            if (tier.hasVirtualTime) continue;
            realTiers.add(tier);
        }
        return realTiers;
    }

    public ArrayList<AnnexTier> getVirtualTiers() {
        ArrayList<AnnexTier> virtualTiers = new ArrayList<AnnexTier>();
        for (int i = 0; i < this._tiers.size(); ++i) {
            AnnexTier tier = this._tiers.get(i);
            if (!tier.hasVirtualTime) continue;
            virtualTiers.add(tier);
        }
        return virtualTiers;
    }
}

