/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.tools.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.mpi.annot.tools.data.AnnexAnnotation;
import nl.mpi.annot.tools.data.AnnexTier;
import nl.mpi.annot.tools.data.AnnexTranscription;
import nl.mpi.annot.tools.data.DataUtil;

public class CSVParser {
    private static final boolean _debug = false;
    private static final boolean _verbose = false;
    private static final long _rowtime = 1000L;
    private static Logger _logger = Logger.getLogger(CSVParser.class.getName());

    public static String[] splitCSV(String input, int columns, char separator) throws IOException {
        if (input.indexOf(34) == -1) {
            String[] result = input.split("" + separator);
            if (columns > 0 && result.length > columns) {
                throw new IOException("Too many columns: " + result.length + ", not " + columns);
            }
            if (result.length == 0 || input.trim().length() == result.length - 1) {
                throw new IOException("No content found");
            }
            return result;
        }
        ArrayList<String> pieces = new ArrayList<String>();
        int length = input.length();
        StringBuilder piece = new StringBuilder(length);
        boolean quote = false;
        boolean used = false;
        for (int i = 0; i < length; ++i) {
            char current = input.charAt(i);
            if (current == '\"') {
                boolean bl = quote = !quote;
                if (i <= 0 || input.charAt(i - 1) != '\"') continue;
                piece.append('\"');
                used = true;
                continue;
            }
            if (current == separator && !quote) {
                pieces.add(piece.toString());
                piece = new StringBuilder(length - i);
                continue;
            }
            piece.append(current);
            used = true;
        }
        pieces.add(piece.toString());
        if (quote) {
            throw new IOException("Unbalanced quotes found");
        }
        if (!used) {
            throw new IOException("No content found");
        }
        if (columns > 0 && pieces.size() > columns) {
            throw new IOException("Too many columns: " + pieces.size() + ", not " + columns);
        }
        return pieces.toArray(new String[pieces.size()]);
    }

    public static String clip(String input, int max) {
        if (max < 3) {
            return "*?*";
        }
        if (input.length() < max) {
            return input;
        }
        return input.substring(0, max - 3) + "...";
    }

    public static void parseCSV(String[] lines, AnnexTranscription transcription) throws IOException {
        char separator = ';';
        String[] colnames = CSVParser.splitCSV(lines[0], -1, separator);
        int ncols = colnames.length;
        String[] colnamesComma = CSVParser.splitCSV(lines[0], -1, ',');
        if (colnamesComma.length > ncols) {
            _logger.log(Level.INFO, "CSV file seems to use ',' instead of ';' as separator: " + colnamesComma.length + " > " + ncols + " columns, switching to comma in: " + transcription.getNodeId());
            separator = ',';
            ncols = colnamesComma.length;
            colnames = colnamesComma;
        }
        int[] colusage = new int[ncols];
        AnnexTier[] tiers = new AnnexTier[ncols];
        for (int i = 0; i < ncols; ++i) {
            colusage[i] = 0;
            if (colnames[i].trim().length() == 0) {
                colnames[i] = "[COL_" + (i + 1) + "]";
            }
            tiers[i] = new AnnexTier(colnames[i], "text");
            tiers[i].participant = "unknown";
            tiers[i].hasVirtualTime = true;
            transcription.getTiers().add(tiers[i]);
        }
        int ncontentlines = 0;
        long fakeTime = 0L;
        for (int i = 1; i < lines.length; ++i) {
            if (lines[i].length() == 0) continue;
            if (lines[i].indexOf(separator) == -1) {
                _logger.log(Level.WARNING, "Skipped: Line contains no '" + separator + "' at all in: " + transcription.getNodeId() + " <" + CSVParser.clip(lines[i], 50) + ">");
                continue;
            }
            String[] cols = null;
            try {
                cols = CSVParser.splitCSV(lines[i], ncols, separator);
            }
            catch (IOException ioe) {
                _logger.log(Level.WARNING, "Skipped: " + ioe.getMessage() + " in: " + transcription.getNodeId() + " <" + CSVParser.clip(lines[i], 50) + ">");
                throw ioe;
            }
            ++ncontentlines;
            for (int j = 0; j < ncols; ++j) {
                String value;
                String string = value = j >= cols.length ? "" : cols[j].trim();
                if (value.length() <= 0) continue;
                int n = j;
                colusage[n] = colusage[n] + 1;
                tiers[j].annotations.add(new AnnexAnnotation(value, fakeTime, fakeTime + 1000L, false, cols[0].trim()));
            }
            fakeTime += 1000L;
        }
        StringBuilder usage = new StringBuilder("Column usage in " + lines.length);
        usage.append("/").append(ncontentlines);
        usage.append(" lines of ");
        usage.append(transcription.getNodeId());
        usage.append(": ");
        for (int i = 0; i < ncols; ++i) {
            if (colusage[i] == 0) {
                usage.append(i < ncols - 1 ? "-," : "-");
                continue;
            }
            if (colusage[i] == ncontentlines) {
                usage.append("+").append(i < ncols - 1 ? "," : "");
                continue;
            }
            usage.append(colusage[i] + (i < ncols - 1 ? "," : ""));
        }
        _logger.log(Level.INFO, usage.toString());
    }

    public static void main(String[] args) throws IOException {
        File file = new File(args[0]);
        String id = args[0].substring(args[0].lastIndexOf(47) + 1);
        DataUtil.readLines(file, DataUtil.getCharsetName(file));
        new AnnexTranscription(id, 6, file);
    }
}

