/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.tools.data;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import nl.mpi.annot.tools.util.CountHash;
import nl.mpi.annot.tools.util.UTF8Validator;

public class FlexEncReader
extends Reader {
    private static Logger _logger = Logger.getLogger(FlexEncReader.class.getName());
    protected static final int BUFFER_SIZE = 1024;
    protected static final int SUBBUFFER_SIZE = 8000;
    public static final boolean DEBUG = false;
    public static final byte SPACE_CHAR = 32;
    public static final byte BACKSLASH_CHAR = 92;
    public static final byte LF_CHAR = 10;
    public static final byte CR_CHAR = 13;
    private byte[] buffer;
    private int position;
    private int bytesInBuffer;
    private InputStream in;
    private String currentCharset;
    private HashMap<String, String> encodings;
    private boolean windowsLineDelim;
    private JTextArea textAreaGUI;

    public FlexEncReader(InputStream in, HashMap<String, String> encodings) {
        this.in = in;
        this.encodings = encodings;
        if (this.encodings == null) {
            this.encodings = new HashMap();
        }
        this.buffer = new byte[1024];
        this.currentCharset = "ISO-8859-1";
        this.windowsLineDelim = false;
    }

    public FlexEncReader(File infile) throws IOException, FileNotFoundException {
        this.in = new FileInputStream(infile);
        this.buffer = new byte[1024];
        try {
            this.encodings = this.guessUTF8(infile);
            this.in.close();
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, "IOException in guessUTF8: " + e + " for: " + infile);
            this.encodings = new HashMap();
            throw e;
        }
        this.position = 0;
        this.bytesInBuffer = 0;
        this.in = new FileInputStream(infile);
        this.currentCharset = "ISO-8859-1";
        this.windowsLineDelim = false;
    }

    private byte nextByte() throws EOFException, IOException {
        if (this.position == this.bytesInBuffer) {
            this.bytesInBuffer = this.in.read(this.buffer);
            this.position = 0;
        }
        if (this.bytesInBuffer > 0) {
            return this.buffer[this.position++];
        }
        throw new EOFException();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        throw new RuntimeException("not implemented. use readLine");
    }

    public String readTagOrContent(String charsetName) throws EOFException, IOException {
        byte[] subbuffer = new byte[8000];
        int pos = 0;
        boolean tag = false;
        subbuffer[0] = this.nextByte();
        if (subbuffer[0] == 92) {
            tag = true;
        } else if (subbuffer[0] == 10 || subbuffer[0] == 13) {
            return new String(subbuffer, 0, 1, charsetName);
        }
        do {
            if (++pos >= 8000) {
                throw new IOException("this implementation supports lines of max length 8000");
            }
            subbuffer[pos] = this.nextByte();
        } while ((!tag || subbuffer[pos] != 32) && subbuffer[pos] != 10 && subbuffer[pos] != 13);
        String result = null;
        result = tag ? new String(subbuffer, 0, pos + 1, "ISO-8859-1") : new String(subbuffer, 0, pos + 1, charsetName);
        return result;
    }

    public int readTagOrContent(byte[] subbuffer) throws EOFException, IOException {
        int pos = 0;
        boolean tag = false;
        subbuffer[0] = this.nextByte();
        if (subbuffer[0] == 92) {
            tag = true;
        } else if (subbuffer[0] == 10 || subbuffer[0] == 13) {
            return 1;
        }
        do {
            if (++pos >= 8000) {
                throw new IOException("this implementation supports lines of max length 8000");
            }
            subbuffer[pos] = this.nextByte();
        } while ((!tag || subbuffer[pos] != 32) && subbuffer[pos] != 10 && subbuffer[pos] != 13);
        return pos;
    }

    public String readLine() throws IOException {
        Object result = null;
        try {
            result = this.readTagOrContent(this.currentCharset);
        }
        catch (EOFException e) {
            return result;
        }
        if (((String)result).startsWith("\\")) {
            this.currentCharset = this.encodings.get(((String)result).substring(1, ((String)result).length() - 1));
            if (this.currentCharset == null) {
                this.currentCharset = "ISO-8859-1";
            }
            if (((String)result).charAt(((String)result).length() - 1) != '\n') {
                try {
                    result = (String)result + this.readTagOrContent(this.currentCharset);
                }
                catch (EOFException e) {
                    return result;
                }
            }
        }
        if (((String)result).equals("\n") && this.windowsLineDelim) {
            this.windowsLineDelim = false;
            return this.readLine();
        }
        this.windowsLineDelim = ((String)result).endsWith("\r");
        return ((String)result).substring(0, ((String)result).length() - 1);
    }

    private HashMap<String, String> guessUTF8(File infile) throws IOException {
        CountHash<String> multibytes = new CountHash<String>();
        CountHash<String> errors = new CountHash<String>();
        TreeSet<String> tags = new TreeSet<String>();
        byte[] subbuffer = new byte[8000];
        int pos = 0;
        String tag = "";
        try {
            while (true) {
                pos = this.readTagOrContent(subbuffer);
                if (subbuffer[0] == 92) {
                    tag = new String(subbuffer, 1, pos - 1, "ISO-8859-1");
                    continue;
                }
                int guess = UTF8Validator.validateUTF8(subbuffer, pos, false);
                tags.add(tag);
                if (guess == -1) {
                    errors.put(tag, 1);
                    continue;
                }
                if (guess <= 0) continue;
                multibytes.put(tag, guess);
            }
        }
        catch (EOFException guess) {
            HashMap<String, String> result = new HashMap<String, String>();
            HashMap<String, String> ascii = new HashMap<String, String>();
            for (String t : tags) {
                if (multibytes.getCount(t) == 0) {
                    if (errors.getCount(t) != 0) continue;
                    ascii.put(t, "ASCII");
                    continue;
                }
                if (errors.getCount(t) == 0) {
                    result.put(t, "UTF-8");
                    continue;
                }
                _logger.log(Level.SEVERE, "Mixed UTF-8 / Latin? Tag: " + t + " Multi: " + multibytes.getCount(t) + " Badmulti: " + errors.getCount(t) + " for: " + infile);
            }
            _logger.log(Level.FINE, "Encodings: " + (String)(ascii.isEmpty() ? "" : " ASCII: " + ascii.keySet()) + (String)(multibytes.isEmpty() ? "" : " multibytes: " + multibytes) + (String)(errors.isEmpty() ? "" : " extended: " + errors) + (String)(result.isEmpty() ? "" : " UTF-8: " + result.keySet()) + " for: " + infile);
            if (!errors.isEmpty() && !result.isEmpty()) {
                _logger.log(Level.WARNING, "File has both UTF-8 tiers and extended (Latin?) tiers: " + infile);
                throw new IOException("File mixes UTF-8 with incompatible encodings");
            }
            return result;
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public void buildGUI() {
        JFrame frame = new JFrame();
        this.textAreaGUI = new JTextArea();
        this.textAreaGUI.setFont(new Font("DejaVu Sans", 0, 12));
        frame.getContentPane().add(new JScrollPane(this.textAreaGUI));
        frame.pack();
        frame.setVisible(true);
    }

    private void test() {
        this.buildGUI();
        try {
            String line = null;
            while ((line = this.readLine()) != null) {
                _logger.log(Level.FINE, "[LINE] " + line);
                this.textAreaGUI.append(line + "\n");
            }
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, "IOException in test: " + e);
        }
    }

    public static void main(String[] args) {
        HashMap<String, String> test = new HashMap<String, String>();
        test.put("iso", "ISO-8859-1");
        test.put("uni", "UTF-8");
        try {
            FlexEncReader instance = new FlexEncReader(new FileInputStream(args[0]), test);
            instance.test();
            instance.close();
        }
        catch (FileNotFoundException e) {
            _logger.log(Level.SEVERE, "File not found: " + args[0]);
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, "Error closing instance for file: " + args[0] + "\n Cause: " + e.getMessage());
        }
    }

    private static class EOFException
    extends Exception {
        private static final long serialVersionUID = 9026739210965071907L;

        private EOFException() {
        }
    }
}

