/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.tools.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.mpi.annot.tools.data.ShoeboxTiers;

public class ShoeboxRecord {
    private static Logger _logger = Logger.getLogger(ShoeboxRecord.class.getName());
    private HashMap<String, ArrayList<String>> record = new HashMap();
    private ShoeboxTiers tiers;
    private boolean knownTiers;
    private long startTime;
    private long endTime;
    private String recordInfo;
    private String lastTag;
    private boolean lineBreaksCleaned;
    private int longestAlignedTier;
    private boolean virtualTime;

    public ShoeboxRecord(String line, ShoeboxTiers tiers, boolean knownTiers) {
        this.recordInfo = ShoeboxRecord.getTierContent(line);
        this.knownTiers = knownTiers;
        if (tiers == null) {
            tiers = new ShoeboxTiers();
            knownTiers = false;
            _logger.log(Level.WARNING, "Warning: tiers were null");
        }
        this.tiers = tiers;
        this.startTime = -1L;
        this.endTime = -1L;
        this.virtualTime = false;
        this.lastTag = null;
        this.lineBreaksCleaned = false;
        this.longestAlignedTier = -1;
        ArrayList<String> refLabel = new ArrayList<String>();
        refLabel.add(this.recordInfo);
        this.record.put("ref", refLabel);
        tiers.put("ref", ShoeboxTiers.TierType.REF);
    }

    public void put(String line, String file) {
        ArrayList<String> lines;
        String tag;
        String tag1 = ShoeboxRecord.getTierTag(line);
        boolean elanMode = this.tiers.usesElanTime();
        if (this.knownTiers && this.tiers.getType(tag1) == ShoeboxTiers.TierType.TIME && !this.parseTime(tag1, ShoeboxRecord.getTierContent(line), file, elanMode)) {
            _logger.log(Level.WARNING, "Warning: illegal time in: '" + line + "' in: " + file);
            if (this.tiers.addTimeEvidence(tag1, -1) < 0) {
                if (this.tiers.getType(tag1) == ShoeboxTiers.TierType.TIME) {
                    _logger.log(Level.SEVERE, "Tier lost TIME type, too many errors: " + tag1 + " in: " + file);
                }
                this.tiers.put(tag1, ShoeboxTiers.TierType.UNKNOWN);
            }
        }
        if ((tag = ShoeboxRecord.getTierTag(line)) == null) {
            tag = this.lastTag;
        }
        this.lastTag = tag;
        if (tag == null) {
            if (line.trim().length() > 0) {
                _logger.log(Level.WARNING, "Warning: no tag in line '" + line + "' in: " + file);
            }
            return;
        }
        if (this.knownTiers && this.tiers.getType(tag) == null) {
            _logger.log(Level.WARNING, "Warning: ignoring unspecified tag: " + tag + " in: " + file);
        }
        if (!this.knownTiers) {
            String content = ShoeboxRecord.getTierContent(line);
            if (this.tiers.addTimeEvidence(tag, 0) > -3) {
                if (content.trim().length() != 0) {
                    if (this.parseTime(tag, content, file, elanMode)) {
                        if (!(this.startTime == 0L || this.endTime == 0L || this.tiers.addTimeEvidence(tag, 1) <= 0 || this.tiers.getType(tag) == ShoeboxTiers.TierType.TIME || tag.equals("nr") || tag.equals("per") || tag.equals("page") || tag.equals("id"))) {
                            if (!tag.startsWith("ELAN") && !tag.startsWith("EUDICOt")) {
                                _logger.log(Level.WARNING, "Adding TIME property: " + tag + " (" + content + ") in: " + file);
                            }
                            this.tiers.put(tag, ShoeboxTiers.TierType.TIME);
                        }
                    } else if (this.tiers.addTimeEvidence(tag, -1) < -2 && this.tiers.getType(tag) == ShoeboxTiers.TierType.TIME) {
                        _logger.log(Level.WARNING, "Removing TIME property: " + tag + " (" + content + ") in: " + file);
                        this.tiers.put(tag, ShoeboxTiers.TierType.UNKNOWN);
                    }
                }
            } else {
                this.tiers.addTimeEvidence(tag, -1);
            }
        }
        if ((lines = this.record.get(tag)) == null) {
            lines = new ArrayList();
            this.record.put(tag, lines);
        }
        lines.add(ShoeboxRecord.getTierContent(line));
        if (!this.knownTiers && this.tiers.getType(tag) != ShoeboxTiers.TierType.TIME || this.tiers.getType(tag) == ShoeboxTiers.TierType.UNKNOWN) {
            if (ShoeboxRecord.isProbablyAligned(tag, ShoeboxRecord.getTierContent(line))) {
                this.tiers.put(tag, ShoeboxTiers.TierType.ALIGNED);
            } else {
                this.tiers.put(tag, ShoeboxTiers.TierType.BLOCK);
            }
        }
    }

    public long provideAlternativeTime(ShoeboxRecord successor, long oldEnd) {
        long size = 1000L;
        if (this.startTime == -1L || this.endTime == -1L) {
            this.virtualTime = true;
        }
        if (this.startTime == -1L) {
            this.startTime = oldEnd;
        }
        if (this.endTime == -1L && successor != null) {
            this.endTime = successor.startTime;
        }
        if (this.endTime == -1L) {
            this.endTime = this.startTime + size;
        }
        if (this.startTime > this.endTime) {
            _logger.log(Level.SEVERE, "provideAlternativeTime got impossible result: " + this.startTime + " > " + this.endTime + " (oldEnd: " + oldEnd + ", successor start: " + (String)(successor != null ? "" + successor.startTime : "n/a") + ", virtual: " + this.virtualTime + ")");
            throw new IllegalArgumentException("provideAlternativeTime error: Got inverse timespan.");
        }
        return this.endTime;
    }

    private void cleanLineBreaks() {
        this.longestAlignedTier = 0;
        boolean more = true;
        while (more) {
            more = false;
            this.findNewLongestAlignedTier();
            for (String tag : this.tags()) {
                ArrayList<String> lines = this.record.get(tag);
                if (lines == null) continue;
                if (lines.size() > 1) {
                    if (ShoeboxTiers.TierType.ALIGNED.equals((Object)this.tiers.getType(tag))) {
                        while (lines.get(0).length() < this.longestAlignedTier + 1) {
                            lines.set(0, lines.get(0) + " ");
                        }
                    }
                    lines.set(0, lines.get(0) + " ~ " + lines.get(1));
                    lines.remove(1);
                }
                if (lines.size() <= 1) continue;
                more = true;
            }
        }
        this.findNewLongestAlignedTier();
        this.lineBreaksCleaned = true;
    }

    private void findNewLongestAlignedTier() {
        for (String tag : this.tags()) {
            if (!ShoeboxTiers.TierType.ALIGNED.equals((Object)this.getTierType(tag)) || this.record.get(tag) == null || this.record.get(tag).get(0).length() <= this.longestAlignedTier) continue;
            this.longestAlignedTier = this.record.get(tag).get(0).length();
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Collection<String> tags() {
        return this.tiers.names(true);
    }

    public ShoeboxTiers tiers() {
        return this.tiers;
    }

    public String getContent(String tag) {
        if (!this.lineBreaksCleaned) {
            this.cleanLineBreaks();
        }
        if (this.record.get(tag) == null) {
            return null;
        }
        return this.record.get(tag).get(0);
    }

    public ShoeboxTiers.TierType getTierType(String tag) {
        return this.tiers.getType(tag);
    }

    public int getLongestAlignedTier() {
        if (!this.lineBreaksCleaned) {
            this.cleanLineBreaks();
        }
        return this.longestAlignedTier;
    }

    public String toString() {
        return this.record.toString() + this.tiers.toString();
    }

    private boolean parseTime(String tag, String content, String file, boolean elanTimes) {
        if (content == null || tag == null) {
            return false;
        }
        if ("EUDICOp".equals(tag) || "ELANParticipant".equals(tag) || tag.startsWith("ELANMedia") || "page".equals(tag) || "per".equals(tag) || "nr".equals(tag) || "comment".equals(tag) || "comm".equals(tag) || "com".equals(tag) || "note".equals(tag) || "nt".equals(tag) || "id".equals(tag) || "tp".equals(tag) || "te".equals(tag) || "per".equals(tag)) {
            return false;
        }
        long time = -1L;
        try {
            time = ShoeboxRecord.parseTimeString(content);
            if (!(time <= 0L || time > 3000L || time % 1000L != 0L || tag.startsWith("ELAN") || tag.startsWith("EUDICO") || elanTimes)) {
                if (!"nr".equals(tag)) {
                    _logger.log(Level.FINE, "parseTime: Value 1..3 unlikely to be msec timestamp for " + tag + ": '" + content + "' in: " + file);
                }
                time = -1L;
            }
        }
        catch (NumberFormatException nfe) {
            _logger.log(Level.WARNING, "parseTime: Parse error for " + tag + ": '" + content + "' in: " + file);
            time = -1L;
        }
        if (time == -1L) {
            return false;
        }
        if (!tag.startsWith("E") && !elanTimes) {
            this.startTime = time;
        } else if ("EUDICOt0".equals(tag) || "ELANBegin".equals(tag)) {
            this.startTime = time;
        } else if ("EUDICOt1".equals(tag) || "ELANEnd".equals(tag)) {
            this.endTime = time;
        } else if (time != -1L && !elanTimes) {
            this.startTime = time;
        }
        return true;
    }

    public static long parseTimeString(String time) throws NumberFormatException {
        int n;
        if (time.length() == 0 || time.charAt(0) < '0' || time.charAt(0) > '9') {
            return -1L;
        }
        long offset = 0L;
        if ((time = time.trim()).matches("^\\d+/.../\\d+$")) {
            return -1L;
        }
        if (time.matches("^\\d+:\\d+:\\d+[.]\\d+$") || time.matches("^\\d+:\\d+:\\d$")) {
            n = time.indexOf(":");
            offset += (long)Integer.parseInt(time.substring(0, n)) * 3600000L;
            time = time.substring(n + 1);
        }
        if (time.matches("^\\d+:\\d+[.]\\d+$") || time.matches("^\\d+:\\d+$")) {
            n = time.indexOf(":");
            offset += (long)Integer.parseInt(time.substring(0, n)) * 60000L;
            time = time.substring(n + 1);
        }
        if (time.matches("^\\d+[.]\\d+$") || time.matches("^\\d+$")) {
            n = time.indexOf(46);
            if (n == -1) {
                return offset + 1000L * (long)Integer.parseInt(time);
            }
            offset += 1000L * (long)Integer.parseInt(time.substring(0, n));
            if ((time = time.substring(n + 1).trim()).length() < 3) {
                time = (time + "000").substring(0, 3);
            }
            if (time.length() > 3) {
                if (time.charAt(3) > '4') {
                    ++offset;
                }
                time = time.substring(0, 3);
            }
            return offset + (long)Integer.parseInt(time);
        }
        return -1L;
    }

    public static String getTierTag(String line) {
        if (!line.startsWith("\\")) {
            return null;
        }
        if (line.indexOf(32) == -1) {
            return line.substring(1).trim();
        }
        return line.substring(1, line.indexOf(32));
    }

    public static String getTierContent(String line) {
        if (line.endsWith("\r")) {
            line = line.substring(0, line.length() - 1);
        }
        if (!line.startsWith("\\")) {
            return line;
        }
        if (line.indexOf(32) == -1) {
            return "";
        }
        return line.substring(line.indexOf(32) + 1, line.length());
    }

    protected static boolean isProbablyAligned(String tag, String content) {
        return content.trim().contains("  ");
    }
}

