/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.tools.data;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.mpi.annot.tools.data.AnnexAnnotation;
import nl.mpi.annot.tools.data.AnnexTier;
import nl.mpi.annot.tools.data.AnnexTranscription;
import nl.mpi.annot.tools.data.DataUtil;

public class SubripParser {
    private static final boolean _verbose = false;
    private static Logger _logger = Logger.getLogger(SubripParser.class.getName());

    public static void parseSubRip(String[] lines, AnnexTranscription transcription) throws IOException {
        AnnexTier textTier = new AnnexTier("text", "subrip_subtitle");
        AnnexTier numberTier = new AnnexTier("id", "subrip_subtitle");
        textTier.participant = "unknown";
        textTier.hasVirtualTime = false;
        numberTier.participant = "unknown";
        numberTier.hasVirtualTime = false;
        int state = 0;
        StringBuilder text = new StringBuilder(200);
        String id = "none";
        long start = 0L;
        long end = 0L;
        boolean okay = false;
        boolean skipped = false;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.length() == 0) {
                state = 0;
                if (text.length() != 0 && end > 0L) {
                    textTier.annotations.add(new AnnexAnnotation(text.toString(), start, end, true, id));
                    okay = true;
                }
                text = new StringBuilder(200);
                continue;
            }
            if (state == 0 && line.matches("^[0-9]+$")) {
                state = 1;
                id = line;
                numberTier.annotations.add(new AnnexAnnotation(line, start, end, true, id));
                continue;
            }
            if (state == 1 && line.matches("^[0-9]+:[0-9:]+,[0-9]+ --> [0-9]+:[0-9:]+,[0-9]+$")) {
                state = 2;
                int splitPoint = line.indexOf("-->");
                String[] startTime = line.substring(0, splitPoint).trim().split("[:,]");
                String[] endTime = line.substring(splitPoint + 3).trim().split("[:,]");
                if (startTime.length != 4 || endTime.length != 4) {
                    throw new IOException("Unsupported timestamp format, need hh:mm:ss,xxx in line " + (i + 1) + ": '" + line + "'");
                }
                long oldEnd = end;
                try {
                    start = Integer.parseInt(startTime[3], 10);
                    end = Integer.parseInt(endTime[3], 10);
                    start += 1000L * (long)Integer.parseInt(startTime[2], 10);
                    end += 1000L * (long)Integer.parseInt(endTime[2], 10);
                    start += 60000L * (long)Integer.parseInt(startTime[1], 10);
                    end += 60000L * (long)Integer.parseInt(endTime[1], 10);
                    end += 3600000L * (long)Integer.parseInt(endTime[0], 10);
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("Bad number syntax in timestamp in line " + (i + 1) + ": " + nfe);
                }
                if ((start += 3600000L * (long)Integer.parseInt(startTime[0], 10)) < oldEnd) {
                    _logger.log(Level.WARNING, "Overlapping annotation at: " + start + " to " + end + " after " + oldEnd + " in line " + (i + 1) + " of " + transcription.getNodeId());
                }
                if (end >= start) continue;
                _logger.log(Level.WARNING, "End before start at: " + start + " to " + end + " in line " + (i + 1) + " of " + transcription.getNodeId());
                throw new IOException("Impossible inverted timespan from " + start + " to " + end + " found in line " + (i + 1));
            }
            if (state == 2 || state == 3) {
                if (text.length() > 0) {
                    text.append(' ');
                }
                text.append(line);
                state = 3;
                continue;
            }
            _logger.log(Level.WARNING, "Unexpected content skipped in state " + state + " in line " + (i + 1) + ": '" + line + "' of " + transcription.getNodeId());
            skipped = true;
        }
        if (text.length() != 0 & end > 0L) {
            textTier.annotations.add(new AnnexAnnotation(text.toString(), start, end, true, id));
            okay = true;
        }
        if (skipped && !okay) {
            throw new IOException("File does not contain SubRip SRT formatted annotations but something else");
        }
        transcription.getTiers().add(textTier);
    }

    public static void main(String[] args) throws IOException {
        File file = new File(args[0]);
        String id = args[0].substring(args[0].lastIndexOf(47) + 1);
        DataUtil.readLines(file, DataUtil.getCharsetName(file));
        new AnnexTranscription(id, 8, file);
    }
}

