/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.tools.util;

import nl.mpi.annot.tools.util.CountHash;

public class XmlUtil {
    public static String encodeXMLArray(String resultTag, String[] items) {
        StringBuilder result = new StringBuilder(128);
        result.append("<" + resultTag + ">\n");
        for (int i = 0; i < items.length; ++i) {
            result.append('\t');
            result.append(XmlUtil.xmlifyNameValuePair("item", items[i]));
        }
        result.append("</" + resultTag + ">\n");
        return result.toString();
    }

    public static String encodeXMLArray(String resultTag, CountHash<String> items) {
        StringBuilder result = new StringBuilder(128);
        result.append("<" + resultTag + ">\n");
        for (String item : items.keySet()) {
            result.append('\t');
            result.append("<item count=\"").append(items.getCount(item));
            result.append("\">");
            result.append(XmlUtil.escapeXML(item).replaceAll(" ", "&#32;"));
            result.append("</item>\n");
        }
        result.append("</" + resultTag + ">\n");
        return result.toString();
    }

    public static String escapeXML(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("\n", "").replaceAll("\r", "").replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String xmlifyNameValuePair(String name, String value) {
        if (value == null) {
            value = "";
        }
        StringBuilder result = new StringBuilder(2 * name.length() + value.length() + 16);
        result.append('<').append(name).append('>');
        result.append(XmlUtil.escapeXML(value).replaceAll(" ", "&#32;"));
        result.append('<').append('/').append(name).append('>').append('\n');
        return result.toString();
    }

    public static String xmlifyNameValuePair(String name, long value) {
        return XmlUtil.xmlifyNameValuePair(name, Long.toString(value, 10));
    }

    public static String xmlifyNameValuePair(String name, boolean value) {
        return XmlUtil.xmlifyNameValuePair(name, Boolean.toString(value));
    }
}

