<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl"
    exclude-result-prefixes="xs xd"
    version="2.0">
    <xd:doc scope="stylesheet">
        <xd:desc>
            <xd:p><xd:b>Created on:</xd:b> May 30, 2016</xd:p>
            <xd:p><xd:b>Description:</xd:b> an xslt stylesheet for converting a CorpAfroAs lexicon (.eafl format) to 
            the format of the lexicon component of ELAN.</xd:p>
        </xd:desc>
    </xd:doc>
    
    <xsl:output method="xml" indent="yes"/>
    
    <xsl:template match="/">        
        <xsl:apply-templates/>
    </xsl:template>
    
    <xsl:template match="lexicon">
        <xsl:element name="lexicon">
            <xsl:namespace name="vc" select="'http://www.w3.org/2007/XMLSchema-versioning'"/>
            <xsl:namespace name="xsi" select="'http://www.w3.org/2001/XMLSchema-instance'"/>
            <xsl:attribute namespace="http://www.w3.org/2001/XMLSchema-instance" name="noNamespaceSchemaLocation">http://www.mpi.nl/tools/elan/LexiconComponent-1.0.xsd</xsl:attribute>
            <xsl:attribute name="schemaVersion">1.0</xsl:attribute>
            <xsl:element name="header">
                <xsl:element name="name">Unnamed CorpAfroAs lexicon</xsl:element>
                <xsl:element name="language">und</xsl:element>
            </xsl:element>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>
    <!-- The lexical entry level template, 
        converts lexical entry, id, date created, lexeme and lexeme@type -->
    <xsl:template match="lexicalEntry">
        <xsl:element name="entry">
            <xsl:attribute name="id">
                <xsl:value-of select="concat('e_', @id)"/>
            </xsl:attribute>
            <xsl:attribute name="dateCreated">
                <!--<xsl:value-of select="adjust-time-to-timezone((node()|@dt))"/>
                <xsl:value-of select="dateTime(xs:date(substring(@dt,2)), xs:time('00:00:00'))"/>-->
                <xsl:call-template name="dateConvert"/>
            </xsl:attribute>
            <xsl:element name="lexical-unit">
                <xsl:value-of select="child::Lexeme"/>
            </xsl:element>
            <xsl:element name="morph-type">
                <xsl:value-of select="child::Lexeme/@typ"/>
            </xsl:element>
            <xsl:for-each select="child::form/altForm">
                <xsl:call-template name="form_template"/>
            </xsl:for-each>
            <xsl:call-template name="sense_template"/>
        </xsl:element>
    </xsl:template>
    
    <!-- The sense level template,
    converts sense, Gloss, Gloss@lang, Gloss@tierX en Gloss@der-->
    <xsl:template name="sense_template">
        <xsl:element name="sense">
            <xsl:attribute name="id">
                <!-- generate id -->
                <xsl:value-of select="concat('s_', position())"/>
            </xsl:attribute>
            <xsl:attribute name="order">1</xsl:attribute>
            <!-- todo: there can be multiple glosses; use the first as grammatical category and the others as gloss? -->
            <xsl:element name="grammatical-category">
                <xsl:value-of select="sense/Gloss"/><!-- or use tierX here?, or der? -->
            </xsl:element>
            <xsl:if test="sense/Gloss/@tierX">
                <xsl:element name="gloss">
                    <xsl:attribute name="lang">
                        <xsl:value-of select="sense/Gloss/@lang"/>
                    </xsl:attribute>
                    <xsl:value-of select="sense/Gloss/@tierX"/><!-- test first --><!-- or use sense/Gloss? -->
                </xsl:element>
            </xsl:if>
            <xsl:if test="sense/Gloss/@der">
                <xsl:element name="field">
                    <xsl:attribute name="name">der</xsl:attribute>
                    <xsl:value-of select="sense/Gloss/@der"/>
                </xsl:element>
            </xsl:if>
            <xsl:if test="sense/stuff">
                <xsl:element name="field">
                    <xsl:attribute name="name">stuff</xsl:attribute>
                    <xsl:value-of select="sense/stuff"/>
                </xsl:element>
            </xsl:if>
        </xsl:element>
    </xsl:template>
    
    <!-- The form template, converts form/altForm/WForm to a variant. 
    form/altForm/morph can contain multiple segments, each segment consisting of 3 attributes-->
    <xsl:template name="form_template">
      <xsl:if test="WForm">
          <xsl:element name="variant">
              <xsl:value-of select="WForm"/>
          </xsl:element>
      </xsl:if>  
      <xsl:if test="morph">
          <xsl:call-template name="morph_template"/>
      </xsl:if>
    </xsl:template>
       
    <xsl:template name="morph_template">
        <!-- How to convert each Segment and the attributes ref, ge, rx? -->
        
    </xsl:template>
    
    <!-- template to convert non standard date format -->
    <xsl:template name="dateConvert">
        <xsl:variable name="monthNum">
            <xsl:call-template name="monthConvert">
                <xsl:with-param name="month">
                    <xsl:value-of select="substring(@dt, 4, 3)"/>
                </xsl:with-param>
            </xsl:call-template>
        </xsl:variable>
        <!-- xslt 2.0
        <xsl:value-of select="dateTime(xs:date(concat(substring(@dt,8),'-',$monthNum,'-',substring(@dt,1,2))), xs:time('00:00:00'))"/>
        -->
        <xsl:value-of select="concat(substring(@dt,8),'-',$monthNum,'-',substring(@dt,1,2))"/>

    </xsl:template>
    
    <!-- converts a 3 letter month string to a month number, there must be a better way to do this -->
    <xsl:template name="monthConvert">
        <xsl:param name="month"/>
        <xsl:if test="contains($month, 'Jan')">
            <xsl:value-of select="'01'"/>
        </xsl:if>
        <xsl:if test="contains($month, 'Feb')">
            <xsl:value-of select="'02'"/>
        </xsl:if>
        <xsl:if test="contains($month, 'Mar')">
            <xsl:value-of select="'03'"/>
        </xsl:if>
        <xsl:if test="contains($month, 'Apr')">
            <xsl:value-of select="'04'"/>
        </xsl:if>
        <xsl:if test="contains($month, 'May')">
            <xsl:value-of select="'05'"/>
        </xsl:if>
        <xsl:if test="contains($month, 'Jun')">
            <xsl:value-of select="'06'"/>
        </xsl:if>
        <xsl:if test="contains($month, 'Jul')">
            <xsl:value-of select="'07'"/>
        </xsl:if>
        <xsl:if test="contains($month, 'Aug')">
            <xsl:value-of select="'08'"/>
        </xsl:if>
        <xsl:if test="contains($month, 'Sep')">
            <xsl:value-of select="'09'"/>
        </xsl:if>
        <xsl:if test="contains($month, 'Oct')">
            <xsl:value-of select="10"/>
        </xsl:if>
        <xsl:if test="contains($month, 'Nov')">
            <xsl:value-of select="11"/>
        </xsl:if>
        <xsl:if test="contains($month, 'Dec')">
            <xsl:value-of select="12"/>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>