/*
 * Decompiled with CFR 0.152.
 */
package mpi.dcr;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import mpi.dcr.DCRConnectorException;
import mpi.dcr.DCSmall;
import mpi.dcr.ILATDCRConnector;
import mpi.dcr.LocalDCRConnector;
import mpi.dcr.isocat.Profile;
import mpi.dcr.isocat.RestDCRConnector;
import mpi.eudico.util.EmptyStringComparator;

public abstract class AbstractDCSelectPanel2
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected ILATDCRConnector connector = null;
    protected RestDCRConnector remoteConnector;
    protected JPanel catPanel;
    protected JTable catTable;
    protected JScrollPane catTableScroll;
    protected DefaultTableModel catModel;
    protected JLabel langLabel;
    protected JComboBox langCombo;
    protected JPanel descPanel;
    protected JLabel descLabel;
    protected JTextArea descArea;
    protected JScrollPane descScroll;
    protected JLabel nameKeyLabel;
    protected JTextArea nameValueLabel;
    protected final String EMPTY = "-";
    protected ResourceBundle resBundle;
    protected Insets globalInsets = new Insets(2, 6, 2, 6);
    protected Insets spacerInsets = new Insets(2, 6, 10, 6);
    protected Dimension dim = new Dimension(220, 300);
    public final Cursor BUSY_CURSOR = Cursor.getPredefinedCursor(3);
    public final Cursor DEFAULT_CURSOR = Cursor.getDefaultCursor();
    protected String currentLanguage;
    private final Logger LOG = Logger.getLogger("DCR");

    public AbstractDCSelectPanel2(ILATDCRConnector connector) {
        this.connector = connector;
    }

    public AbstractDCSelectPanel2(ILATDCRConnector connector, ResourceBundle resBundle) {
        this.connector = connector;
        this.resBundle = resBundle;
    }

    public AbstractDCSelectPanel2() {
    }

    protected void initialize() {
        this.initializeDCPanel();
        this.initializeDescriptionPanel();
        this.initComponents();
    }

    protected abstract void initComponents();

    protected void initializeDescriptionPanel() {
        this.langLabel = new JLabel();
        this.langCombo = new JComboBox();
        this.langCombo.addItem("-");
        this.nameKeyLabel = new JLabel();
        this.nameValueLabel = new JTextArea();
        this.nameValueLabel.setEditable(false);
        this.nameValueLabel.setLineWrap(true);
        this.nameValueLabel.setWrapStyleWord(true);
        this.nameValueLabel.setText("-");
        this.descLabel = new JLabel();
        this.descArea = new JTextArea(6, 30);
        this.descArea.setEditable(false);
        this.descArea.setLineWrap(true);
        this.descArea.setWrapStyleWord(true);
        this.descPanel = new JPanel(new GridBagLayout());
        this.descScroll = new JScrollPane(this.descArea);
        this.descScroll.setMinimumSize(this.descArea.getPreferredScrollableViewportSize());
        this.descScroll.setMaximumSize(this.descArea.getPreferredScrollableViewportSize());
        this.descScroll.setVerticalScrollBarPolicy(20);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInsets;
        this.descPanel.add((Component)this.langLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = this.spacerInsets;
        this.descPanel.add((Component)this.langCombo, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets = this.globalInsets;
        this.descPanel.add((Component)this.nameKeyLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = this.spacerInsets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)this.nameValueLabel, gbc);
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        ++gbc.gridy;
        gbc.insets = this.globalInsets;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.descPanel.add((Component)this.descLabel, gbc);
        ++gbc.gridy;
        gbc.insets = this.globalInsets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.descPanel.add((Component)this.descScroll, gbc);
        this.descPanel.setMinimumSize(this.dim);
        this.descPanel.setPreferredSize(this.dim);
    }

    protected void initializeDCPanel() {
        this.catModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.catModel.setColumnIdentifiers(new Object[]{"DC- IDENTIFIER", "ID", "PROFILES"});
        DCTableCellRenderer catTableRenderer = new DCTableCellRenderer();
        this.catTable = new JTable(this.catModel);
        this.catTable.setDefaultRenderer(Object.class, catTableRenderer);
        this.catTable.setSelectionMode(2);
        this.catTable.getSelectionModel().addListSelectionListener(this);
        TableRowSorter<DefaultTableModel> rowSorter = new TableRowSorter<DefaultTableModel>(this.catModel);
        EmptyStringComparator emptyComp = new EmptyStringComparator();
        rowSorter.setComparator(1, null);
        rowSorter.setComparator(2, emptyComp);
        this.catTable.setRowSorter(rowSorter);
        this.catTableScroll = new JScrollPane(this.catTable);
        this.catPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = this.globalInsets;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.catPanel.add((Component)this.catTableScroll, gbc);
    }

    protected void setSingleSelection(boolean bool) {
        this.catTable.setSelectionMode(1);
    }

    public void setPreferredLanguage(String lang) {
        this.currentLanguage = lang;
    }

    protected void updateLocale() {
        String descpanel = "Category Description";
        String name = "Name";
        String lang = "Language";
        String desc = "Description";
        if (this.resBundle != null) {
            try {
                descpanel = this.resBundle.getString("DCR.Label.CategoryDescription");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                name = this.resBundle.getString("DCR.Label.Name");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                lang = this.resBundle.getString("DCR.Label.Language");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.descPanel.setBorder(new TitledBorder(descpanel));
        this.descLabel.setText(desc);
        this.nameKeyLabel.setText(name);
        this.langLabel.setText(lang);
    }

    public List<DCSmall> getSelectedCategories() {
        int[] vals;
        ArrayList<DCSmall> selected = new ArrayList<DCSmall>();
        for (int val : vals = this.catTable.getSelectedRows()) {
            selected.add((DCSmall)this.catTable.getValueAt(val, 0));
        }
        return selected;
    }

    protected void updateCategories(List<DCSmall> datcats) {
        if (datcats == null) {
            datcats = new ArrayList<DCSmall>(0);
        }
        this.descArea.setText("");
        while (this.catModel.getRowCount() > 0) {
            this.catModel.removeRow(0);
        }
        for (int i = 0; i < datcats.size(); ++i) {
            DCSmall dc = datcats.get(i);
            Object prof = null;
            Profile[] profiles = dc.getProfiles();
            if (profiles.length > 0) {
                prof = profiles[0].getName();
                for (int p = 1; p < profiles.length; ++p) {
                    prof = (String)prof + ", " + profiles[p].getName();
                }
            }
            this.catModel.addRow(new Object[]{dc, dc.getId(), prof});
        }
    }

    protected void updateDescription() {
        DCSmall dc = (DCSmall)this.catTable.getValueAt(this.catTable.getSelectedRow(), 0);
        String lang = this.langCombo.getSelectedItem().toString();
        this.nameValueLabel.setText(dc.getName(lang));
        this.descArea.setText(dc.getDesc(lang));
    }

    protected void replaceDC(DCSmall dc) {
        block3: {
            try {
                if (this.connector instanceof LocalDCRConnector) {
                    ((LocalDCRConnector)this.connector).replaceDC(dc);
                }
            }
            catch (DCRConnectorException e) {
                if (!this.LOG.isLoggable(Level.FINE)) break block3;
                this.LOG.fine("No DCR connection: " + e.getMessage());
            }
        }
    }

    protected void updateDescriptionPanel(DCSmall dc) {
        if (dc != null) {
            block12: {
                if (!dc.isLoaded()) {
                    if (this.connector instanceof RestDCRConnector) {
                        this.remoteConnector = (RestDCRConnector)this.connector;
                    } else if (this.remoteConnector == null) {
                        this.remoteConnector = new RestDCRConnector();
                    }
                    try {
                        dc = this.remoteConnector.getDataCategory(dc.getId());
                        this.catTable.setValueAt(dc, this.catTable.getSelectedRow(), 0);
                        this.replaceDC(dc);
                    }
                    catch (DCRConnectorException e) {
                        if (!this.LOG.isLoggable(Level.FINE)) break block12;
                        this.LOG.fine("No DCR connection: " + e.getMessage());
                    }
                }
            }
            this.langCombo.removeActionListener(this);
            this.langCombo.removeAllItems();
            List<String> langList = dc.getLanguages();
            for (int i = 0; i < langList.size(); ++i) {
                this.langCombo.addItem(langList.get(i));
            }
            if (this.currentLanguage != null && langList.contains(this.currentLanguage)) {
                this.langCombo.setSelectedItem(this.currentLanguage);
            } else {
                this.langCombo.setSelectedItem("en");
            }
            this.langCombo.addActionListener(this);
            this.updateDescription();
        } else {
            if (this.catTable.getSelectedRows().length == 1) {
                this.catTable.getSelectionModel().clearSelection();
            }
            this.langCombo.removeActionListener(this);
            this.langCombo.removeAllItems();
            this.langCombo.addItem("-");
            this.langCombo.addActionListener(this);
            this.nameValueLabel.setText("-");
            this.descArea.setText("");
        }
    }

    protected void updateDescriptionPanel() {
        if (this.catTable.getSelectedRows().length == 1 && this.catTable.getSelectedRow() > -1) {
            DCSmall dc;
            block9: {
                dc = (DCSmall)this.catTable.getValueAt(this.catTable.getSelectedRow(), 0);
                if (dc != null && !dc.isLoaded()) {
                    if (this.connector instanceof RestDCRConnector) {
                        this.remoteConnector = (RestDCRConnector)this.connector;
                    } else if (this.remoteConnector == null) {
                        this.remoteConnector = new RestDCRConnector();
                    }
                    try {
                        dc = this.remoteConnector.getDataCategory(dc.getId());
                        this.catTable.setValueAt(dc, this.catTable.getSelectedRow(), 0);
                        if (this.connector instanceof LocalDCRConnector) {
                            ((LocalDCRConnector)this.connector).replaceDC(dc);
                        }
                    }
                    catch (DCRConnectorException e) {
                        if (!this.LOG.isLoggable(Level.FINE)) break block9;
                        this.LOG.fine("No DCR connection: " + e.getMessage());
                    }
                }
            }
            this.updateDescriptionPanel(dc);
        } else {
            this.updateDescriptionPanel(null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.langCombo && !this.langCombo.getSelectedItem().equals("-")) {
            this.updateDescription();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateDescriptionPanel();
    }

    public class DCTableCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        HashMap<Integer, List<Integer>> heightMap;

        public DCTableCellRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setEditable(false);
            this.heightMap = new HashMap();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value.toString());
            this.setSize(table.getColumnModel().getColumn(column).getWidth(), this.getPreferredSize().height);
            this.setToolTipText(this.getText());
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
            for (int i = 0; i < table.getSelectedRows().length; ++i) {
                if (row != table.getSelectedRows()[i]) continue;
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
                break;
            }
            if (!this.heightMap.containsKey(row)) {
                ArrayList<Integer> heightList = new ArrayList<Integer>(3);
                heightList.add(0);
                heightList.add(0);
                heightList.add(0);
                this.heightMap.put(row, heightList);
            }
            List<Integer> heightList = this.heightMap.get(row);
            heightList.set(column, this.getPreferredSize().height);
            int height = 0;
            for (int i = 0; i < 3; ++i) {
                if (height >= heightList.get(i)) continue;
                height = heightList.get(i);
            }
            table.setRowHeight(row, height);
            return this;
        }
    }
}

