/*
 * Decompiled with CFR 0.152.
 */
package mpi.dcr;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mpi.dcr.AbstractDCSelectPanel2;
import mpi.dcr.LocalDCRConnector;
import mpi.dcr.LocalDCSelectPanel;
import mpi.dcr.RemoteDCSelectPanel;
import mpi.dcr.isocat.RestDCRConnector;

public class DCRDialog
extends JDialog
implements ActionListener {
    public static final int LOCALE_MODE = 1;
    public static final int REMOTE_MODE = 2;
    private int mode = 1;
    private ResourceBundle bundle = null;
    private String dcrName;
    private String dcrLocation;
    private JPanel titlePanel;
    private JLabel titleLabel;
    private JLabel subtitleLabel;
    private JLabel subtitleLabel2;
    private AbstractDCSelectPanel2 dcPanel;
    private JPanel buttonPanel;
    private JButton applyButton;
    private JButton cancelButton;
    private Object value = null;

    public DCRDialog(Frame owner, boolean modal, int mode) throws HeadlessException {
        super(owner, modal);
        if (mode == 2) {
            this.mode = mode;
        }
        this.initComponents();
    }

    public DCRDialog(Frame owner, boolean modal, int mode, ResourceBundle bundle) throws HeadlessException {
        super(owner, modal);
        if (mode == 2) {
            this.mode = mode;
        }
        this.bundle = bundle;
        this.initComponents();
    }

    public DCRDialog(Dialog owner, boolean modal, int mode) throws HeadlessException {
        super(owner, modal);
        if (mode == 2) {
            this.mode = mode;
        }
        this.initComponents();
    }

    public DCRDialog(Dialog owner, boolean modal, int mode, ResourceBundle bundle) throws HeadlessException {
        super(owner, modal);
        if (mode == 2) {
            this.mode = mode;
        }
        this.bundle = bundle;
        this.initComponents();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titlePanel = new JPanel(new GridBagLayout());
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        this.subtitleLabel = new JLabel();
        this.subtitleLabel.setFont(this.subtitleLabel.getFont().deriveFont(10.0f));
        this.subtitleLabel.setHorizontalAlignment(0);
        this.subtitleLabel2 = new JLabel();
        this.subtitleLabel2.setFont(this.subtitleLabel2.getFont().deriveFont(10.0f));
        this.subtitleLabel2.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        this.titlePanel.add((Component)this.titleLabel, gbc);
        gbc.gridy = 1;
        gbc.insets = insets;
        this.titlePanel.add((Component)this.subtitleLabel, gbc);
        gbc.gridy = 2;
        this.titlePanel.add((Component)this.subtitleLabel2, gbc);
        gbc.gridy = 0;
        this.getContentPane().add((Component)this.titlePanel, gbc);
        if (this.mode == 2) {
            RestDCRConnector conn = new RestDCRConnector();
            this.dcrName = conn.getName();
            this.dcrLocation = conn.getDCRLocation();
            this.dcPanel = new RemoteDCSelectPanel(conn, this.bundle);
        } else {
            this.dcPanel = new LocalDCSelectPanel(new LocalDCRConnector(), this.bundle);
        }
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridy = 1;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.dcPanel, gbc);
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.applyButton = new JButton();
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.applyButton);
        this.buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.anchor = 15;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        this.updateLocale();
    }

    private void updateLocale() {
        if (this.mode == 2) {
            if (this.bundle != null) {
                this.titleLabel.setText(this.bundle.getString("DCR.Label.Remote") + " " + this.dcrName);
                this.subtitleLabel.setText("(" + this.dcrLocation);
                this.subtitleLabel2.setText(this.bundle.getString("DCR.Label.RemoteHelp"));
            } else {
                this.titleLabel.setText("Remote DCR: " + this.dcrName);
                this.subtitleLabel.setText("(" + this.dcrLocation);
                this.subtitleLabel2.setText("First add and select a profile, next select one or more data categories.");
            }
        } else if (this.bundle != null) {
            this.titleLabel.setText(this.bundle.getString("DCR.Label.LocalDCS"));
            this.subtitleLabel2.setText(this.bundle.getString("DCR.Label.LocalDCSHelp"));
        } else {
            this.titleLabel.setText("Local Data Category Selection");
            this.subtitleLabel2.setText("Select one or all profiles, then select a data category.");
        }
        if (this.bundle != null) {
            this.applyButton.setText(this.bundle.getString("Button.Apply"));
            this.cancelButton.setText(this.bundle.getString("Button.Cancel"));
        } else {
            this.applyButton.setText("Apply");
            this.cancelButton.setText("Cancel");
        }
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.applyButton) {
            this.value = this.dcPanel.getSelectedCategories();
        } else if (e.getSource() == this.cancelButton) {
            this.value = null;
        }
        this.setVisible(false);
        this.dispose();
    }
}

