/*
 * Decompiled with CFR 0.152.
 */
package mpi.dcr;

import java.util.ArrayList;
import java.util.List;
import mpi.dcr.DCRConnectorException;
import mpi.dcr.DCSmall;
import mpi.dcr.ILATDCRConnector;
import mpi.dcr.isocat.DCSelection;
import mpi.dcr.isocat.Profile;
import mpi.dcr.isocat.RestDCRConnector;

public class LocalDCRConnector
implements ILATDCRConnector {
    protected String name = "Local DCR Connector";
    protected List<DCSmall> catList = new ArrayList<DCSmall>();
    protected String currentLanguage = null;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<DCSmall> getDCSmallList(String a_profile, String a_registrationStatus) throws DCRConnectorException {
        if (a_profile == null) {
            return this.catList;
        }
        ArrayList<DCSmall> profCats = new ArrayList<DCSmall>();
        DCSmall dc = null;
        block0: for (int i = 0; i < this.catList.size(); ++i) {
            dc = this.catList.get(i);
            if (dc.getProfiles() == null || dc.getProfiles().length <= 0) continue;
            for (int j = 0; j < dc.getProfiles().length; ++j) {
                if (!dc.getProfiles()[j].getId().equals(a_profile)) continue;
                profCats.add(dc);
                continue block0;
            }
        }
        return profCats;
    }

    protected void saveDCS() {
    }

    protected void readDCS() {
    }

    public void addDataCategories(List<DCSmall> datCats) throws DCRConnectorException {
        int size1 = datCats.size();
        block0: for (int i = 0; i < size1; ++i) {
            DCSmall small1 = datCats.get(i);
            int size2 = this.catList.size();
            for (int j = 0; j < size2; ++j) {
                DCSmall small2 = this.catList.get(j);
                if (!small1.getId().equals(small2.getId())) continue;
                this.catList.set(j, small1);
                continue block0;
            }
            this.catList.add(small1);
        }
        this.saveDCS();
    }

    public void replaceDC(DCSmall dc) throws DCRConnectorException {
        ArrayList<DCSmall> dcList = new ArrayList<DCSmall>();
        dcList.add(dc);
        this.addDataCategories(dcList);
    }

    public void removeCategories(List<DCSmall> datCats) throws DCRConnectorException {
        int size1 = datCats.size();
        block0: for (int i = 0; i < size1; ++i) {
            DCSmall small1 = datCats.get(i);
            int size2 = this.catList.size();
            for (int j = 0; j < size2; ++j) {
                DCSmall small2 = this.catList.get(j);
                if (!small1.getId().equals(small2.getId())) continue;
                this.catList.remove(j);
                continue block0;
            }
        }
        this.saveDCS();
    }

    public DCSmall getDCSmall(String dcId) {
        if (dcId == null) {
            return null;
        }
        DCSmall small = null;
        int size = this.catList.size();
        for (int i = 0; i < size; ++i) {
            small = this.catList.get(i);
            if (!small.getId().equals(dcId)) continue;
            return small;
        }
        return null;
    }

    public DCSmall getDCSmallLoaded(String dcId) {
        if (dcId == null) {
            return null;
        }
        DCSmall small = null;
        int size = this.catList.size();
        for (int i = 0; i < size && !(small = this.catList.get(i)).getId().equals(dcId); ++i) {
            small = null;
        }
        if (small == null || !small.isLoaded()) {
            try {
                RestDCRConnector remoteConnector = new RestDCRConnector();
                small = remoteConnector.getDataCategory(dcId);
                this.replaceDC(small);
                return small;
            }
            catch (DCRConnectorException e) {
                System.err.println("DCRConnectorException: " + e.getMessage());
            }
        }
        if (small != null) {
            return small;
        }
        return null;
    }

    public String getNameForDC(String dcId) {
        DCSmall dc = this.getDCSmall(dcId);
        String name = null;
        if (dc != null) {
            if (this.currentLanguage != null) {
                name = dc.getName(this.currentLanguage);
            }
            if (name == null) {
                name = dc.getName();
            }
        }
        return name;
    }

    public String getPreferedLanguage() {
        if (this.currentLanguage == null) {
            return "en";
        }
        return this.currentLanguage;
    }

    @Override
    public DCSelection getDataCategories(String profileId) throws DCRConnectorException {
        return null;
    }

    @Override
    public DCSmall getDataCategory(String a_urid) throws DCRConnectorException {
        return null;
    }

    @Override
    public List<Profile> getProfiles() throws DCRConnectorException {
        return null;
    }
}

