/*
 * Decompiled with CFR 0.152.
 */
package mpi.dcr.isocat;

import java.util.ArrayList;
import java.util.List;
import mpi.dcr.DCSmall;
import mpi.dcr.isocat.Profile;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DCIF_DC_Handler
implements ContentHandler {
    private DCSmall curDC;
    private String curLang;
    private boolean inLanguage = false;
    private boolean recordContent = false;
    private String curContent;
    private List<Profile> curProfs = new ArrayList<Profile>();

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.recordContent) {
            this.curContent = this.curContent == null ? new String(ch, start, length) : this.curContent.concat(new String(ch, start, length));
        }
    }

    public DCSmall getDC() {
        return this.curDC;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.curDC != null) {
            this.curDC.setLoaded(true);
        }
        this.curProfs.clear();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Profile pf;
        if (qName.equals("dcif:dataCategory")) {
            if (this.curProfs.size() > 0) {
                this.curDC.setProfiles(this.curProfs.toArray(new Profile[0]));
            }
        } else if (qName.equals("dcif:identifier")) {
            if (this.curDC != null) {
                this.curDC.setIdentifier(this.curContent);
            }
        } else if (qName.equals("dcif:language")) {
            if (this.inLanguage && this.curContent != null) {
                this.curLang = this.curContent;
            }
        } else if (qName.equals("dcif:languageSection")) {
            this.inLanguage = false;
        } else if (qName.equals("dcif:definition") && this.curLang != null) {
            if (this.curDC != null) {
                this.curDC.setDesc(this.curLang, this.curContent);
            }
        } else if (qName.equals("dcif:name") && this.curLang != null) {
            if (this.curDC != null) {
                this.curDC.setName(this.curLang, this.curContent);
            }
        } else if (qName.equals("dcif:profile") && !this.curProfs.contains(pf = new Profile(null, this.curContent))) {
            this.curProfs.add(pf);
        }
        this.recordContent = false;
        this.curContent = null;
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.curDC = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("dcif:dataCategory")) {
            this.curDC = new DCSmall(atts.getValue("pid"), null);
        } else if (qName.equals("dcif:profile")) {
            this.recordContent = true;
        } else if (qName.equals("dcif:languageSection")) {
            this.inLanguage = true;
        } else if (qName.equals("dcif:language")) {
            if (this.inLanguage) {
                this.recordContent = true;
            }
        } else if (qName.equals("dcif:definition")) {
            this.recordContent = true;
        } else if (qName.equals("dcif:name")) {
            this.recordContent = true;
        } else if (qName.equals("dcif:identifier")) {
            this.recordContent = true;
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

