/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.JPopupMenu;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.DesktopAppHandler;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.update.ExternalUpdaterThread;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.SystemReporting;

public class ELAN {
    public static int major = 5;
    public static int minor = 7;
    public static int micro = 0;
    public static String versionSuffix = "-FX";
    public static final String appName = "ELAN";
    public static final String propertiesFileName = "elan.properties";

    private ELAN() {
    }

    public static void main(final String[] args) {
        ClientLogger.LOG.info("");
        System.out.println("\n@ELAN Launched\n");
        System.setProperty("ELANApplicationMain", ELAN.class.getName());
        ClientLogger.LOG.info(String.format("%s %s\n", appName, ELAN.getVersionString()) + ELAN.getSystemAndUserInfo());
        ELAN.initPlatformPreferences();
        ELAN.readProperties();
        ELAN.updateUIDefaults();
        ELAN.detectUILabelFont();
        FrameManager.getInstance().setExitAllowed(true);
        if (args != null && args.length > 0 && args[0].length() != 0 && !args[0].startsWith("-")) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    File argFile = new File(args[0]);
                    ArrayList<String> mediaFiles = null;
                    if (args.length > 1) {
                        mediaFiles = new ArrayList<String>();
                        for (int i = 1; i < args.length; ++i) {
                            File mediaFile = new File(args[i]);
                            if (!mediaFile.isAbsolute()) {
                                mediaFiles.add(mediaFile.getAbsolutePath());
                                continue;
                            }
                            mediaFiles.add(args[i]);
                        }
                    }
                    if (!argFile.isAbsolute()) {
                        FrameManager.getInstance().createFrame(argFile.getAbsolutePath(), mediaFiles);
                    } else {
                        FrameManager.getInstance().createFrame(args[0], mediaFiles);
                    }
                }
            });
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FrameManager.getInstance().createEmptyFrame();
                }
            });
        }
        Boolean boolPref = Preferences.getBool("AutomaticUpdate", null);
        if (boolPref == null || boolPref.booleanValue()) {
            ExternalUpdaterThread updater = new ExternalUpdaterThread();
            updater.start();
        }
        DesktopAppHandler.getInstance().setHandlers();
    }

    static void initPlatformPreferences() {
        try {
            if (SystemReporting.isMacOS()) {
                String stringPref;
                boolean macLF;
                boolean screenBar = false;
                Boolean boolPref = Preferences.getBool("OS.Mac.useScreenMenuBar", null);
                if (boolPref != null) {
                    screenBar = boolPref;
                    System.setProperty("apple.laf.useScreenMenuBar", String.valueOf(screenBar));
                }
                if (!screenBar && (boolPref = Preferences.getBool("UseMacLF", null)) != null && !(macLF = boolPref.booleanValue())) {
                    try {
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (System.getProperty("PreferredMediaFramework") == null && (stringPref = Preferences.getString("Mac.PrefMediaFramework", null)) != null) {
                    System.setProperty("PreferredMediaFramework", stringPref);
                }
            } else if (SystemReporting.isWindows()) {
                Boolean boolPref;
                String stringPref;
                if (System.getProperty("PreferredMediaFramework") == null && (stringPref = Preferences.getString("Windows.PrefMediaFramework", null)) != null) {
                    System.setProperty("PreferredMediaFramework", stringPref);
                }
                if ((boolPref = Preferences.getBool("UseWinLF", null)) != null && boolPref.booleanValue()) {
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (Exception ex) {
                        ClientLogger.LOG.warning("Could not set the Look and Feel");
                    }
                }
            } else if (SystemReporting.isLinux()) {
                String stringPref;
                if (System.getProperty("PreferredMediaFramework") == null && (stringPref = Preferences.getString("Linux.PrefMediaFramework", null)) != null) {
                    System.setProperty("PreferredMediaFramework", stringPref);
                }
                if ((stringPref = Preferences.getString("Linux.PrefLookAndFeel", null)) != null) {
                    try {
                        if (stringPref.equals("SYSTEM_LF")) {
                            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                            ClientLogger.LOG.info("Set the Look and Feel to System L&F: " + UIManager.getSystemLookAndFeelClassName());
                        } else if (stringPref.equals("NIMBUS_LF")) {
                            UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
                            ClientLogger.LOG.info("Set the Look and Feel to Nimbus L&F");
                        } else {
                            ClientLogger.LOG.info("Using the Cross Platform L&F: " + UIManager.getCrossPlatformLookAndFeelClassName());
                        }
                    }
                    catch (Exception ex) {
                        ClientLogger.LOG.warning("Could not set the System Look and Feel");
                    }
                }
            }
            File dataDir = new File(Constants.ELAN_DATA_DIR);
            if (!dataDir.exists()) {
                dataDir.mkdir();
            }
        }
        catch (Throwable ex) {
            ClientLogger.LOG.warning("Could not create the application's data directory or apply some preferences: " + ex.getMessage());
        }
    }

    static void readProperties() {
        FileInputStream propFile = null;
        String propFileName = System.getProperty(propertiesFileName, propertiesFileName);
        try {
            propFile = new FileInputStream(propFileName);
            Properties p = new Properties(System.getProperties());
            p.load(propFile);
            System.setProperties(p);
        }
        catch (FileNotFoundException p) {
        }
        catch (IOException e) {
            ClientLogger.LOG.info("IOException while reading '" + propFileName + "' file: " + e.toString());
        }
        finally {
            if (propFile != null) {
                try {
                    propFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static void updateUIDefaults() {
        Object tableRowHeight;
        String defFontName = Constants.DEFAULTFONT.getFontName();
        int defFontSize = Constants.DEFAULTFONT.getSize();
        String defFontNameProp = System.getProperty("ELAN.Tiers.DefaultFontName");
        String defFontSizeProp = System.getProperty("ELAN.Tiers.DefaultFontSize");
        if (defFontNameProp != null && !defFontNameProp.isEmpty()) {
            defFontName = defFontNameProp;
        }
        if (defFontSizeProp != null && !defFontSizeProp.isEmpty()) {
            try {
                defFontSize = Integer.parseInt(defFontSizeProp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!defFontName.equals(Constants.DEFAULTFONT.getFontName()) || defFontSize != Constants.DEFAULTFONT.getSize()) {
            Constants.setDefaultFont(defFontName, defFontSize);
        }
        String prefUIFontName = System.getProperty("ELAN.UI.FontName");
        boolean allowAutoScaling = true;
        String autoScalingProp = System.getProperty("ELAN.UI.AutoDetectFontScaleFactor");
        if (autoScalingProp != null) {
            allowAutoScaling = Boolean.valueOf(autoScalingProp);
        }
        String fontScaleFactorProp = System.getProperty("ELAN.UI.FontScaleFactor");
        float scaleFactor = 1.0f;
        if (fontScaleFactorProp != null) {
            fontScaleFactorProp.replace(',', '.');
            try {
                scaleFactor = Float.parseFloat(fontScaleFactorProp);
            }
            catch (NumberFormatException nfe) {
                ClientLogger.LOG.warning("The value for the property 'ELAN.UI.FontScaleFactor' is not a valid float number");
            }
        }
        if (scaleFactor == 1.0f) {
            int screenRes;
            Float prefScaleFactor = Preferences.getFloat("UI.FontScaleFactor", null);
            if (prefScaleFactor != null) {
                scaleFactor = prefScaleFactor.floatValue();
                if (scaleFactor == 1.0f && (screenRes = SystemReporting.getScreenResolution()) > 144 && allowAutoScaling) {
                    scaleFactor = (float)screenRes / 144.0f;
                }
            } else {
                screenRes = SystemReporting.getScreenResolution();
                if (screenRes > 144 && allowAutoScaling) {
                    scaleFactor = (float)screenRes / 144.0f;
                }
            }
        }
        if (scaleFactor == 1.0f && prefUIFontName == null) {
            return;
        }
        HashMap<String, Object> fontResourcesMap = new HashMap<String, Object>();
        ArrayList<FontUIResource> fontResources = new ArrayList<FontUIResource>();
        UIDefaults curLFDefaults = UIManager.getLookAndFeelDefaults();
        HashMap<Object, Object> uid = new HashMap<Object, Object>(curLFDefaults);
        for (Object key : uid.keySet()) {
            String keyString = key.toString();
            Object value = curLFDefaults.get(keyString);
            if (!(value instanceof FontUIResource)) continue;
            fontResourcesMap.put(keyString, value);
            if (fontResources.contains(value)) continue;
            fontResources.add((FontUIResource)value);
        }
        for (FontUIResource fur : fontResources) {
            FontUIResource updateFUR = new FontUIResource(prefUIFontName == null ? fur.getFontName() : prefUIFontName, fur.getStyle(), (int)Math.ceil(scaleFactor * (float)fur.getSize()));
            for (String key : fontResourcesMap.keySet()) {
                Object value = fontResourcesMap.get(key);
                if (!value.equals(fur)) continue;
                UIManager.getLookAndFeelDefaults().put(key, updateFUR);
            }
        }
        Object treeRowHeight = curLFDefaults.get("Tree.rowHeight");
        if (treeRowHeight instanceof Integer) {
            int nextHeight = (int)(scaleFactor * (float)((Integer)treeRowHeight).intValue());
            UIManager.getLookAndFeelDefaults().put("Tree.rowHeight", (Object)nextHeight);
        }
        if ((tableRowHeight = curLFDefaults.get("Table.rowHeight")) instanceof Integer) {
            int nextHeight = (int)(scaleFactor * (float)((Integer)tableRowHeight).intValue());
            UIManager.getLookAndFeelDefaults().put("Table.rowHeight", (Object)nextHeight);
        }
        Constants.setFontScaling(scaleFactor);
    }

    static void detectUILabelFont() {
        Object labelFont = UIManager.getLookAndFeelDefaults().get("Label.font");
        if (labelFont instanceof FontUIResource) {
            Constants.setLookAndFeelLabelFont((FontUIResource)labelFont);
        } else {
            ClientLogger.LOG.info("Unable to detect the default Font for Labels");
        }
    }

    public static String getApplicationName() {
        return appName;
    }

    public static String getVersionString() {
        return major + "." + minor + versionSuffix;
    }

    public static String getSystemAndUserInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Java home: \t%s\n", System.getProperty("java.home")));
        sb.append(String.format("Java version: \t%s\n", System.getProperty("java.version")));
        sb.append(String.format("Runtime: \t%s\n", System.getProperty("java.runtime.version")));
        sb.append(String.format("OS name: \t%s\n", System.getProperty("os.name")));
        sb.append(String.format("OS version: \t%s\n", System.getProperty("os.version")));
        sb.append(String.format("OS arch.: \t%s\n", System.getProperty("os.arch")));
        sb.append(String.format("User language: \t%s\n", System.getProperty("user.language")));
        sb.append(String.format("User home: \t%s\n", System.getProperty("user.home")));
        sb.append(String.format("User dir: \t%s\n", System.getProperty("user.dir")));
        sb.append(String.format("Classpath: \t%s\n", System.getProperty("java.class.path")));
        sb.append(String.format("Library path: \t%s\n", System.getProperty("java.library.path")));
        List<String> screenInfo = SystemReporting.getScreenInfo();
        if (screenInfo != null && !screenInfo.isEmpty()) {
            sb.append("Display info:\n");
            for (String s : screenInfo) {
                sb.append(String.format("\t%s\n", s));
            }
        }
        return sb.toString();
    }
}

