/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.FlowLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.util.TimeFormatter;

public class ModePanel
extends JPanel
implements ElanLocaleListener {
    private ElanMediaPlayerController mediaPlayerController;
    private ViewerManager2 vm;
    private JCheckBox chkLoopMode;
    private JCheckBox chkSelectionMode;
    private String STRTIMEBETWEENLOOPSINPUTBOX1 = "";
    private String STRTIMEBETWEENLOOPSINPUTBOX2 = "";
    private String STRTIMEBETWEENLOOPSINPUTBOX3 = "";
    private String STRTIMEBETWEENLOOPSINPUTBOX4 = "";
    private String STRTIMEBETWEENLOOPSINPUTBOX5 = "";
    private String STRTIMEBETWEENLOOPSINPUTBOX6 = "";

    public ModePanel(ViewerManager2 theVM, ElanMediaPlayerController theMPC) {
        this.vm = theVM;
        this.mediaPlayerController = theMPC;
        FlowLayout flowLayout = new FlowLayout(0, 0, 0);
        this.setLayout(flowLayout);
        this.chkSelectionMode = new JCheckBox(ELANCommandFactory.getCommandAction(this.vm.getTranscription(), "CommandActions.SelectionMode"));
        this.chkSelectionMode.setFont(Constants.deriveSmallFont(this.chkSelectionMode.getFont()));
        this.add(this.chkSelectionMode);
        JLabel jlabeltemp = new JLabel("  ");
        this.add(jlabeltemp);
        this.chkLoopMode = new JCheckBox(ELANCommandFactory.getCommandAction(this.vm.getTranscription(), "CommandActions.LoopMode"));
        this.chkLoopMode.setFont(Constants.deriveSmallFont(this.chkLoopMode.getFont()));
        this.add(this.chkLoopMode);
        ElanLocale.addElanLocaleListener(this.vm.getTranscription(), this);
        this.updateLocale();
    }

    public void updateLoopMode(boolean onOff) {
        this.chkLoopMode.setSelected(onOff);
    }

    public void updateSelectionMode(boolean onOff) {
        if (this.chkSelectionMode.isSelected() != onOff) {
            this.chkSelectionMode.setSelected(onOff);
        }
    }

    public void showTimeBetweenLoopsInputBox() {
        boolean bAgain = true;
        while (bAgain) {
            double curTimeInSeconds = (double)this.mediaPlayerController.getUserTimeBetweenLoops() / 1000.0;
            String strNewTime = JOptionPane.showInputDialog(this, this.STRTIMEBETWEENLOOPSINPUTBOX1 + " " + curTimeInSeconds + "\n" + this.STRTIMEBETWEENLOOPSINPUTBOX2, this.STRTIMEBETWEENLOOPSINPUTBOX3, -1);
            if (strNewTime != null && !strNewTime.equals("")) {
                long lngSeconds = TimeFormatter.toMilliSeconds(strNewTime);
                if ((double)lngSeconds >= 0.0) {
                    this.mediaPlayerController.setUserTimeBetweenLoops(lngSeconds);
                    bAgain = false;
                } else {
                    JOptionPane.showMessageDialog(this, this.STRTIMEBETWEENLOOPSINPUTBOX4 + "\n" + this.STRTIMEBETWEENLOOPSINPUTBOX5, this.STRTIMEBETWEENLOOPSINPUTBOX6, 0);
                    bAgain = true;
                }
            }
            if (strNewTime != null) continue;
            break;
        }
    }

    public void setModeVisible(String mode, boolean visible) {
        if ("CommandActions.SelectionMode".equals(mode)) {
            this.chkSelectionMode.setVisible(visible);
        } else if ("CommandActions.LoopMode".equals(mode)) {
            this.chkLoopMode.setVisible(visible);
        }
    }

    @Override
    public void updateLocale() {
        this.STRTIMEBETWEENLOOPSINPUTBOX1 = ElanLocale.getString("MediaPlayerControlPanel.STRTIMEBETWEENLOOPSINPUTBOX1");
        this.STRTIMEBETWEENLOOPSINPUTBOX2 = ElanLocale.getString("MediaPlayerControlPanel.STRTIMEBETWEENLOOPSINPUTBOX2");
        this.STRTIMEBETWEENLOOPSINPUTBOX3 = ElanLocale.getString("MediaPlayerControlPanel.STRTIMEBETWEENLOOPSINPUTBOX3");
        this.STRTIMEBETWEENLOOPSINPUTBOX4 = ElanLocale.getString("MediaPlayerControlPanel.STRTIMEBETWEENLOOPSINPUTBOX4");
        this.STRTIMEBETWEENLOOPSINPUTBOX5 = ElanLocale.getString("MediaPlayerControlPanel.STRTIMEBETWEENLOOPSINPUTBOX5");
    }
}

