/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.SelectionListener;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.util.TimeFormatter;

public class SelectionPanel
extends JPanel
implements ElanLocaleListener,
SelectionListener {
    private JLabel selectionLabel;
    private JLabel beginLabel;
    private JLabel endLabel;
    private JLabel lengthLabel;
    private long begin;
    private long end;
    private ViewerManager2 vm;

    public SelectionPanel(ViewerManager2 theVM) {
        this.vm = theVM;
        this.init();
    }

    private void init() {
        FlowLayout flowLayout = new FlowLayout(0, 0, 0);
        this.setLayout(flowLayout);
        this.lengthLabel = new JLabel();
        this.lengthLabel.setFont(Constants.deriveSmallFont(this.lengthLabel.getFont()));
        this.selectionLabel = new JLabel();
        this.selectionLabel.setFont(this.lengthLabel.getFont());
        this.add(this.selectionLabel);
        this.beginLabel = new JLabel();
        this.beginLabel.setFont(this.lengthLabel.getFont());
        this.setBegin(0L);
        this.add(this.beginLabel);
        JLabel separator = new JLabel(" - ");
        separator.setFont(this.lengthLabel.getFont());
        this.add(separator);
        this.endLabel = new JLabel();
        this.endLabel.setFont(this.lengthLabel.getFont());
        this.setEnd(0L);
        this.add(this.endLabel);
        JLabel spaces = new JLabel("  ");
        spaces.setFont(this.lengthLabel.getFont());
        this.add(spaces);
        this.add(this.lengthLabel);
        ElanLocale.addElanLocaleListener(this.vm.getTranscription(), this);
        this.updateLocale();
        this.vm.getSelection().addSelectionListener(this);
    }

    public void setNameLabel(String str) {
        this.selectionLabel.setText(str + ": ");
    }

    public void setBegin(long begin) {
        this.begin = begin;
        this.beginLabel.setText(TimeFormatter.toString(begin));
        this.setLength();
    }

    public void setEnd(long end) {
        this.end = end;
        this.endLabel.setText(TimeFormatter.toString(end));
        this.setLength();
    }

    private void setLength() {
        this.lengthLabel.setText("" + (this.end - this.begin));
    }

    @Override
    public void updateLocale() {
        this.setNameLabel(ElanLocale.getString("MediaPlayerControlPanel.Selectionpanel.Name"));
    }

    @Override
    public void updateSelection() {
        long end;
        long begin = this.vm.getSelection().getBeginTime();
        if (begin == (end = this.vm.getSelection().getEndTime())) {
            begin = 0L;
            end = 0L;
        }
        this.setBegin(begin);
        this.setEnd(end);
    }
}

