/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ViewerManager2;

public class VolumeIconPanel
extends JPanel
implements ActionListener {
    private ViewerManager2 vm;
    private JButton volButton;
    private int orientation = 0;
    private int size1 = 200;
    private int size2 = 24;
    private Dimension prefSize;

    public VolumeIconPanel(ViewerManager2 vm) {
        this(vm, 0);
    }

    public VolumeIconPanel(ViewerManager2 vm, int orientation) {
        this.vm = vm;
        this.orientation = orientation;
        this.initComponents();
    }

    public VolumeIconPanel(ViewerManager2 vm, int orientation, Dimension buttonSize) {
        this.vm = vm;
        this.orientation = orientation;
        this.initComponents();
        this.prefSize = buttonSize;
    }

    public void setPopupSize(int width, int height) {
        this.size1 = width;
        this.size2 = height;
    }

    private void initComponents() {
        this.setLayout(new GridLayout(1, 1));
        ImageIcon icon = null;
        String text = null;
        try {
            icon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/media/Volume16.gif"));
        }
        catch (Exception ex) {
            text = "V";
        }
        this.volButton = new JButton(text, icon);
        this.volButton.setBorderPainted(false);
        this.volButton.setPreferredSize(new Dimension(24, 24));
        this.volButton.setAlignmentY(0.5f);
        this.volButton.setAlignmentX(0.5f);
        this.volButton.addActionListener(this);
        this.add(this.volButton);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        VolumeWindow vw = new VolumeWindow(SwingUtilities.getWindowAncestor(this.volButton));
        Point p = this.getLocationOnScreen();
        if (this.orientation == 0) {
            int w = this.size1;
            int h = this.size2;
            vw.setBounds(p.x + this.getWidth(), p.y, w, h);
        } else {
            int h = this.size1;
            int w = this.size2;
            vw.setBounds(p.x, p.y + this.getHeight(), w, h);
        }
        vw.setVisible(true);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.prefSize != null) {
            return this.prefSize;
        }
        return super.getPreferredSize();
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        this.prefSize = preferredSize;
        super.setPreferredSize(preferredSize);
    }

    class VolumeWindow
    extends JWindow
    implements FocusListener,
    ChangeListener,
    MouseListener {
        private JPanel compPanel;
        private JSlider slider;
        private JLabel volLabel;

        public VolumeWindow(Window parent) {
            super(parent);
            this.initComponents();
        }

        private void initComponents() {
            this.compPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            float volume = 100.0f;
            volume = 100.0f * VolumeIconPanel.this.vm.getVolumeManager().getMasterVolume();
            this.volLabel = new JLabel(String.valueOf((int)volume));
            this.volLabel.setFont(this.volLabel.getFont().deriveFont(0, 10.0f));
            this.volLabel.setHorizontalAlignment(0);
            int tw = this.volLabel.getFontMetrics(this.volLabel.getFont()).stringWidth("000");
            this.volLabel.setPreferredSize(new Dimension(tw, this.volLabel.getPreferredSize().height));
            this.volLabel.setMinimumSize(new Dimension(tw, this.volLabel.getPreferredSize().height));
            this.compPanel.add((Component)this.volLabel, gbc);
            if (VolumeIconPanel.this.orientation == 0) {
                gbc.gridx = 1;
                gbc.fill = 2;
                gbc.weightx = 1.0;
            } else {
                gbc.gridy = 1;
                gbc.fill = 3;
                gbc.weighty = 1.0;
            }
            this.slider = new JSlider(VolumeIconPanel.this.orientation, 0, 100, (int)volume);
            this.slider.addChangeListener(this);
            this.slider.addFocusListener(this);
            this.slider.addMouseListener(this);
            this.compPanel.add((Component)this.slider, gbc);
            this.add(this.compPanel);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.setVisible(false);
            this.dispose();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            float volume = (float)this.slider.getValue() / 100.0f;
            VolumeIconPanel.this.vm.getMediaPlayerController().setVolume(volume);
            this.volLabel.setText(String.valueOf(this.slider.getValue()));
        }

        @Override
        public void setVisible(boolean b) {
            super.setVisible(b);
            if (b) {
                this.slider.grabFocus();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setVisible(false);
            this.dispose();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

