/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ExitStrategyPane;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.client.annotator.viewer.SignalViewer;
import mpi.eudico.client.annotator.viewer.SignalViewerControlPanel;
import mpi.eudico.client.util.SelectableObject;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;

public class WaveFormViewerMenuManager {
    private ElanFrame2 frame;
    private Transcription transcription;
    private List<SelectableObject<MediaDescriptor>> menuWaveForm;
    private HashMap<String, AbstractAction> actionMap;
    private SignalViewerControlPanel signalViewerControlPanel;
    private String currentMediaURL;
    private ExitStrategyPane masterMediaWarningPanel;

    public WaveFormViewerMenuManager(ElanFrame2 frame, Transcription transcription) {
        this.frame = frame;
        this.transcription = transcription;
        this.menuWaveForm = new ArrayList<SelectableObject<MediaDescriptor>>();
        this.actionMap = new HashMap();
        this.masterMediaWarningPanel = new ExitStrategyPane();
    }

    public List<SelectableObject<MediaDescriptor>> getWaveFormList() {
        return this.menuWaveForm;
    }

    public void setSignalViewerControlPanel(SignalViewerControlPanel panel) {
        this.signalViewerControlPanel = panel;
    }

    public void loadPreferences() {
        String mediaURL = Preferences.getString("WaveFormViewer.ActiveURL", this.transcription);
        AbstractAction action = this.actionMap.get(mediaURL);
        if (mediaURL != null && action != null) {
            this.frame.setMenuSelected(mediaURL, 630);
            this.playerActionPerformed(action, null, true);
        }
    }

    public void initWaveFormViewerMenu() {
        List<MediaDescriptor> descriptors = this.transcription.getMediaDescriptors();
        int visibles = 0;
        this.actionMap.clear();
        for (int i = 0; i < descriptors.size(); ++i) {
            MediaDescriptor md = descriptors.get(i);
            if (md.mimeType == null || !md.mimeType.equals("audio/x-wav") && !md.mimeType.equals("audio/*")) continue;
            boolean curValid = MediaDescriptorUtil.checkLinkStatus(md);
            String fileName = FileUtility.fileNameFromPath(md.mediaURL);
            PlayerAction action = new PlayerAction(md.mediaURL, fileName);
            if (!curValid) {
                action.setEnabled(false);
            }
            this.frame.addActionToMenu(action, 630, -1);
            this.actionMap.put(md.mediaURL, action);
            if (visibles == 0) {
                this.frame.setMenuSelected(md.mediaURL, 630);
                this.menuWaveForm.add(new SelectableObject<MediaDescriptor>(md, true));
                ++visibles;
                continue;
            }
            this.menuWaveForm.add(new SelectableObject<MediaDescriptor>(md, false));
        }
        this.loadPreferences();
        if (this.signalViewerControlPanel != null) {
            this.signalViewerControlPanel.initViewerPopUPMenu();
        }
    }

    public void reinitializeWaveFormMenu() {
        for (int i = 0; i < this.menuWaveForm.size(); ++i) {
            SelectableObject<MediaDescriptor> sob = this.menuWaveForm.get(i);
            MediaDescriptor md = sob.getValue();
            this.frame.removeActionFromMenu(md.mediaURL, 630);
        }
        this.menuWaveForm.clear();
        this.initWaveFormViewerMenu();
    }

    public void performActionFor(String mediaURL, ActionEvent e) {
        this.frame.setMenuSelected(mediaURL, 630);
        this.playerActionPerformed(this.actionMap.get(mediaURL), e);
    }

    void playerActionPerformed(AbstractAction action, ActionEvent e) {
        Boolean boolPref = Preferences.getBool("WaveFormViewer.SupressMasterMediaWarning", null);
        boolean supressWarning = false;
        if (boolPref != null) {
            supressWarning = boolPref;
        }
        this.playerActionPerformed(action, e, supressWarning);
    }

    void playerActionPerformed(AbstractAction action, ActionEvent e, boolean supressWarning) {
        if (action != null) {
            String url = (String)action.getValue("LongDescription");
            if (!supressWarning && this.isMasterMediaWavFile() && (this.isMasterMediaPlayer(this.currentMediaURL) || !this.isMasterMediaPlayer(url))) {
                this.masterMediaWarningPanel.setMessage("<html>" + ElanLocale.getString("WaveFormViewer.MasterMedia.Warn1") + "<br>" + ElanLocale.getString("WaveFormViewer.MasterMedia.Warn2") + "<br><br></html>");
                int s = JOptionPane.showConfirmDialog(this.frame, this.masterMediaWarningPanel, "Warning", 0, 2);
                if (s == 1) {
                    return;
                }
                Preferences.set("WaveFormViewer.SupressMasterMediaWarning", this.masterMediaWarningPanel.getDontShowAgain(), null);
            }
            MediaDescriptor newMD = null;
            MediaDescriptor md = null;
            SelectableObject<MediaDescriptor> sob = null;
            for (int i = 0; i < this.menuWaveForm.size(); ++i) {
                sob = this.menuWaveForm.get(i);
                md = sob.getValue();
                if (sob.isSelected() && !md.mediaURL.equals(url)) {
                    sob.setSelected(false);
                }
                if (!md.mediaURL.equals(url) || newMD != null) continue;
                sob.setSelected(true);
                newMD = md;
            }
            if (newMD != null) {
                SignalViewer viewer;
                if (this.signalViewerControlPanel != null) {
                    this.signalViewerControlPanel.updateWaveFormPanel(newMD.mediaURL);
                }
                if ((viewer = this.frame.getViewerManager().getSignalViewer()) != null) {
                    viewer.setMedia(newMD.mediaURL);
                    viewer.setOffset(newMD.timeOrigin);
                    this.frame.getViewerManager().updateSignalViewerMedia(newMD.mediaURL);
                    Preferences.set("WaveFormViewer.ActiveURL", newMD.mediaURL, this.transcription);
                }
            }
        }
    }

    private boolean isMasterMediaPlayer(String mediaURL) {
        MediaDescriptor otherMd;
        return mediaURL != null && (otherMd = this.frame.getViewerManager().getMasterMediaPlayer().getMediaDescriptor()) != null && mediaURL.equals(otherMd.mediaURL);
    }

    private boolean isMasterMediaWavFile() {
        MediaDescriptor otherMd = this.frame.getViewerManager().getMasterMediaPlayer().getMediaDescriptor();
        return otherMd != null && otherMd.mimeType.equals("audio/x-wav");
    }

    class PlayerAction
    extends AbstractAction {
        PlayerAction(String fileUrl, String fileName) {
            this.putValue("Name", fileName);
            this.putValue("LongDescription", fileUrl);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WaveFormViewerMenuManager.this.playerActionPerformed(this, e);
        }
    }
}

