/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.commands.AbstractProgressCommand;
import mpi.eudico.client.annotator.interannotator.CompareCombi;
import mpi.eudico.client.annotator.interannotator.CompareConstants;
import mpi.eudico.client.annotator.interannotator.CompareResultWriter;
import mpi.eudico.client.annotator.interannotator.CompareUnit;
import mpi.eudico.client.annotator.interannotator.TierAndFileMatcher;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.AnnotationCore;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AnnotationCoreImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public abstract class AbstractCompareCommand
extends AbstractProgressCommand {
    protected Map<Object, Object> compareProperties;
    protected List<CompareCombi> compareSegments;
    protected TranscriptionImpl transcription;
    protected TierAndFileMatcher tfMatcher;
    protected final String eafExt = ".eaf";
    protected int numFiles;
    protected int numSelTiers;

    public AbstractCompareCommand(String theName) {
        super(theName);
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        super.execute(receiver, arguments);
        this.transcription = (TranscriptionImpl)receiver;
        if (this.transcription != null) {
            this.numFiles = 1;
        }
        this.compareProperties = (Map)arguments[0];
        if (this.compareProperties == null || this.compareProperties.size() == 0) {
            this.progressInterrupt("No input provided for calculations.");
            return;
        }
        this.compareSegments = new ArrayList<CompareCombi>();
        this.tfMatcher = new TierAndFileMatcher();
        CompareAnnotatorsThread cat = new CompareAnnotatorsThread();
        cat.start();
    }

    public List<CompareCombi> getCompareSegments() {
        return this.compareSegments;
    }

    protected void logErrorAndInterrupt(String message) {
        ClientLogger.LOG.warning(message);
        this.progressInterrupt(message);
    }

    protected void createSegments() {
        CompareConstants.FILE_MATCHING sourceMatch = (CompareConstants.FILE_MATCHING)((Object)this.compareProperties.get("Compare.TierSource"));
        CompareConstants.MATCHING tierMatching = (CompareConstants.MATCHING)((Object)this.compareProperties.get("Compare.TierMatching"));
        CompareConstants.MATCHING fileMatching = (CompareConstants.MATCHING)((Object)this.compareProperties.get("Compare.FileMatching"));
        String tierNameSeparators = (String)this.compareProperties.get("Compare.TierSeparator");
        String fileNameSeparators = (String)this.compareProperties.get("Compare.FileSeparator");
        String tierName1 = (String)this.compareProperties.get("Compare.TierName1");
        String tierName2 = (String)this.compareProperties.get("Compare.TierName2");
        List selTierNames = (List)this.compareProperties.get("Compare.SelectedTierNames");
        List allTierNames = (List)this.compareProperties.get("Compare.AllTierNames");
        List selFiles = (List)this.compareProperties.get("Compare.SelectedFiles");
        if (selFiles != null) {
            this.numFiles = selFiles.size();
        }
        if (selTierNames != null) {
            this.numSelTiers = selTierNames.size();
        } else if (tierName1 != null && tierName2 != null) {
            this.numSelTiers = 2;
        }
        this.curProgress = 1.0f;
        this.progressUpdate((int)this.curProgress, "Starting to extract segments from the selected tiers.");
        if (sourceMatch == CompareConstants.FILE_MATCHING.CURRENT_DOC) {
            if (this.transcription == null) {
                this.progressInterrupt("The transcription is null");
                return;
            }
            if (tierMatching == CompareConstants.MATCHING.MANUAL) {
                if (tierName1 == null) {
                    this.progressInterrupt("The first manually selected tier is null");
                    return;
                }
                if (tierName2 == null) {
                    this.progressInterrupt("The second manually selected tier is null");
                    return;
                }
                if (tierName1.equals(tierName2)) {
                    this.progressInterrupt("The first and second selected tier have the same name (not allowed)");
                    return;
                }
                this.extractSegments(this.transcription, tierName1, tierName2);
            } else if (tierMatching == CompareConstants.MATCHING.PREFIX || tierMatching == CompareConstants.MATCHING.SUFFIX) {
                if (selTierNames == null || selTierNames.size() == 0) {
                    this.progressInterrupt("There are no tiers selected for comparing based on affix");
                    return;
                }
                this.extractSegments(this.transcription, selTierNames, tierMatching, tierNameSeparators);
            } else if (tierMatching == CompareConstants.MATCHING.SAME_NAME) {
                this.progressInterrupt("Cannot compare tiers with the same name in the same document");
                return;
            }
        } else if (sourceMatch == CompareConstants.FILE_MATCHING.IN_SAME_FILE) {
            if (selFiles == null || selFiles.size() == 0) {
                this.progressInterrupt("There are no files selected, cannot retrieve the tiers to compare.");
                return;
            }
            if (tierMatching == CompareConstants.MATCHING.MANUAL) {
                if (tierName1 == null) {
                    this.progressInterrupt("The first manually selected tier is null");
                    return;
                }
                if (tierName2 == null) {
                    this.progressInterrupt("The second manually selected tier is null");
                    return;
                }
                if (tierName1.equals(tierName2)) {
                    this.progressInterrupt("The first and second selected tier have the same name (not allowed)");
                    return;
                }
                this.extractSegments(selFiles, null, null, tierName1, tierName2);
            } else if (tierMatching == CompareConstants.MATCHING.PREFIX || tierMatching == CompareConstants.MATCHING.SUFFIX) {
                if (selTierNames == null || selTierNames.size() == 0) {
                    this.progressInterrupt("There are no tiers selected for comparing based on affix");
                    return;
                }
                this.extractSegments(selFiles, null, null, selTierNames, allTierNames, tierMatching, tierNameSeparators);
            } else if (tierMatching == CompareConstants.MATCHING.SAME_NAME) {
                this.progressInterrupt("Tiers with the same name cannot be in the same file");
                return;
            }
        } else if (sourceMatch == CompareConstants.FILE_MATCHING.ACROSS_FILES) {
            if (selFiles == null || selFiles.size() < 2) {
                this.progressInterrupt("There are no files or too few files selected, cannot retrieve the tiers to compare.");
                return;
            }
            if (fileMatching != CompareConstants.MATCHING.PREFIX && fileMatching != CompareConstants.MATCHING.SUFFIX) {
                this.progressInterrupt("Cannot determine how to match files, e.g. based on prefix or suffix");
                return;
            }
            if (tierMatching == CompareConstants.MATCHING.MANUAL) {
                if (tierName1 == null) {
                    this.progressInterrupt("The first manually selected tier is null");
                    return;
                }
                if (tierName2 == null) {
                    this.progressInterrupt("The second manually selected tier is null");
                    return;
                }
                if (tierName1.equals(tierName2)) {
                    this.progressInterrupt("The first and second selected tier have the same name (not allowed)");
                    return;
                }
                this.extractSegments(selFiles, fileMatching, fileNameSeparators, tierName1, tierName2);
            } else if (tierMatching == CompareConstants.MATCHING.PREFIX || tierMatching == CompareConstants.MATCHING.SUFFIX) {
                if (selTierNames == null || selTierNames.size() == 0) {
                    this.progressInterrupt("There are no tiers selected for comparing based on affix");
                    return;
                }
                this.extractSegments(selFiles, fileMatching, fileNameSeparators, selTierNames, allTierNames, tierMatching, tierNameSeparators);
            } else if (tierMatching == CompareConstants.MATCHING.SAME_NAME) {
                if (selTierNames == null || selTierNames.size() == 0) {
                    this.progressInterrupt("There are no tiers selected for comparing based on same name");
                    return;
                }
                this.extractSegments(selFiles, fileMatching, fileNameSeparators, selTierNames, null, null, null);
            }
        }
        if (this.errorOccurred) {
            return;
        }
        if (this.cancelled) {
            this.progressInterrupt("The process was cancelled while extracting segments from the tiers.");
        }
        this.curProgress = 30.0f;
        if (this.compareSegments.size() > 0) {
            this.progressUpdate((int)this.curProgress, String.format("Extracted the annotations of %d pairs of tiers...", this.compareSegments.size()));
        } else {
            this.progressInterrupt("There are no segments for the agreement calculation, process stopped.");
        }
    }

    private void extractSegments(TranscriptionImpl transcription, String tierName1, String tierName2) {
        TierImpl t1 = transcription.getTierWithId(tierName1);
        TierImpl t2 = transcription.getTierWithId(tierName2);
        if (t1 == null) {
            String message = String.format("The tier \"%s\" is not found in the transcription.", tierName1);
            this.logErrorAndInterrupt(message);
            return;
        }
        if (t2 == null) {
            String message = String.format("The tier \"%s\" is not found in the transcription.", tierName2);
            this.logErrorAndInterrupt(message);
            return;
        }
        List<AnnotationCore> segments1 = this.getAnnotationCores(t1);
        this.curProgress = 15.0f;
        this.progressUpdate((int)this.curProgress, "Extracted segments from tier " + tierName1);
        List<AnnotationCore> segments2 = this.getAnnotationCores(t2);
        this.curProgress = 25.0f;
        this.progressUpdate((int)this.curProgress, "Extracted segments from tier " + tierName2);
        if (segments1.isEmpty() && segments2.isEmpty()) {
            ClientLogger.LOG.warning(String.format("Both tier \"%s\" and tier \"%s\" are empty (no segments).", tierName1, tierName2));
            return;
        }
        CompareUnit cu1 = new CompareUnit(transcription.getFullPath(), t1.getName(), t1.getAnnotator());
        cu1.annotations = segments1;
        CompareUnit cu2 = new CompareUnit(transcription.getFullPath(), t2.getName(), t2.getAnnotator());
        cu2.annotations = segments2;
        CompareCombi cc = new CompareCombi(cu1, cu2);
        this.compareSegments.add(cc);
    }

    private void extractSegments(TranscriptionImpl transcription, List<String> selTierNames, CompareConstants.MATCHING tierMatching, String tierNameSeparators) {
        ArrayList<String> allTierNames = new ArrayList<String>();
        List<TierImpl> tiers = transcription.getTiers();
        Tier t = null;
        for (int i = 0; i < tiers.size(); ++i) {
            t = tiers.get(i);
            allTierNames.add(t.getName());
        }
        List<List<String>> tierMatches = this.tfMatcher.getMatchingTiers(allTierNames, selTierNames, tierMatching, tierNameSeparators);
        if (tierMatches.size() == 0) {
            this.logErrorAndInterrupt("No matching tiers (same name, different affix) have been found.");
            return;
        }
        this.curProgress = 3.0f;
        this.progressUpdate((int)this.curProgress, String.format("Found %d pairs of tiers.", tierMatches.size()));
        float perMatch = 25.0f / (float)tierMatches.size();
        for (List<String> curMatches : tierMatches) {
            for (int i = 0; i < curMatches.size(); ++i) {
                TierImpl t1 = transcription.getTierWithId(curMatches.get(i));
                List<AnnotationCore> segments1 = null;
                if (t1 != null) {
                    segments1 = this.getAnnotationCores(t1);
                    for (int j = i + 1; j < curMatches.size(); ++j) {
                        TierImpl t2 = transcription.getTierWithId(curMatches.get(j));
                        if (t2 != null) {
                            List<AnnotationCore> segments2 = this.getAnnotationCores(t2);
                            if (!segments1.isEmpty() || !segments2.isEmpty()) {
                                CompareUnit cu1 = new CompareUnit(transcription.getFullPath(), t1.getName(), t1.getAnnotator());
                                cu1.annotations = segments1;
                                CompareUnit cu2 = new CompareUnit(transcription.getFullPath(), t2.getName(), t2.getAnnotator());
                                cu2.annotations = segments2;
                                CompareCombi cc = new CompareCombi(cu1, cu2);
                                this.compareSegments.add(cc);
                                continue;
                            }
                            ClientLogger.LOG.warning(String.format("Matching tiers \"%s\" and \"%s\" are both empty (no segments).", t1.getName(), t2.getName()));
                            continue;
                        }
                        ClientLogger.LOG.warning(String.format("Matching tier \"%s\" and \"%s\": the second tier does not exist.", t1.getName(), curMatches.get(j)));
                    }
                    continue;
                }
                ClientLogger.LOG.warning(String.format("Matching tiers: the first tier \"%s\" does not exist.", curMatches.get(i)));
            }
            this.curProgress += perMatch;
            this.progressUpdate((int)this.curProgress, null);
            if (!this.cancelled) continue;
            return;
        }
    }

    private void extractSegments(List<File> selFiles, CompareConstants.MATCHING fileMatching, String fileNameSeparators, String tierName1, String tierName2) {
        if (fileMatching == null) {
            this.progressUpdate((int)this.curProgress, "Extracting segments from each file...");
            float perFile = 28.0f / (float)selFiles.size();
            for (File f : selFiles) {
                if (f.isDirectory()) {
                    this.curProgress += perFile;
                    continue;
                }
                TranscriptionImpl t1 = this.createTranscription(f);
                if (t1 != null) {
                    TierImpl tier2;
                    TierImpl tier1 = t1.getTierWithId(tierName1);
                    CompareCombi cc = this.createCompareCombi(tier1, tier2 = t1.getTierWithId(tierName2));
                    if (cc != null) {
                        this.compareSegments.add(cc);
                    }
                } else {
                    ClientLogger.LOG.warning(String.format("A transcription could not be loaded from file \"%s\"", f.getAbsolutePath()));
                }
                this.curProgress += perFile;
                this.progressUpdate((int)this.curProgress, null);
            }
        } else {
            this.progressUpdate((int)this.curProgress, "Extracting segments from file pairs...");
            List<List<File>> matchingFiles = this.tfMatcher.getMatchingFiles(selFiles, fileMatching, fileNameSeparators, ".eaf");
            if (matchingFiles.size() == 0) {
                this.logErrorAndInterrupt("No matching files found in the list of selected files");
                return;
            }
            this.curProgress = 4.0f;
            this.progressUpdate((int)this.curProgress, String.format("Found %d pairs of matching files...", matchingFiles.size()));
            TranscriptionImpl t1 = null;
            TranscriptionImpl t2 = null;
            float perMatch = 25.0f / (float)matchingFiles.size();
            for (List<File> matchList : matchingFiles) {
                for (int i = 0; i < matchList.size(); ++i) {
                    t1 = this.createTranscription(matchList.get(i));
                    if (t1 == null) {
                        ClientLogger.LOG.info(String.format("A transcription could not be loaded from file (t1) \"%s\"", matchList.get(i).getAbsolutePath()));
                        continue;
                    }
                    for (int j = i + 1; j < matchList.size(); ++j) {
                        t2 = this.createTranscription(matchList.get(j));
                        if (t2 == null) {
                            ClientLogger.LOG.info(String.format("A transcription could not be loaded from file (t2) \"%s\"", matchList.get(j).getAbsolutePath()));
                            continue;
                        }
                        this.compareSegments.addAll(this.getCompareCombinations(t1, t2, tierName1, tierName2));
                    }
                }
                this.curProgress += perMatch;
                this.progressUpdate((int)this.curProgress, null);
            }
        }
        this.progressUpdate((int)this.curProgress, String.format("Extracted the annotations of %1$d pairs of tiers from %2$d files...", this.compareSegments.size(), selFiles.size()));
    }

    private void extractSegments(List<File> selFiles, CompareConstants.MATCHING fileMatching, String fileNameSeparators, List<String> selTierNames, List<String> allTierNames, CompareConstants.MATCHING tierMatching, String tierNameSeparators) {
        if (fileMatching == null && tierMatching == null) {
            this.logErrorAndInterrupt("Cannot compare tiers with the same name in the same file.");
            return;
        }
        List<List<File>> matchingFiles = null;
        List<List<String>> matchingTiers = null;
        if (fileMatching != null && (matchingFiles = this.tfMatcher.getMatchingFiles(selFiles, fileMatching, fileNameSeparators, ".eaf")).isEmpty()) {
            this.logErrorAndInterrupt("No matching files found in the list of selected files.");
            return;
        }
        if (tierMatching == CompareConstants.MATCHING.PREFIX || tierMatching == CompareConstants.MATCHING.SUFFIX) {
            matchingTiers = this.tfMatcher.getMatchingTiers(allTierNames, selTierNames, tierMatching, tierNameSeparators);
        }
        this.curProgress = 3.0f;
        this.progressUpdate((int)this.curProgress, null);
        if (matchingFiles == null) {
            this.progressUpdate((int)this.curProgress, "Extracting segments from each file...");
            float perFile = 26.0f / (float)selFiles.size();
            for (File f : selFiles) {
                if (f.isDirectory()) {
                    this.curProgress += perFile;
                    continue;
                }
                TranscriptionImpl t1 = this.createTranscription(f);
                if (t1 != null) {
                    for (List<String> tierMatch : matchingTiers) {
                        for (int i = 0; i < tierMatch.size(); ++i) {
                            String tName1 = tierMatch.get(i);
                            for (int j = i + 1; j < tierMatch.size(); ++j) {
                                TierImpl tier2;
                                String tName2 = tierMatch.get(j);
                                TierImpl tier1 = t1.getTierWithId(tName1);
                                CompareCombi cc = this.createCompareCombi(tier1, tier2 = t1.getTierWithId(tName2));
                                if (cc == null) continue;
                                this.compareSegments.add(cc);
                            }
                        }
                    }
                }
                this.curProgress += perFile;
                this.progressUpdate((int)this.curProgress, null);
            }
        } else {
            this.progressUpdate((int)this.curProgress, "Extracting segments from file pairs...");
            float perMatch = 28.0f / (float)matchingFiles.size();
            for (List<File> fileMatch : matchingFiles) {
                List<TranscriptionImpl> transMatch = this.createTranscriptions(fileMatch);
                if (transMatch.size() <= 1) {
                    this.curProgress += perMatch;
                    continue;
                }
                TranscriptionImpl ti1 = null;
                TranscriptionImpl ti2 = null;
                for (int i = 0; i < transMatch.size() - 1; ++i) {
                    ti1 = transMatch.get(i);
                    for (int j = i + 1; j < transMatch.size(); ++j) {
                        ti2 = transMatch.get(j);
                        if (matchingTiers == null) {
                            TierImpl tier1 = null;
                            TierImpl tier2 = null;
                            for (String tierName : selTierNames) {
                                tier1 = ti1.getTierWithId(tierName);
                                tier2 = ti2.getTierWithId(tierName);
                                if (tier1 != null && tier2 != null) {
                                    CompareCombi cc = this.createCompareCombi(tier1, tier2);
                                    if (cc == null) continue;
                                    this.compareSegments.add(cc);
                                    continue;
                                }
                                if (tier1 == null) {
                                    ClientLogger.LOG.warning(String.format("Tiers with same name in different files: tier \"%s\" not found in transcription \"%s\"", tierName, ti1.getName()));
                                }
                                if (tier2 != null) continue;
                                ClientLogger.LOG.warning(String.format("Tiers with same name in different files: tier \"%s\" not found in transcription \"%s\"", tierName, ti2.getName()));
                            }
                            continue;
                        }
                        for (List<String> tierMatch : matchingTiers) {
                            String name1 = null;
                            String name2 = null;
                            for (int m = 0; m < tierMatch.size() - 1; ++m) {
                                for (int n = m + 1; n < tierMatch.size(); ++n) {
                                    name1 = tierMatch.get(m);
                                    name2 = tierMatch.get(n);
                                    this.compareSegments.addAll(this.getCompareCombinations(ti1, ti2, name1, name2));
                                }
                            }
                        }
                    }
                }
                this.curProgress += perMatch;
                this.progressUpdate((int)this.curProgress, null);
            }
        }
        this.progressUpdate((int)this.curProgress, String.format("Extracted the annotations of %1$d pairs of tiers from %2$d files...", this.compareSegments.size(), selFiles.size()));
    }

    private List<AnnotationCore> getAnnotationCores(TierImpl t) {
        ArrayList<AnnotationCore> acs = new ArrayList<AnnotationCore>();
        if (t != null) {
            List<AbstractAnnotation> anns = t.getAnnotations();
            if (anns != null) {
                for (int i = 0; i < anns.size(); ++i) {
                    AnnotationCore ac = anns.get(i);
                    acs.add(new AnnotationCoreImpl(ac.getValue(), ac.getBeginTimeBoundary(), ac.getEndTimeBoundary()));
                }
                if (anns.isEmpty()) {
                    ClientLogger.LOG.warning(String.format("There are no annotations on tier \"%s\", cannot retrieve segments.", t.getName()));
                }
            } else {
                ClientLogger.LOG.warning(String.format("There are no annotations on tier \"%s\", cannot retrieve segments.", t.getName()));
            }
        } else {
            ClientLogger.LOG.warning("The tier is null, cannot retrieve segments.");
        }
        return acs;
    }

    private CompareCombi createCompareCombi(TierImpl t1, TierImpl t2) {
        if (t1 == null || t2 == null) {
            ClientLogger.LOG.warning(String.format("Cannot compare tiers: t1 is \"%s\", t2 is \"%s\".", t1 == null ? "null" : t1.getName(), t2 == null ? "null" : t2.getName()));
            return null;
        }
        List<AnnotationCore> segments1 = this.getAnnotationCores(t1);
        List<AnnotationCore> segments2 = this.getAnnotationCores(t2);
        if (segments1.isEmpty() && segments2.isEmpty()) {
            ClientLogger.LOG.warning(String.format("Cannot compare tiers \"%s\" and \"%s\", both are empty (no annotations at all).", t1.getName(), t2.getName()));
            return null;
        }
        CompareUnit cu1 = new CompareUnit(t1.getTranscription().getFullPath(), t1.getName(), t1.getAnnotator());
        cu1.annotations = segments1;
        CompareUnit cu2 = new CompareUnit(t2.getTranscription().getFullPath(), t2.getName(), t2.getAnnotator());
        cu2.annotations = segments2;
        return new CompareCombi(cu1, cu2);
    }

    private TranscriptionImpl createTranscription(File f) {
        if (f == null || f.isDirectory()) {
            return null;
        }
        try {
            return new TranscriptionImpl(f.getAbsolutePath());
        }
        catch (Throwable t) {
            ClientLogger.LOG.warning("Could not load a transcription from file: " + f.getName());
            return null;
        }
    }

    private List<TranscriptionImpl> createTranscriptions(List<File> files) {
        ArrayList<TranscriptionImpl> transList = new ArrayList<TranscriptionImpl>(files.size());
        for (File f : files) {
            TranscriptionImpl ti = this.createTranscription(f);
            if (ti == null) continue;
            transList.add(ti);
        }
        return transList;
    }

    private List<CompareCombi> getCompareCombinations(TranscriptionImpl t1, TranscriptionImpl t2, String tierName1, String tierName2) {
        CompareCombi cc;
        ArrayList<CompareCombi> combinations = new ArrayList<CompareCombi>();
        if (t1 == null || t2 == null) {
            ClientLogger.LOG.warning(String.format("Cannot compare tiers (\"%s\", \"%s\") from transcriptions: transcription 1 is \"%s\", transcription 2 is \"%s\".", tierName1, tierName2, t1 == null ? "null" : t1.getName(), t2 == null ? "null" : t2.getName()));
            return combinations;
        }
        TierImpl tier1 = null;
        TierImpl tier2 = null;
        tier1 = t1.getTierWithId(tierName1);
        tier2 = t2.getTierWithId(tierName2);
        if (tier1 != null && tier2 != null) {
            cc = this.createCompareCombi(tier1, tier2);
            if (cc != null) {
                combinations.add(cc);
            }
        } else {
            ClientLogger.LOG.info(String.format("Tier \"%s\" not in transcription \"%s\" and/or tier \"%s\" not in transcription \"%s\".", tierName1, t1.getName(), tierName2, t2.getName()));
        }
        tier1 = t1.getTierWithId(tierName2);
        tier2 = t2.getTierWithId(tierName1);
        if (tier1 != null && tier2 != null) {
            cc = this.createCompareCombi(tier1, tier2);
            if (cc != null) {
                combinations.add(cc);
            }
        } else {
            ClientLogger.LOG.info(String.format("Tier \"%s\" not in transcription \"%s\" and/or tier \"%s\" not in transcription \"%s\".", tierName1, t2.getName(), tierName2, t1.getName()));
        }
        return combinations;
    }

    protected void calculateAgreement() {
    }

    public void writeResultsAsText(File toFile, String encoding) throws IOException {
        CompareResultWriter crWriter = new CompareResultWriter();
        crWriter.writeResults(this.compareSegments, toFile, encoding);
    }

    class CompareAnnotatorsThread
    extends Thread {
        CompareAnnotatorsThread() {
        }

        @Override
        public void run() {
            AbstractCompareCommand.this.createSegments();
            if (!AbstractCompareCommand.this.errorOccurred && !AbstractCompareCommand.this.cancelled) {
                AbstractCompareCommand.this.calculateAgreement();
            }
        }
    }
}

