/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;

public class ActiveAnnotationCommand
implements Command {
    private String commandName;

    public ActiveAnnotationCommand(String theName) {
        this.commandName = theName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        ViewerManager2 vm = (ViewerManager2)receiver;
        Annotation annot = (Annotation)arguments[0];
        boolean setCrosshair = true;
        if (arguments.length > 1 && arguments[1] instanceof Boolean) {
            setCrosshair = (Boolean)arguments[1];
        }
        vm.getActiveAnnotation().setAnnotation(annot);
        Selection selection = vm.getSelection();
        long curBeg = selection.getBeginTime();
        long curEnd = selection.getEndTime();
        if (annot != null) {
            if (annot instanceof AlignableAnnotation) {
                if (curBeg != annot.getBeginTimeBoundary() || curEnd != annot.getEndTimeBoundary()) {
                    selection.setSelection(annot.getBeginTimeBoundary(), annot.getEndTimeBoundary());
                }
                if (setCrosshair && !vm.getMediaPlayerController().isBeginBoundaryActive()) {
                    vm.getMediaPlayerController().toggleActiveSelectionBoundary();
                }
            } else if (annot instanceof RefAnnotation) {
                AlignableAnnotation aa;
                Annotation parent = annot;
                while ((parent = parent.getParentAnnotation()) != null && !(parent instanceof AlignableAnnotation)) {
                }
                if (parent instanceof AlignableAnnotation && (curBeg != (aa = (AlignableAnnotation)parent).getBeginTimeBoundary() || curEnd != aa.getEndTimeBoundary())) {
                    selection.setSelection(aa.getBeginTimeBoundary(), aa.getEndTimeBoundary());
                }
            }
            if (setCrosshair) {
                ElanMediaPlayer masterMediaPlayer = vm.getMasterMediaPlayer();
                masterMediaPlayer.setMediaTime(annot.getBeginTimeBoundary());
                Boolean pref = Preferences.getBool("Media.Autoplay.ActivateAnnotation", null);
                if (pref != null && pref.booleanValue()) {
                    long startTime = selection.getBeginTime();
                    long stopTime = selection.getEndTime();
                    masterMediaPlayer.playInterval(startTime, stopTime);
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

