/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.viewer.TimeLineViewer;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;

public class ActiveAnnotationEditCommand
implements Command {
    private String name;

    public ActiveAnnotationEditCommand(String name) {
        this.name = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        ElanLayoutManager layoutManager;
        int mode;
        ViewerManager2 vm = (ViewerManager2)receiver;
        Annotation annot = (Annotation)arguments[0];
        if (annot == null) {
            return;
        }
        if (vm.getActiveAnnotation().getAnnotation() != annot) {
            vm.getActiveAnnotation().setAnnotation(annot);
        }
        if (annot instanceof AlignableAnnotation) {
            vm.getSelection().setSelection(annot.getBeginTimeBoundary(), annot.getEndTimeBoundary());
            if (!vm.getMediaPlayerController().isBeginBoundaryActive()) {
                vm.getMediaPlayerController().toggleActiveSelectionBoundary();
            }
        } else if (annot instanceof RefAnnotation) {
            Annotation parent = annot;
            while ((parent = parent.getParentAnnotation()) != null && !(parent instanceof AlignableAnnotation)) {
            }
            if (parent instanceof AlignableAnnotation) {
                AlignableAnnotation aa = (AlignableAnnotation)parent;
                vm.getSelection().setSelection(aa.getBeginTimeBoundary(), aa.getEndTimeBoundary());
            }
        }
        if ((mode = (layoutManager = ELANCommandFactory.getLayoutManager(vm.getTranscription())).getMode()) == 1) {
            if (layoutManager.getVisibleMultiTierViewer() instanceof TimeLineViewer) {
                layoutManager.getTimeLineViewer().showEditBoxForAnnotation(annot);
            } else {
                layoutManager.getInterlinearViewer().showEditBoxForAnnotation(annot);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

