/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.lexicon.LexiconLink;

public class AddLexLinkCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private LexiconLink link;

    public AddLexLinkCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        if (this.transcription != null) {
            this.transcription.removeLexiconLink(this.link);
        }
    }

    @Override
    public void redo() {
        if (this.transcription != null && this.transcription.getControlledVocabulary(this.link.getName()) == null) {
            this.transcription.addLexiconLink(this.link);
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        if (arguments[0] instanceof LexiconLink) {
            this.link = (LexiconLink)arguments[0];
            if (this.transcription.getLexiconLink(this.link.getName()) == null) {
                this.transcription.addLexiconLink(this.link);
            }
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

