/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.List;
import java.util.Locale;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class AddTierCommand
implements UndoableCommand {
    private String commandName;
    private TierImpl tier = null;
    private TranscriptionImpl transcription;

    public AddTierCommand(String theName) {
        this.commandName = theName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        String tierName = (String)arguments[0];
        TierImpl parentTier = (TierImpl)arguments[1];
        String lingType = (String)arguments[2];
        String participant = (String)arguments[3];
        String annotator = (String)arguments[4];
        Locale locale = (Locale)arguments[5];
        String langRef = (String)arguments[6];
        if (this.transcription != null) {
            this.tier = new TierImpl(parentTier, tierName, null, this.transcription, null);
            List<LinguisticType> types = this.transcription.getLinguisticTypes();
            for (LinguisticType t : types) {
                if (!t.getLinguisticTypeName().equals(lingType)) continue;
                this.tier.setLinguisticType(t);
                break;
            }
            this.tier.setParticipant(participant);
            this.tier.setAnnotator(annotator);
            this.tier.setDefaultLocale(locale);
            this.tier.setLangRef(langRef);
            if (this.transcription.getTierWithId(tierName) == null) {
                this.transcription.addTier(this.tier);
            }
        }
    }

    @Override
    public void undo() {
        if (this.tier != null) {
            this.transcription.removeTier(this.tier);
        }
    }

    @Override
    public void redo() {
        if (this.tier != null && this.transcription.getTierWithId(this.tier.getName()) == null) {
            this.transcription.addTier(this.tier);
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

