/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationsToTiersUtil;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.TimeInterval;

public class AnnotationValuesToTiersCommand
implements UndoableCommand {
    private String name;
    private TranscriptionImpl transcription;
    private String sourceTierName;
    private Map<String, List<TimeInterval>> segmentsPerTier;
    private Map<String, String> tierNameMap;
    private int maxNumTiers;
    private TierImpl sourceTier;
    private final String lingTypeName = "split-type";
    private LinguisticType splitType;

    public AnnotationValuesToTiersCommand(String name) {
        this.name = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.sourceTierName = (String)arguments[0];
        this.sourceTier = this.transcription.getTierWithId(this.sourceTierName);
        if (this.sourceTier == null) {
            ClientLogger.LOG.warning("There is no tier with that name: " + this.sourceTierName);
            return;
        }
        this.maxNumTiers = -1;
        if (arguments.length > 1) {
            this.maxNumTiers = (Integer)arguments[1];
        }
        AnnotationsToTiersUtil aToTUtil = new AnnotationsToTiersUtil();
        this.segmentsPerTier = aToTUtil.convertToTiers(this.sourceTier, "\\+");
        if (this.segmentsPerTier == null) {
            ClientLogger.LOG.warning("No new tiers have been extracted from the input tier: " + this.sourceTierName);
            return;
        }
        this.tierNameMap = new HashMap<String, String>();
        this.createTiers();
    }

    private void createTiers() {
        if (this.segmentsPerTier == null) {
            ClientLogger.LOG.warning("No tiers to create.");
        }
        int count = 0;
        LinguisticType nextType = null;
        TierImpl nextTier = null;
        Iterator<String> tierIter = this.segmentsPerTier.keySet().iterator();
        while (tierIter.hasNext()) {
            if (count == 0 && (nextType = this.createType()) == null) {
                ClientLogger.LOG.warning("Unable to create a linguistic type, cannot create new tiers.");
                break;
            }
            if (this.maxNumTiers > 0 && count >= this.maxNumTiers) {
                ClientLogger.LOG.warning("The maximum number of tiers has been reached, stopping here.");
                break;
            }
            String tierName = tierIter.next();
            List<TimeInterval> curSegments = this.segmentsPerTier.get(tierName);
            nextTier = this.createTier(tierName, nextType);
            if (nextTier == null) {
                ClientLogger.LOG.warning("Could not create a tier for: " + tierName);
                continue;
            }
            this.tierNameMap.put(nextTier.getName(), tierName);
            this.transcription.setNotifying(false);
            for (TimeInterval ti : curSegments) {
                AbstractAnnotation aa = (AbstractAnnotation)nextTier.createAnnotation(ti.getBeginTime(), ti.getEndTime());
            }
            this.transcription.setNotifying(true);
            ++count;
        }
    }

    private LinguisticType createType() {
        LinguisticType sourceType;
        if (this.sourceTier != null && (sourceType = this.sourceTier.getLinguisticType()).getConstraints() == null) {
            return sourceType;
        }
        LinguisticType lt = this.transcription.getLinguisticTypeByName("split-type");
        if (lt != null && lt.getConstraints() == null) {
            return lt;
        }
        for (int i = 0; i < 20; ++i) {
            Object id = i == 0 ? "split-type" : "split-type-" + i;
            if (this.transcription.getLinguisticTypeByName((String)id) != null) continue;
            LinguisticType nextLt = new LinguisticType((String)id);
            nextLt.setTimeAlignable(true);
            this.transcription.addLinguisticType(nextLt);
            this.splitType = nextLt;
            return nextLt;
        }
        return null;
    }

    private TierImpl createTier(String name, LinguisticType type) {
        if (this.transcription.getTierWithId(name) == null) {
            TierImpl t = new TierImpl(name, "", this.transcription, type);
            t.setLangRef(this.sourceTier.getLangRef());
            this.transcription.addTier(t);
            return t;
        }
        for (int i = 1; i < 20; ++i) {
            String id = name + "-" + i;
            if (this.transcription.getTierWithId(id) != null) continue;
            TierImpl t = new TierImpl(id, "", this.transcription, type);
            t.setLangRef(this.sourceTier.getLangRef());
            this.transcription.addTier(t);
            return t;
        }
        return null;
    }

    @Override
    public void undo() {
        if (this.transcription != null && this.tierNameMap != null) {
            for (String tierName : this.tierNameMap.keySet()) {
                TierImpl tier = this.transcription.getTierWithId(tierName);
                if (tier != null) {
                    this.transcription.removeTier(tier);
                    continue;
                }
                ClientLogger.LOG.warning("The  tier " + tierName + " does not exist and can therefore not be deleted.");
            }
            if (this.splitType != null) {
                this.transcription.removeLinguisticType(this.splitType);
            }
        }
    }

    @Override
    public void redo() {
        if (this.transcription != null && this.tierNameMap != null && this.segmentsPerTier != null) {
            LinguisticType curTypeToUse;
            if (this.splitType == null) {
                curTypeToUse = this.transcription.getLinguisticTypeByName("split-type");
            } else {
                curTypeToUse = this.splitType;
                this.transcription.addLinguisticType(this.splitType);
            }
            for (String tierName : this.tierNameMap.keySet()) {
                TierImpl tier = new TierImpl(tierName, "", this.transcription, curTypeToUse);
                tier.setLangRef(this.sourceTier.getLangRef());
                this.transcription.addTier(tier);
                List<TimeInterval> segments = this.segmentsPerTier.get(this.tierNameMap.get(tierName));
                for (TimeInterval ti : segments) {
                    tier.createAnnotation(ti.getBeginTime(), ti.getEndTime());
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

