/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.linkedmedia.LinkedFileDescriptorUtil;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ChangeLinkedFilesCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private List<MediaDescriptor> oldMediaDescriptors;
    private List<MediaDescriptor> newMediaDescriptors;
    private List<LinkedFileDescriptor> oldLinkedFileDescriptors;
    private List<LinkedFileDescriptor> newLinkedFileDescriptors;
    private boolean areMediaDesc = true;
    private boolean timeOffsetsChangedOnly = false;
    private Map<String, Long> oldDescOffsetMap;
    private Map<String, Long> newDescOffsetMap;

    public ChangeLinkedFilesCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        if (this.transcription != null && this.oldMediaDescriptors != null) {
            if (this.areMediaDesc) {
                if (!this.timeOffsetsChangedOnly) {
                    this.updateMediaPlayers(this.transcription, this.oldMediaDescriptors);
                } else {
                    this.updateMediaPlayersOffset(this.transcription, this.oldDescOffsetMap);
                }
            } else if (!this.timeOffsetsChangedOnly) {
                this.updateLinkedFiles(this.transcription, this.oldLinkedFileDescriptors);
            } else {
                this.updateLinkedFilesOffset(this.transcription, this.oldDescOffsetMap);
            }
        }
    }

    @Override
    public void redo() {
        if (this.transcription != null && this.newMediaDescriptors != null) {
            if (this.areMediaDesc) {
                if (!this.timeOffsetsChangedOnly) {
                    this.updateMediaPlayers(this.transcription, this.newMediaDescriptors);
                } else {
                    this.updateMediaPlayersOffset(this.transcription, this.newDescOffsetMap);
                }
            } else if (!this.timeOffsetsChangedOnly) {
                this.updateLinkedFiles(this.transcription, this.newLinkedFileDescriptors);
            } else {
                this.updateLinkedFilesOffset(this.transcription, this.newDescOffsetMap);
            }
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        if (arguments != null && arguments.length >= 1) {
            if (arguments.length > 1) {
                this.areMediaDesc = (Boolean)arguments[1];
            }
            if (arguments.length > 2) {
                this.timeOffsetsChangedOnly = (Boolean)arguments[2];
            }
            if (this.areMediaDesc) {
                this.newMediaDescriptors = (List)arguments[0];
            } else {
                this.newLinkedFileDescriptors = (List)arguments[0];
            }
        }
        if (this.transcription != null) {
            if (this.areMediaDesc) {
                this.oldMediaDescriptors = this.transcription.getMediaDescriptors();
                if (!this.timeOffsetsChangedOnly) {
                    this.updateMediaPlayers(this.transcription, this.newMediaDescriptors);
                    ElanFrame2 ef2 = (ElanFrame2)ELANCommandFactory.getRootFrame(this.transcription);
                    if (ef2 != null) {
                        ElanMediaPlayer master = ELANCommandFactory.getViewerManager(this.transcription).getMasterMediaPlayer();
                        ef2.setMenuEnabled(740, !master.isFrameRateAutoDetected());
                        ef2.updateMenu(610);
                        ef2.updateMenu(630);
                    }
                } else {
                    MediaDescriptor md;
                    int i;
                    this.oldDescOffsetMap = new HashMap<String, Long>(this.oldMediaDescriptors.size());
                    this.newDescOffsetMap = new HashMap<String, Long>(this.newMediaDescriptors.size());
                    for (i = 0; i < this.oldMediaDescriptors.size(); ++i) {
                        md = this.oldMediaDescriptors.get(i);
                        this.oldDescOffsetMap.put(md.mediaURL, md.timeOrigin);
                    }
                    for (i = 0; i < this.newMediaDescriptors.size(); ++i) {
                        md = this.newMediaDescriptors.get(i);
                        this.newDescOffsetMap.put(md.mediaURL, md.timeOrigin);
                    }
                    this.updateMediaPlayersOffset(this.transcription, this.newDescOffsetMap);
                }
            } else {
                this.oldLinkedFileDescriptors = this.transcription.getLinkedFileDescriptors();
                if (!this.timeOffsetsChangedOnly) {
                    this.updateLinkedFiles(this.transcription, this.newLinkedFileDescriptors);
                } else {
                    LinkedFileDescriptor lfd;
                    int i;
                    this.oldDescOffsetMap = new HashMap<String, Long>(this.oldLinkedFileDescriptors.size());
                    this.newDescOffsetMap = new HashMap<String, Long>(this.newLinkedFileDescriptors.size());
                    for (i = 0; i < this.oldLinkedFileDescriptors.size(); ++i) {
                        lfd = this.oldLinkedFileDescriptors.get(i);
                        this.oldDescOffsetMap.put(lfd.linkURL, lfd.timeOrigin);
                    }
                    for (i = 0; i < this.newLinkedFileDescriptors.size(); ++i) {
                        lfd = this.newLinkedFileDescriptors.get(i);
                        this.newDescOffsetMap.put(lfd.linkURL, lfd.timeOrigin);
                    }
                    this.updateLinkedFilesOffset(this.transcription, this.newDescOffsetMap);
                }
            }
        }
    }

    private void updateMediaPlayers(TranscriptionImpl transcription, List<MediaDescriptor> descriptors) {
        if (transcription == null || descriptors == null) {
            return;
        }
        MediaDescriptorUtil.updateMediaPlayers(transcription, descriptors);
    }

    private void updateMediaPlayersOffset(TranscriptionImpl transcription, Map<String, Long> newMediaOffsets) {
        if (transcription == null || newMediaOffsets == null) {
            return;
        }
        MediaDescriptorUtil.updateMediaPlayerOffsets(transcription, newMediaOffsets);
    }

    private void updateLinkedFiles(TranscriptionImpl transcription, List<LinkedFileDescriptor> descriptors) {
        if (transcription == null || descriptors == null) {
            return;
        }
        LinkedFileDescriptorUtil.updateLinkedFiles(transcription, descriptors);
    }

    private void updateLinkedFilesOffset(TranscriptionImpl transcription, Map<String, Long> newLinkOffsets) {
        if (transcription == null || newLinkOffsets == null) {
            return;
        }
        LinkedFileDescriptorUtil.updateLinkedFilesOffsets(transcription, newLinkOffsets);
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

