/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;

public class ChangeTypeCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private String oldTypeName;
    private Constraint oldConstraint;
    private String oldCVName;
    private boolean oldTimeAlignable;
    private String oldDcId;
    private LexiconQueryBundle2 oldQueryBundle;
    private String typeName;
    private Constraint constraint;
    private String cvName;
    private boolean timeAlignable;
    private String dcId;
    private LexiconQueryBundle2 queryBundle;
    private LinguisticType linType;

    public ChangeTypeCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        if (this.linType != null) {
            ArrayList<Constraint> constraints = new ArrayList<Constraint>();
            constraints.add(this.oldConstraint);
            this.transcription.changeLinguisticType(this.linType, this.oldTypeName, constraints, this.oldCVName, this.oldTimeAlignable, this.oldDcId, this.oldQueryBundle);
        }
    }

    @Override
    public void redo() {
        if (this.linType != null) {
            ArrayList<Constraint> constraints = new ArrayList<Constraint>();
            constraints.add(this.constraint);
            this.transcription.changeLinguisticType(this.linType, this.typeName, constraints, this.cvName, this.timeAlignable, this.dcId, this.queryBundle);
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.typeName = (String)arguments[0];
        this.constraint = (Constraint)arguments[1];
        this.cvName = (String)arguments[2];
        this.timeAlignable = (Boolean)arguments[3];
        this.linType = (LinguisticType)arguments[5];
        if (arguments.length >= 7) {
            this.dcId = (String)arguments[6];
        }
        if (arguments.length >= 8) {
            this.queryBundle = (LexiconQueryBundle2)arguments[7];
        }
        this.oldTypeName = this.linType.getLinguisticTypeName();
        this.oldConstraint = this.linType.getConstraints();
        this.oldCVName = this.linType.getControlledVocabularyName();
        this.oldTimeAlignable = this.linType.isTimeAlignable();
        this.oldDcId = this.linType.getDataCategory();
        this.oldQueryBundle = this.linType.getLexiconQueryBundle();
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        constraints.add(this.constraint);
        this.transcription.changeLinguisticType(this.linType, this.typeName, constraints, this.cvName, this.timeAlignable, this.dcId, this.queryBundle);
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

