/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.util.TimeFormatter;

public class ClipMediaCommand
implements Command {
    public static final String IN_FILE = "$in_file";
    public static final String OUT_FILE = "$out_file";
    public static final String BEGIN_TIME = "$begin";
    public static final String END_TIME = "$end";
    public static final String DUR = "$duration";
    public static final String HH = "hour:min:sec.ms";
    public static final String HHFF = "hour:min:sec:fr";
    public static final String HHFF_NTSC = "hour:min:sec:fr_NTSC";
    public static final String SEC = "sec.ms";
    public static final String MS = "ms";
    public static final String FR = "fr";
    public static final String FR_NTSC = "fr_NTSC";
    static final String[] FORMATS = new String[]{"sec.ms", "ms", "hour:min:sec.ms", "fr", "hour:min:sec:fr", "hour:min:sec:fr_NTSC", "fr_NTSC"};
    private String commandName;
    boolean asynchronous = false;
    boolean unattendedMode = false;
    protected ProcessReport report;

    public ClipMediaCommand(String theName) {
        this.commandName = theName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        block41: {
            String executable = null;
            String command = "";
            long timeBegin = -1L;
            long timeEnd = -1L;
            String sourceFileName = null;
            String mainDestFile = null;
            Object outFilePath = null;
            if (arguments.length > 0 && arguments[arguments.length - 1] instanceof Boolean) {
                this.unattendedMode = (Boolean)arguments[arguments.length - 1];
            }
            if (arguments[0] instanceof ViewerManager2) {
                ViewerManager2 viewerManager = (ViewerManager2)arguments[0];
                if (arguments.length > 1 && arguments[1] instanceof Exception) {
                    if (this.unattendedMode) {
                        ClientLogger.LOG.warning(ElanLocale.getString("ClipMedia.Error.Message") + " " + ((Exception)arguments[1]).getMessage());
                    } else {
                        this.showErrorMessage(ELANCommandFactory.getRootFrame(viewerManager.getTranscription()), ((Exception)arguments[1]).getMessage());
                    }
                    return;
                }
                if (arguments.length > 1) {
                    Boolean runAsync;
                    Selection selection;
                    executable = (String)arguments[1];
                    if (arguments.length <= 2) {
                        if (this.unattendedMode) {
                            ClientLogger.LOG.warning(ElanLocale.getString("ClipMedia.Error.Message") + " " + ElanLocale.getString("ClipMedia.Error.Message.NoParameters"));
                        } else {
                            this.showErrorMessage(ELANCommandFactory.getRootFrame(viewerManager.getTranscription()), ElanLocale.getString("ClipMedia.Error.Message") + " " + ElanLocale.getString("ClipMedia.Error.Message.NoParameters"));
                        }
                        return;
                    }
                    command = (String)arguments[2];
                    int argIndex = 3;
                    if (arguments.length > argIndex && arguments[argIndex] instanceof String) {
                        outFilePath = (String)arguments[argIndex];
                        ++argIndex;
                        if (outFilePath != null && !((String)(outFilePath = File.separatorChar == '/' ? ((String)outFilePath).replace('\\', File.separatorChar) : ((String)outFilePath).replace('/', File.separatorChar))).endsWith(File.separator)) {
                            outFilePath = (String)outFilePath + File.separator;
                        }
                    }
                    if (arguments.length > argIndex && arguments[argIndex] instanceof Long) {
                        timeBegin = (Long)arguments[argIndex];
                        ++argIndex;
                    }
                    if (arguments.length > argIndex && arguments[argIndex] instanceof Long) {
                        timeEnd = (Long)arguments[argIndex];
                    }
                    if ((selection = viewerManager.getSelection()) != null && timeBegin == -1L) {
                        timeBegin = selection.getBeginTime();
                        timeEnd = selection.getEndTime();
                        boolean promptForFile = true;
                        Boolean promptObj = Preferences.getBool("Media.PromptForFilename", viewerManager.getTranscription());
                        if (promptObj != null) {
                            promptForFile = promptObj;
                        }
                        if (promptForFile && outFilePath == null) {
                            FileChooser chooser = new FileChooser(ELANCommandFactory.getRootFrame(viewerManager.getTranscription()));
                            chooser.createAndShowFileDialog(null, 1, null, "MediaClipDir");
                            File selFile = chooser.getSelectedFile();
                            if (selFile != null) {
                                mainDestFile = selFile.toString();
                            } else {
                                return;
                            }
                        }
                    }
                    boolean masterMediaOnly = false;
                    Boolean mmOnlyObj = Preferences.getBool("Media.OnlyClipFirstMediaFile", viewerManager.getTranscription());
                    if (mmOnlyObj != null) {
                        masterMediaOnly = mmOnlyObj;
                    }
                    if ((runAsync = Preferences.getBool("Media.ClipInParallel", viewerManager.getTranscription())) != null) {
                        this.asynchronous = runAsync;
                    }
                    List<MediaDescriptor> players = viewerManager.getTranscription().getMediaDescriptors();
                    int numPl = players.size();
                    ArrayList<MediaClipper> clipThreads = new ArrayList<MediaClipper>(numPl);
                    for (int i = 0; !(i >= numPl || i > 0 && masterMediaOnly); ++i) {
                        MediaDescriptor md = players.get(i);
                        sourceFileName = this.processSourceFileName(md.mediaURL);
                        long offset = md.timeOrigin;
                        Object destFileName = null;
                        if (outFilePath != null) {
                            String fileName = FileUtility.fileNameFromPath(sourceFileName);
                            if (fileName != null) {
                                destFileName = (String)outFilePath + fileName;
                            }
                        } else {
                            destFileName = sourceFileName;
                        }
                        destFileName = mainDestFile != null ? this.createDestinationName(mainDestFile, i, sourceFileName) : this.createDestinationName((String)destFileName, timeBegin + offset, timeEnd + offset);
                        List<String> defCommand = this.processCommand(command, sourceFileName, (String)destFileName, timeBegin + offset, timeEnd + offset);
                        defCommand.add(0, executable);
                        clipThreads.add(new MediaClipper(defCommand));
                    }
                    ClipRunner cRun = new ClipRunner(clipThreads);
                    cRun.start();
                    try {
                        cRun.join();
                        if (cRun.getErrorMessage() == null) break block41;
                        if (this.unattendedMode) {
                            ClientLogger.LOG.warning(cRun.getErrorMessage() + "(" + cRun.numErrors + ")");
                            break block41;
                        }
                        this.showErrorMessage(ELANCommandFactory.getRootFrame(viewerManager.getTranscription()), cRun.getErrorMessage() + "(" + cRun.numErrors + ")");
                    }
                    catch (InterruptedException ie) {
                        ClientLogger.LOG.warning(ElanLocale.getString("Message.Error") + ": " + ie.getMessage());
                    }
                }
            } else if (arguments[0] instanceof String) {
                sourceFileName = (String)arguments[0];
                long offset = 0L;
                if (arguments.length > 1 && arguments[1] instanceof Exception) {
                    if (this.unattendedMode) {
                        ClientLogger.LOG.warning(ElanLocale.getString("ClipMedia.Error.Message") + " " + ((Exception)arguments[1]).getMessage());
                    } else {
                        this.showErrorMessage(null, ElanLocale.getString("ClipMedia.Error.Message") + " " + ((Exception)arguments[1]).getMessage());
                    }
                    return;
                }
                if (arguments.length > 1) {
                    executable = (String)arguments[1];
                    if (arguments.length <= 2) {
                        if (this.unattendedMode) {
                            ClientLogger.LOG.warning(ElanLocale.getString("ClipMedia.Error.Message") + " " + ElanLocale.getString("ClipMedia.Error.Message.NoParameters"));
                        } else {
                            this.showErrorMessage(null, ElanLocale.getString("ClipMedia.Error.Message") + " " + ElanLocale.getString("ClipMedia.Error.Message.NoParameters"));
                        }
                        return;
                    }
                    command = (String)arguments[2];
                    if (arguments.length > 3 && arguments[3] instanceof Long) {
                        timeBegin = (Long)arguments[3];
                    }
                    if (arguments.length > 4 && arguments[4] instanceof Long) {
                        timeEnd = (Long)arguments[4];
                    }
                    if (arguments.length > 5 && arguments[5] instanceof Long) {
                        offset = (Long)arguments[5];
                    }
                    if (sourceFileName.startsWith("file:")) {
                        sourceFileName = sourceFileName.substring(5);
                    }
                    if (sourceFileName.startsWith("///")) {
                        sourceFileName = sourceFileName.substring(3);
                    }
                    sourceFileName = File.separatorChar == '/' ? sourceFileName.replace('\\', File.separatorChar) : sourceFileName.replace('/', File.separatorChar);
                    String destFileName = this.createDestinationName(sourceFileName, timeBegin + offset, timeEnd + offset);
                    List<String> defCommand = this.processCommand(command, sourceFileName, destFileName, timeBegin + offset, timeEnd + offset);
                    defCommand.add(0, executable);
                    new MediaClipper(defCommand).start();
                }
            }
        }
    }

    List<String> processCommand(String command, String inFile, String outFile, long timeBegin, long timeEnd) {
        int i;
        if (inFile == null || outFile == null) {
            return null;
        }
        Pattern pat = Pattern.compile(" ");
        String[] parts = pat.split(command);
        ArrayList<String> partList = new ArrayList<String>(parts.length);
        for (String s : parts) {
            partList.add(s);
        }
        int from = 0;
        int to = 0;
        for (i = 0; i < partList.size(); ++i) {
            String replSub;
            String sub = (String)partList.get(i);
            if (sub.length() == 0) continue;
            if (sub.indexOf(BEGIN_TIME) > -1) {
                partList.set(i, this.replaceTime(sub, BEGIN_TIME, timeBegin));
                continue;
            }
            if (sub.indexOf(END_TIME) > -1) {
                partList.set(i, this.replaceTime(sub, END_TIME, timeEnd));
                continue;
            }
            if (sub.indexOf(DUR) > -1) {
                partList.set(i, this.replaceTime(sub, DUR, timeEnd - timeBegin));
                continue;
            }
            from = sub.indexOf(IN_FILE);
            if (from > -1) {
                to = from + IN_FILE.length();
                replSub = sub.substring(0, from) + inFile + sub.substring(to);
                partList.set(i, replSub);
                continue;
            }
            from = sub.indexOf(OUT_FILE);
            if (from <= -1) continue;
            to = from + OUT_FILE.length();
            replSub = sub.substring(0, from) + outFile + sub.substring(to);
            partList.set(i, replSub);
        }
        for (i = partList.size() - 1; i >= 0; --i) {
            String sub = (String)partList.get(i);
            if (sub != null && sub.length() != 0) continue;
            partList.remove(i);
        }
        return partList;
    }

    private String replaceTime(String part, String key, long time) {
        int from = part.indexOf(key);
        int from2 = part.indexOf("(", from) + 1;
        int to = part.indexOf(")", from2);
        String format = part.substring(from2, to);
        for (String f : FORMATS) {
            if (!format.equals(f)) continue;
            String repl = part.substring(0, from) + this.toTimeString(f, time);
            if (to + 1 < part.length()) {
                repl = repl + part.substring(to + 1);
            }
            return repl;
        }
        return "";
    }

    private String toTimeString(String format, long time) {
        if (format == SEC) {
            return TimeFormatter.toSSMSString(time);
        }
        if (format == MS) {
            return String.valueOf(time);
        }
        if (format == HH) {
            return TimeFormatter.toString(time);
        }
        if (format == HHFF) {
            return TimeFormatter.toTimecodePAL(time);
        }
        if (format == HHFF_NTSC) {
            return TimeFormatter.toTimecodeNTSC(time);
        }
        if (format == FR) {
            return TimeFormatter.toFrameNumberPAL(time);
        }
        if (format == FR_NTSC) {
            return TimeFormatter.toFrameNumberNTSC(time);
        }
        return String.valueOf(time);
    }

    String processSourceFileName(String sourceUrl) {
        String sourceFileName = sourceUrl.substring(5);
        if (sourceFileName.startsWith("///") && SystemReporting.isWindows()) {
            sourceFileName = sourceFileName.substring(3);
        }
        sourceFileName = File.separatorChar == '/' ? sourceFileName.replace('\\', File.separatorChar) : sourceFileName.replace('/', File.separatorChar);
        return sourceFileName;
    }

    public String createDestinationName(String sourceFileName, long begin, long end) {
        int si = sourceFileName.lastIndexOf(".");
        if (si > -1) {
            return sourceFileName.substring(0, si) + "_" + begin + "_" + end + sourceFileName.substring(si);
        }
        return sourceFileName + "_" + begin + "_" + end;
    }

    public String createDestinationName(String mainDestFile, int i, String sourceName) {
        int stopIndex = mainDestFile.lastIndexOf(46);
        if (stopIndex > -1) {
            if (i > 0) {
                return mainDestFile.substring(0, stopIndex) + "_" + i + mainDestFile.substring(stopIndex);
            }
        } else {
            int sourceStop;
            if (sourceName != null && (sourceStop = sourceName.lastIndexOf(46)) > -1 && sourceStop < sourceName.length() - 1) {
                if (i > 0) {
                    return mainDestFile + "_" + i + sourceName.substring(sourceStop);
                }
                return mainDestFile + sourceName.substring(sourceStop);
            }
            if (i > 0) {
                return mainDestFile + "_" + i;
            }
        }
        return mainDestFile;
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void showErrorMessage(Frame frame, String message) {
        JOptionPane.showMessageDialog(frame, message, ElanLocale.getString("Message.Warning"), 2);
    }

    class ClipRunner
    extends Thread {
        List<MediaClipper> clips;
        String errorMessage = null;
        int numErrors = 0;

        public ClipRunner(List<MediaClipper> clips) {
            this.clips = clips;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public int getnumErrors() {
            return this.numErrors;
        }

        @Override
        public void run() {
            if (this.clips != null && this.clips.size() != 0) {
                for (MediaClipper mc : this.clips) {
                    mc.start();
                    while (mc.isAlive()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (mc.getErrorMessage() == null) continue;
                    ++this.numErrors;
                    if (this.errorMessage != null) continue;
                    this.errorMessage = mc.getErrorMessage();
                }
            }
        }
    }

    class ReaderThread
    extends Thread {
        private BufferedReader reader;
        private long startTime;
        private final int MAX_READ_TIME = 120000;

        ReaderThread(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public void run() {
            this.startTime = System.currentTimeMillis();
            while (this.reader != null && !this.isInterrupted()) {
                try {
                    if (this.reader.ready()) {
                        String line = this.reader.readLine();
                        ClientLogger.LOG.info(line);
                        if (ClipMediaCommand.this.report != null) {
                            ClipMediaCommand.this.report.append(line);
                        }
                    } else if (System.currentTimeMillis() - this.startTime > 120000L) {
                        break;
                    }
                }
                catch (IOException line) {
                    // empty catch block
                }
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                    break;
                }
            }
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class MediaClipper
    extends Thread {
        private List<String> command;
        private BufferedReader reader;
        private String errorMessage = null;

        public MediaClipper(List<String> command) {
            this.command = command;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public void run() {
            block10: {
                if (this.command == null) {
                    return;
                }
                try {
                    ProcessBuilder pb = new ProcessBuilder(this.command);
                    pb.redirectErrorStream(true);
                    Process process = pb.start();
                    long startTime = System.currentTimeMillis();
                    this.reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    ReaderThread rt = new ReaderThread(this.reader);
                    rt.start();
                    if (ClipMediaCommand.this.asynchronous) break block10;
                    try {
                        int exit = process.waitFor();
                        if (System.currentTimeMillis() - startTime < 2000L) {
                            while (System.currentTimeMillis() - startTime < 5000L) {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException ie) {
                                }
                            }
                        }
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
                catch (IOException ioe) {
                    this.errorMessage = ElanLocale.getString("ClipMedia.Error.Message") + " " + ioe.getMessage();
                    ClientLogger.LOG.warning(this.errorMessage);
                }
                catch (SecurityException se) {
                    this.errorMessage = ElanLocale.getString("ClipMedia.Error.Message.Security") + " " + se.getMessage();
                    ClientLogger.LOG.warning(this.errorMessage);
                }
            }
        }
    }
}

