/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.ClipMediaCommand;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.util.ProcessReport;

public class ClipMediaMultiCommand
extends ClipMediaCommand {
    public ClipMediaMultiCommand(String theName) {
        super(theName);
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        Boolean runAsync;
        List arg2;
        TranscriptionImpl transcription = (TranscriptionImpl)receiver;
        if (arguments.length >= 5) {
            this.report = (ProcessReport)arguments[4];
        }
        if (transcription.getMediaDescriptors().size() == 0) {
            ClientLogger.LOG.warning("No media descriptors in the transcription, nothing to clip");
            if (this.report != null) {
                this.report.append("No media descriptors in the transcription, nothing to clip");
            }
            return;
        }
        String executable = (String)arguments[0];
        if (executable == null) {
            return;
        }
        String command = (String)arguments[1];
        if (command == null) {
            return;
        }
        List<long[]> segmentList = null;
        if (arguments[2] instanceof List && (arg2 = (List)arguments[2]).size() > 0) {
            Object first = arg2.get(0);
            if (first instanceof long[]) {
                segmentList = arg2;
            } else if (first instanceof String) {
                segmentList = this.extractSegments(transcription, arg2);
            }
        }
        if (segmentList == null || segmentList.size() == 0) {
            return;
        }
        String outputFolder = (String)arguments[3];
        this.unattendedMode = true;
        boolean masterMediaOnly = false;
        Boolean mmOnlyObj = Preferences.getBool("Media.OnlyClipFirstMediaFile", transcription);
        if (mmOnlyObj != null) {
            masterMediaOnly = mmOnlyObj;
        }
        if ((runAsync = Preferences.getBool("Media.ClipInParallel", transcription)) != null) {
            this.asynchronous = runAsync;
        }
        HashMap<String, Long> medMap = new HashMap<String, Long>(transcription.getMediaDescriptors().size());
        for (int i = 0; !(i >= transcription.getMediaDescriptors().size() || i > 0 && masterMediaOnly); ++i) {
            MediaDescriptor md = transcription.getMediaDescriptors().get(i);
            String string = this.processSourceFileName(md.mediaURL);
            medMap.put(string, md.timeOrigin);
        }
        ArrayList<ClipMediaCommand.MediaClipper> clippingList = new ArrayList<ClipMediaCommand.MediaClipper>();
        for (Map.Entry entry : medMap.entrySet()) {
            String mediaSource = (String)entry.getKey();
            long offset = (Long)entry.getValue();
            if (this.report != null) {
                this.report.append("Clipping " + segmentList.size() + " segments from " + mediaSource);
            }
            String rawOutputName = outputFolder + File.separator + FileUtility.fileNameFromPath(mediaSource);
            for (int i = 0; i < segmentList.size(); ++i) {
                long[] segment = segmentList.get(i);
                String completeOutputName = this.createDestinationName(rawOutputName, segment[0] + offset, segment[1] + offset);
                List<String> defCommand = this.processCommand(command, mediaSource, completeOutputName, segment[0] + offset, segment[1] + offset);
                defCommand.add(0, executable);
                clippingList.add(new ClipMediaCommand.MediaClipper(this, defCommand));
            }
        }
        ClipMediaCommand.ClipRunner cRun = new ClipMediaCommand.ClipRunner(this, clippingList);
        cRun.start();
        try {
            cRun.join();
            if (cRun.getErrorMessage() != null) {
                if (this.unattendedMode) {
                    ClientLogger.LOG.warning(cRun.getErrorMessage() + "(" + cRun.numErrors + ")");
                }
                if (this.report != null) {
                    this.report.append("Errors occurred: " + cRun.getErrorMessage() + "(" + cRun.numErrors + ")");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            ClientLogger.LOG.warning(ElanLocale.getString("Message.Error") + ": " + interruptedException.getMessage());
        }
    }

    private List<long[]> extractSegments(TranscriptionImpl transcription, List<String> tierNames) {
        if (transcription != null && tierNames != null && tierNames.size() > 0) {
            ArrayList<long[]> segments = new ArrayList<long[]>();
            for (String name : tierNames) {
                TierImpl t = transcription.getTierWithId(name);
                if (t == null) continue;
                List<AbstractAnnotation> annotations = t.getAnnotations();
                int size = annotations.size();
                for (int i = 0; i < size; ++i) {
                    Annotation a = annotations.get(i);
                    segments.add(new long[]{a.getBeginTimeBoundary(), a.getEndTimeBoundary()});
                }
            }
            return segments;
        }
        return null;
    }
}

