/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import nl.mpi.jsound.WaveClipper;

public class ClipWaveCommand
implements Command {
    private String name;
    private Transcription transcription;

    public ClipWaveCommand(String name) {
        this.name = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        String outputPath;
        this.transcription = (Transcription)receiver;
        Object sourceObj = arguments[0];
        Long beginTime = (Long)arguments[1];
        Long endTime = (Long)arguments[2];
        String sourcePath = null;
        if (sourceObj instanceof String) {
            sourcePath = (String)sourceObj;
        } else if (sourceObj instanceof MediaDescriptor) {
            sourcePath = ((MediaDescriptor)sourceObj).mediaURL;
        }
        if (sourcePath == null) {
            return;
        }
        if (sourcePath.startsWith("file:")) {
            sourcePath = sourcePath.substring(5);
        }
        if ((outputPath = this.getOutputFile(sourcePath, beginTime, endTime)) == null) {
            return;
        }
        this.clipFile(sourcePath, outputPath, beginTime, endTime);
    }

    private String getOutputFile(String sourcePath, long begin, long end) {
        boolean promptForFile = true;
        Boolean promptObj = Preferences.getBool("Media.PromptForFilename", this.transcription);
        if (promptObj != null) {
            promptForFile = promptObj;
        }
        if (promptForFile) {
            FileChooser chooser = new FileChooser(ELANCommandFactory.getRootFrame(this.transcription));
            chooser.createAndShowFileDialog(null, 1, null, "MediaClipDir");
            File selFile = chooser.getSelectedFile();
            if (selFile != null) {
                return selFile.toString();
            }
            return null;
        }
        int si = sourcePath.lastIndexOf(".");
        if (si > -1) {
            return sourcePath.substring(0, si) + "_" + begin + "_" + end + sourcePath.substring(si);
        }
        return sourcePath + "_" + begin + "_" + end;
    }

    private void clipFile(String inputFile, String outputFile, long beginTime, long endTime) {
        WaveClipper clipper = new WaveClipper();
        try {
            boolean clipSuccess = clipper.exportClip(inputFile, outputFile, beginTime * 1000L, endTime * 1000L);
            if (clipSuccess) {
                this.showMessage(String.format(ElanLocale.getString("ClipMedia.Message.Saved"), outputFile), 1);
            } else {
                this.showMessage(ElanLocale.getString("ClipMedia.Error.Message.Unknown"), 0);
            }
        }
        catch (IOException ioe) {
            this.showMessage(ElanLocale.getString("ClipMedia.Error.Message.IOError"), 0);
        }
        catch (UnsupportedAudioFileException uafe) {
            this.showMessage(ElanLocale.getString("ClipMedia.Error.Message.NotSupported"), 0);
        }
        catch (Throwable t) {
            this.showMessage("An unknown error occured while creating the audio clip", 0);
        }
    }

    private void showMessage(String message, int type) {
        JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.transcription), message, "", type);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

