/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import mpi.eudico.client.annotator.commands.AbstractCompareCommand;
import mpi.eudico.client.annotator.interannotator.CompareCombi;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.AnnotationCore;
import staccato.data.StaccatoData;
import staccato.data.StaccatoNomination;
import staccato.model.StaccatoAnalyzer;
import staccato.model.StaccatoListener;

public class CompareAnnotationStaccatoCommand
extends AbstractCompareCommand {
    private int monteCarloIterations = 1000;
    private int nominationsGranularity = 10;
    private double nullHypothesis = 0.05;
    private Map<CompareCombi, StaccatoData> resultMap;

    public CompareAnnotationStaccatoCommand(String theName) {
        super(theName);
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.resultMap = new HashMap<CompareCombi, StaccatoData>();
        super.execute(receiver, arguments);
    }

    @Override
    protected void calculateAgreement() {
        if (this.compareSegments.size() == 0) {
            this.logErrorAndInterrupt("There are no tier pairs, nothing to calculate.");
            return;
        }
        Object userObj = this.compareProperties.get("Compare.MonteCarloSimulations");
        if (userObj instanceof Integer) {
            this.monteCarloIterations = (Integer)userObj;
            if (this.monteCarloIterations < 10) {
                this.monteCarloIterations = 10;
            } else if (this.monteCarloIterations > 25000) {
                this.monteCarloIterations = 25000;
            }
        }
        if ((userObj = this.compareProperties.get("Compare.NumberOfNominations")) instanceof Integer) {
            this.nominationsGranularity = (Integer)userObj;
            if (this.nominationsGranularity < 5) {
                this.nominationsGranularity = 5;
            } else if (this.nominationsGranularity > 100) {
                this.nominationsGranularity = 100;
            }
        }
        if ((userObj = this.compareProperties.get("Compare.NullHypothesis.Value")) instanceof Double) {
            this.nullHypothesis = (Double)userObj;
            if (this.nullHypothesis < 0.01) {
                this.nullHypothesis = 0.01;
            } else if (this.nullHypothesis > 1.0) {
                this.nullHypothesis = 1.0;
            }
        }
        int combiCount = 0;
        float perCombi = 50.0f / (float)this.compareSegments.size();
        this.progressUpdate((int)this.curProgress, "Calculating the degree of organization per tier pair...");
        for (CompareCombi cc : this.compareSegments) {
            StaccatoData sd = this.createStaccatoData(cc);
            this.resultMap.put(cc, sd);
            if (sd != null) {
                cc.setOverallAgreement(sd.getOg());
            }
            ++combiCount;
            this.curProgress += perCombi;
            this.progressUpdate((int)this.curProgress, null);
        }
        this.progressComplete(String.format("Completed calculations of %d pairs of tiers.", combiCount));
    }

    private StaccatoData createStaccatoData(CompareCombi cc) {
        StaccatoNomination sn;
        if (cc == null) {
            return null;
        }
        int idx = 0;
        long minT = Long.MAX_VALUE;
        long maxT = 0L;
        Vector<StaccatoNomination> inputNominations = new Vector<StaccatoNomination>();
        for (AnnotationCore ac : cc.getFirstUnit().annotations) {
            sn = new StaccatoNomination((int)ac.getBeginTimeBoundary(), (int)ac.getEndTimeBoundary(), idx++, ac.getValue(), cc.getFirstUnit().annotator);
            inputNominations.add(sn);
            if (ac.getBeginTimeBoundary() < minT) {
                minT = ac.getBeginTimeBoundary();
            }
            if (ac.getEndTimeBoundary() <= maxT) continue;
            maxT = ac.getEndTimeBoundary();
        }
        for (AnnotationCore ac : cc.getSecondUnit().annotations) {
            sn = new StaccatoNomination((int)ac.getBeginTimeBoundary(), (int)ac.getEndTimeBoundary(), idx++, ac.getValue(), cc.getSecondUnit().annotator);
            inputNominations.add(sn);
            if (ac.getBeginTimeBoundary() < minT) {
                minT = ac.getBeginTimeBoundary();
            }
            if (ac.getEndTimeBoundary() <= maxT) continue;
            maxT = ac.getEndTimeBoundary();
        }
        StaccatoData stacdata = new StaccatoData();
        stacdata.setMci(this.monteCarloIterations);
        stacdata.setNomL(this.nominationsGranularity);
        stacdata.setAlpha(this.nullHypothesis);
        stacdata.setMatL((int)maxT);
        stacdata.setNominations(inputNominations);
        StaccatoAnalyzer analyzer = new StaccatoAnalyzer();
        StacProcListener spListener = new StacProcListener();
        analyzer.initNominations(inputNominations);
        analyzer.process((StaccatoListener)spListener, stacdata);
        try {
            analyzer.join();
        }
        catch (InterruptedException ie) {
            ClientLogger.LOG.severe("The processing of a pair of tiers failed: " + ie.getMessage());
            return null;
        }
        if (spListener.lastEvent == 101) {
            return analyzer.getResult();
        }
        return null;
    }

    @Override
    public void writeResultsAsText(File toFile, String encoding) throws IOException {
        if (this.compareSegments == null) {
            throw new NullPointerException("There are no results to save.");
        }
        if (toFile == null) {
            throw new IOException("There is no file location specified.");
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        BufferedWriter writer = null;
        try {
            FileOutputStream out = new FileOutputStream(toFile);
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)out, encoding);
            }
            catch (UnsupportedCharsetException uce) {
                osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            }
            writer = new BufferedWriter(osw);
            String NL = "\n";
            String NL2 = "\n\n";
            DecimalFormat decFormat = new DecimalFormat("#0.0000", new DecimalFormatSymbols(Locale.US));
            writer.write(String.format("Output created: %tD %<tT", Calendar.getInstance()));
            writer.write("\n\n");
            writer.write("The Degree of Organization (DO) value as calculated by the Staccato software");
            writer.write("\n");
            writer.write("which is based on the Thomann algorithm.");
            writer.write("The DO is calculated with two tiers as input.");
            writer.write("\n\n");
            writer.write("Number of pairs of tiers in the comparison: " + this.compareSegments.size());
            writer.write("\n");
            writer.write("Settings for computation:");
            writer.write("\n");
            writer.write("\tNumber of Monte Carlo Simulations:\t" + this.monteCarloIterations);
            writer.write("\n");
            writer.write("\tNumber of Nomination slots:\t" + this.nominationsGranularity);
            writer.write("\n");
            writer.write("\tNull Hypothesis:\t" + this.nullHypothesis);
            writer.write("\n\n");
            writer.write("Per tier combination output follows:");
            writer.write("\n");
            writer.write("==========");
            writer.write("\n\n");
            int totalCount = 0;
            double totalAgr = 0.0;
            for (CompareCombi cc : this.compareSegments) {
                writer.write("File 1: " + cc.getFirstUnit().fileName + " Tier 1: " + cc.getFirstUnit().tierName);
                writer.write("\n");
                writer.write("Number of annotations 1: " + cc.getFirstUnit().annotations.size());
                writer.write("\n");
                writer.write("File 2: " + cc.getSecondUnit().fileName + " Tier 2: " + cc.getSecondUnit().tierName);
                writer.write("\n");
                writer.write("Number of annotations 2: " + cc.getSecondUnit().annotations.size());
                StaccatoData stacData = this.resultMap.get(cc);
                if (stacData != null) {
                    writer.write("\n");
                    writer.write(stacData.getResultString());
                } else {
                    writer.write("\n");
                    writer.write("Degree of Organization: " + decFormat.format(cc.getOverallAgreement()));
                    writer.write("\n");
                }
                writer.write("==========");
                writer.write("\n\n");
                ++totalCount;
                totalAgr += cc.getOverallAgreement();
            }
            if (totalCount > 0) {
                writer.write("Overall average Degree of Organization: " + decFormat.format(totalAgr / (double)totalCount));
            } else {
                writer.write("There is no overall average Degree of Organization avaialable: no tier combinations found.");
            }
        }
        catch (Exception ex) {
            throw new IOException("Cannot write to file: " + ex.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private class StacProcListener
    implements StaccatoListener {
        int lastEvent;

        private StacProcListener() {
        }

        public void reactOnStaccatoEvent(StaccatoListener.StaccatoEvent se) {
            this.lastEvent = se.getEvent();
        }
    }
}

