/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.tier.TierCopier;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class CopyTierCommand
implements UndoableCommand,
ClientLogger {
    private ArrayList<ProgressListener> listeners;
    private String commandName;
    private TranscriptionImpl transcription;
    private String tierName;
    private String newParentName;
    private String lingType;
    private TierImpl tier;
    private TierImpl parent;
    private LinguisticType destType;
    private Map<String, String> oldNameToNewName;
    private ArrayList<TierImpl> newTiers;
    private List<DefaultMutableTreeNode> copiedAnnotationsNodes;
    private int transitionType;
    private boolean groupWiseCopying = false;
    private boolean includeDepTiers = true;
    private boolean renameOriginalTiers = false;
    private Map<String, String> renamedSourceTierName;

    public CopyTierCommand(String theName) {
        this.commandName = theName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.tierName = (String)arguments[0];
        this.newParentName = (String)arguments[1];
        this.lingType = (String)arguments[2];
        if (arguments.length >= 4) {
            this.includeDepTiers = (Boolean)arguments[3];
        }
        if (arguments.length >= 5) {
            this.renameOriginalTiers = (Boolean)arguments[4];
        }
        this.tier = this.transcription.getTierWithId(this.tierName);
        this.parent = this.newParentName == null || "-".equals(this.newParentName) ? null : this.transcription.getTierWithId(this.newParentName);
        this.destType = this.transcription.getLinguisticTypeByName(this.lingType);
        if (this.tier == null) {
            this.progressInterrupt("No valid tier found");
            return;
        }
        if (this.destType == null) {
            this.progressInterrupt("No valid LinguisticType found");
            return;
        }
        CopyThread copyThread = new CopyThread(CopyTierCommand.class.getName());
        try {
            copyThread.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.transcription.setNotifying(true);
            this.progressInterrupt("An exception occurred: " + ex.getMessage());
        }
    }

    @Override
    public void undo() {
        if (this.transcription != null && this.newTiers != null) {
            for (int i = this.newTiers.size() - 1; i >= 0; --i) {
                this.transcription.removeTier(this.newTiers.get(i));
            }
        }
        if (this.renameOriginalTiers) {
            for (Map.Entry<String, String> e : this.renamedSourceTierName.entrySet()) {
                String origName = e.getKey();
                String renamed = e.getValue();
                TierImpl tier = this.transcription.getTierWithId(renamed);
                if (tier == null) continue;
                tier.setName(origName);
            }
        }
    }

    @Override
    public void redo() {
        if (this.transcription != null && this.newTiers != null) {
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.setWaitCursor(true);
            if (this.renameOriginalTiers) {
                for (Map.Entry<String, String> e : this.renamedSourceTierName.entrySet()) {
                    String origName = e.getKey();
                    String renamed = e.getValue();
                    TierImpl tier = this.transcription.getTierWithId(origName);
                    if (tier == null) continue;
                    tier.setName(renamed);
                }
            }
            String newName = this.getNameOfCopy();
            TierImpl tierCopy = null;
            for (TierImpl coptier : this.newTiers) {
                String name = coptier.getName();
                if (this.transcription.getTierWithId(name) == null) {
                    this.transcription.addTier(coptier);
                }
                if (!name.equals(newName)) continue;
                tierCopy = coptier;
            }
            if (tierCopy != null && !this.copiedAnnotationsNodes.isEmpty()) {
                this.transcription.setNotifying(false);
                if (this.tier.hasParentTier()) {
                    AnnotationRecreator.createAnnotationsSequentially(this.transcription, this.copiedAnnotationsNodes, true);
                } else {
                    for (DefaultMutableTreeNode node : this.copiedAnnotationsNodes) {
                        AnnotationRecreator.createAnnotationFromTree(this.transcription, node, true);
                    }
                }
                this.transcription.setNotifying(true);
            }
            this.setWaitCursor(false);
            this.transcription.setTimeChangePropagationMode(curPropMode);
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (pl != null && this.listeners != null) {
            this.listeners.remove(pl);
        }
    }

    private void progressUpdate(int percent, String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressUpdated(this, percent, message);
            }
        }
    }

    private void progressComplete(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressCompleted(this, message);
            }
        }
    }

    private void progressInterrupt(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressInterrupted(this, message);
            }
        }
    }

    private String getNameOfCopy() {
        return this.renameOriginalTiers ? this.tierName : this.oldNameToNewName.get(this.tierName);
    }

    class CopyThread
    extends Thread {
        private ArrayList<Serializable> annotationsNodes;

        public CopyThread() {
        }

        public CopyThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            try {
                this.checkTransitionType();
                this.copyTiers();
                this.storeAnnotations();
                this.createCopiesOfAnnotations();
                this.storeCopiedAnnotations();
                CopyTierCommand.this.progressComplete("Operation complete...");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                CopyTierCommand.this.progressComplete("Operation failed...");
            }
        }

        @Override
        public void interrupt() {
            super.interrupt();
            CopyTierCommand.this.progressInterrupt("Operation interrupted...");
        }

        private void checkTransitionType() {
            CopyTierCommand.this.progressUpdate(5, "Checking LinguisticType transition...");
            int oldStereo = -1;
            int destStereo = -1;
            if (CopyTierCommand.this.tier.getLinguisticType().getConstraints() != null) {
                oldStereo = CopyTierCommand.this.tier.getLinguisticType().getConstraints().getStereoType();
            }
            if (CopyTierCommand.this.destType.getConstraints() != null) {
                destStereo = CopyTierCommand.this.destType.getConstraints().getStereoType();
            }
            if (oldStereo == destStereo) {
                CopyTierCommand.this.transitionType = 0;
            }
            block0 : switch (oldStereo) {
                case -1: {
                    switch (destStereo) {
                        case -1: {
                            CopyTierCommand.this.transitionType = 0;
                            break;
                        }
                        case 0: {
                            CopyTierCommand.this.transitionType = 2;
                            break;
                        }
                        case 3: {
                            CopyTierCommand.this.transitionType = 3;
                            break;
                        }
                        case 4: {
                            CopyTierCommand.this.transitionType = 4;
                            break;
                        }
                        case 1: {
                            CopyTierCommand.this.transitionType = 11;
                        }
                    }
                    break;
                }
                case 0: {
                    switch (destStereo) {
                        case -1: {
                            CopyTierCommand.this.transitionType = 1;
                            break;
                        }
                        case 0: {
                            CopyTierCommand.this.transitionType = 0;
                            break;
                        }
                        case 3: {
                            CopyTierCommand.this.transitionType = 5;
                            break;
                        }
                        case 4: {
                            CopyTierCommand.this.transitionType = 6;
                            break;
                        }
                        case 1: {
                            CopyTierCommand.this.transitionType = 12;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (destStereo) {
                        case -1: {
                            CopyTierCommand.this.transitionType = 1;
                            break;
                        }
                        case 0: {
                            CopyTierCommand.this.transitionType = 7;
                            break;
                        }
                        case 3: {
                            CopyTierCommand.this.transitionType = 0;
                            break;
                        }
                        case 4: {
                            CopyTierCommand.this.transitionType = 8;
                            break;
                        }
                        case 1: {
                            CopyTierCommand.this.transitionType = 13;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (destStereo) {
                        case -1: {
                            CopyTierCommand.this.transitionType = 1;
                            break;
                        }
                        case 0: {
                            CopyTierCommand.this.transitionType = 9;
                            break;
                        }
                        case 3: {
                            CopyTierCommand.this.transitionType = 10;
                            break;
                        }
                        case 4: {
                            CopyTierCommand.this.transitionType = 0;
                            break;
                        }
                        case 1: {
                            CopyTierCommand.this.transitionType = 14;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (destStereo) {
                        case -1: {
                            CopyTierCommand.this.transitionType = 1;
                            break block0;
                        }
                        case 0: {
                            CopyTierCommand.this.transitionType = 15;
                            break block0;
                        }
                        case 3: {
                            CopyTierCommand.this.transitionType = 16;
                            break block0;
                        }
                        case 4: {
                            CopyTierCommand.this.transitionType = 14;
                            break block0;
                        }
                        case 1: {
                            CopyTierCommand.this.transitionType = 0;
                        }
                    }
                }
            }
            if (CopyTierCommand.this.parent != null && CopyTierCommand.this.parent != CopyTierCommand.this.tier) {
                int stereo = CopyTierCommand.this.destType.getConstraints().getStereoType();
                if (CopyTierCommand.this.transitionType == 0 && (stereo == 0 || stereo == 3) || CopyTierCommand.this.transitionType != 1 && CopyTierCommand.this.transitionType != 4 && CopyTierCommand.this.transitionType != 3 && CopyTierCommand.this.transitionType != 2 && CopyTierCommand.this.transitionType != 11) {
                    CopyTierCommand.this.groupWiseCopying = true;
                }
            }
        }

        private void copyTiers() {
            TierImpl ti;
            int i;
            CopyTierCommand.this.progressUpdate(10, "Copying tier(s)");
            List<TierImpl> depTiers = CopyTierCommand.this.tier.getDependentTiers();
            if (!CopyTierCommand.this.includeDepTiers) {
                depTiers = new ArrayList<TierImpl>();
            }
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(CopyTierCommand.this.tier);
            int numDepTiers = depTiers.size();
            DefaultMutableTreeNode[] nodes = new DefaultMutableTreeNode[numDepTiers];
            HashMap<TierImpl, DefaultMutableTreeNode> nodeMap = new HashMap<TierImpl, DefaultMutableTreeNode>();
            for (i = 0; i < numDepTiers; ++i) {
                ti = depTiers.get(i);
                nodes[i] = new DefaultMutableTreeNode(ti);
                nodeMap.put(ti, nodes[i]);
            }
            for (i = 0; i < numDepTiers; ++i) {
                ti = depTiers.get(i);
                if (ti.getParentTier() == CopyTierCommand.this.tier) {
                    rootNode.add(nodes[i]);
                    continue;
                }
                DefaultMutableTreeNode dn = (DefaultMutableTreeNode)nodeMap.get(ti.getParentTier());
                if (dn == null) continue;
                dn.add(nodes[i]);
            }
            CopyTierCommand.this.oldNameToNewName = new HashMap();
            CopyTierCommand.this.newTiers = new ArrayList();
            if (CopyTierCommand.this.renameOriginalTiers) {
                CopyTierCommand.this.renamedSourceTierName = new HashMap();
            }
            Enumeration<TreeNode> en = rootNode.breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                String newName;
                DefaultMutableTreeNode dn = (DefaultMutableTreeNode)en.nextElement();
                TierImpl to = (TierImpl)dn.getUserObject();
                if (CopyTierCommand.this.renameOriginalTiers) {
                    String origTierNewName = this.getUniqueName(to.getName(), "orig");
                    newName = to.getName();
                    to.setName(origTierNewName);
                    CopyTierCommand.this.renamedSourceTierName.put(newName, origTierNewName);
                } else {
                    newName = this.getUniqueName(to.getName(), "cp");
                }
                CopyTierCommand.this.oldNameToNewName.put(to.getName(), newName);
                LinguisticType nextType = to.getLinguisticType();
                if (to == CopyTierCommand.this.tier) {
                    nextType = CopyTierCommand.this.destType;
                } else {
                    LinguisticType curType = to.getLinguisticType();
                    int stereo = -1;
                    if (curType.getConstraints() != null) {
                        stereo = curType.getConstraints().getStereoType();
                    }
                    switch (CopyTierCommand.this.transitionType) {
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 16: 
                        case 17: {
                            if (stereo != 0) break;
                            nextType = CopyTierCommand.this.destType;
                            break;
                        }
                        case 8: {
                            if (stereo == 4) break;
                            nextType = CopyTierCommand.this.destType;
                        }
                    }
                }
                TierImpl pt = null;
                if (dn.getParent() != null) {
                    String oldParentName = ((TierImpl)((DefaultMutableTreeNode)dn.getParent()).getUserObject()).getName();
                    String newPName = (String)CopyTierCommand.this.oldNameToNewName.get(oldParentName);
                    pt = CopyTierCommand.this.transcription.getTierWithId(newPName);
                } else if (to == CopyTierCommand.this.tier) {
                    pt = CopyTierCommand.this.parent;
                }
                TierImpl tn = pt != null ? new TierImpl(pt, newName, to.getParticipant(), CopyTierCommand.this.transcription, nextType) : new TierImpl(newName, to.getParticipant(), CopyTierCommand.this.transcription, nextType);
                tn.setDefaultLocale(to.getDefaultLocale());
                tn.setAnnotator(to.getAnnotator());
                tn.setLangRef(to.getLangRef());
                CopyTierCommand.this.newTiers.add(tn);
                CopyTierCommand.this.transcription.addTier(tn);
            }
            CopyTierCommand.this.progressUpdate(20, "Tier(s) copied");
        }

        private void storeAnnotations() {
            CopyTierCommand.this.progressUpdate(20, "Copying annotations...");
            int progForThis = 30;
            this.annotationsNodes = new ArrayList();
            List<AbstractAnnotation> annos = CopyTierCommand.this.tier.getAnnotations();
            float perAnn = 0.0f;
            if (annos.size() > 0) {
                perAnn = (float)progForThis / (float)annos.size();
            }
            int count = 0;
            if (!CopyTierCommand.this.groupWiseCopying) {
                for (AbstractAnnotation ann : annos) {
                    DefaultMutableTreeNode savedNode = CopyTierCommand.this.includeDepTiers ? AnnotationRecreator.createTreeForAnnotation(ann) : AnnotationRecreator.createNodeForAnnotation(ann);
                    this.annotationsNodes.add(savedNode);
                    CopyTierCommand.this.progressUpdate((int)(20.0f + (float)(++count) * perAnn), null);
                }
            } else {
                ArrayList<DefaultMutableTreeNode> group = new ArrayList<DefaultMutableTreeNode>();
                TierImpl rootTier = CopyTierCommand.this.tier.getRootTier();
                Annotation curParent = null;
                for (AbstractAnnotation ann : annos) {
                    DefaultMutableTreeNode savedNode = CopyTierCommand.this.includeDepTiers ? AnnotationRecreator.createTreeForAnnotation(ann) : AnnotationRecreator.createNodeForAnnotation(ann);
                    if (curParent == null) {
                        group.add(savedNode);
                        curParent = rootTier.getAnnotationAtTime(ann.getBeginTimeBoundary());
                    } else if (rootTier.getAnnotationAtTime(ann.getBeginTimeBoundary()) == curParent) {
                        group.add(savedNode);
                    } else {
                        this.annotationsNodes.add(group);
                        group = new ArrayList();
                        curParent = rootTier.getAnnotationAtTime(ann.getBeginTimeBoundary());
                        group.add(savedNode);
                    }
                    CopyTierCommand.this.progressUpdate((int)(20.0f + (float)(++count) * perAnn), null);
                }
                if (!group.isEmpty()) {
                    this.annotationsNodes.add(group);
                }
            }
        }

        private void createCopiesOfAnnotations() {
            int numAnnotationsNodes;
            CopyTierCommand.this.progressUpdate(60, "Creating new annotations...");
            int progForThis = 30;
            int curPropMode = 0;
            curPropMode = CopyTierCommand.this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                CopyTierCommand.this.transcription.setTimeChangePropagationMode(0);
            }
            if ((numAnnotationsNodes = this.annotationsNodes.size()) > 0) {
                float perAnn = (float)progForThis / (float)numAnnotationsNodes;
                int count = 0;
                CopyTierCommand.this.transcription.setNotifying(false);
                TierCopier copier = new TierCopier();
                if (CopyTierCommand.this.parent != null) {
                    if (CopyTierCommand.this.groupWiseCopying) {
                        for (int i = 0; i < numAnnotationsNodes; ++i) {
                            ArrayList group = (ArrayList)this.annotationsNodes.get(i);
                            copier.createAnnotationsSequentially(CopyTierCommand.this.transcription, group, CopyTierCommand.this.oldNameToNewName);
                            CopyTierCommand.this.progressUpdate((int)(50.0f + (float)(++count) * perAnn), null);
                        }
                    } else {
                        for (int i = 0; i < numAnnotationsNodes; ++i) {
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.annotationsNodes.get(i);
                            copier.createAnnotationFromTree(CopyTierCommand.this.transcription, node, CopyTierCommand.this.oldNameToNewName);
                            CopyTierCommand.this.progressUpdate((int)(50.0f + (float)(++count) * perAnn), null);
                        }
                    }
                } else {
                    for (int i = 0; i < numAnnotationsNodes; ++i) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.annotationsNodes.get(i);
                        copier.createRootAnnotationFromTree(CopyTierCommand.this.transcription, node, CopyTierCommand.this.oldNameToNewName);
                        CopyTierCommand.this.progressUpdate((int)(50.0f + (float)(++count) * perAnn), null);
                    }
                }
                CopyTierCommand.this.transcription.setNotifying(true);
            }
            CopyTierCommand.this.transcription.setTimeChangePropagationMode(curPropMode);
        }

        private void storeCopiedAnnotations() {
            CopyTierCommand.this.progressUpdate(80, "Storing information for undo/redo...");
            int progForThis = 20;
            String newName = CopyTierCommand.this.getNameOfCopy();
            TierImpl tierCopy = null;
            for (TierImpl t : CopyTierCommand.this.newTiers) {
                if (!t.getName().equals(newName)) continue;
                tierCopy = t;
                break;
            }
            if (tierCopy != null) {
                List<AbstractAnnotation> annos = tierCopy.getAnnotations();
                CopyTierCommand.this.copiedAnnotationsNodes = new ArrayList(annos.size());
                float perAnn = (float)progForThis / (float)annos.size();
                int count = 0;
                for (AbstractAnnotation ann : annos) {
                    CopyTierCommand.this.copiedAnnotationsNodes.add(AnnotationRecreator.createTreeForAnnotation(ann));
                    CopyTierCommand.this.progressUpdate((int)(80.0f + (float)(++count) * perAnn), null);
                }
            }
        }

        private String getUniqueName(String name, String suffix) {
            String nName = name + "-" + suffix;
            if (CopyTierCommand.this.transcription.getTierWithId(nName) != null) {
                for (int i = 1; i < 50; ++i) {
                    nName = nName + "-" + i;
                    if (CopyTierCommand.this.transcription.getTierWithId(nName) != null) continue;
                    return nName;
                }
            }
            return nName;
        }
    }
}

