/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class CopyToNextAnnotationCA
extends CommandAction {
    private Annotation currentAnnot = null;
    private Annotation newAnnot = null;

    public CopyToNextAnnotationCA(ViewerManager2 theVM) {
        super(theVM, "CommandActions.CopyToNextAnnotation");
        this.putValue("Default", "COPY_TO_NEXT_ANNOTATION");
        this.putValue("Name", "");
    }

    @Override
    protected void newCommand() {
        Annotation[] activeAnnotations = this.retrieveAnnotations();
        this.currentAnnot = activeAnnotations[0];
        this.newAnnot = activeAnnotations[1];
        this.command = this.currentAnnot != null ? ELANCommandFactory.createCommand(this.vm.getTranscription(), "CommandActions.CopyToNextAnnotation") : null;
    }

    @Override
    protected Object getReceiver() {
        return this.vm;
    }

    @Override
    protected Object[] getArguments() {
        List<Annotation> simultaneousAnnotations = this.getSimultaneousAnnotations(this.currentAnnot);
        Object[] args = new Object[]{this.newAnnot, this.currentAnnot, simultaneousAnnotations};
        return args;
    }

    private void extractRootTiers(TranscriptionImpl transcription, List<TierImpl> rootTiers) {
        List<TierImpl> tiers;
        if (transcription != null && (tiers = transcription.getTiers()) != null) {
            Iterator<TierImpl> tierIt = tiers.iterator();
            TierImpl tier = null;
            while (tierIt.hasNext()) {
                tier = tierIt.next();
                if (tier.getLinguisticType().getConstraints() != null) continue;
                rootTiers.add(tier);
            }
        }
    }

    private Annotation[] retrieveAnnotations() {
        TierImpl currentTier;
        Annotation currentActiveAnnot = this.vm.getActiveAnnotation().getAnnotation();
        Annotation newActiveAnnot = null;
        if (currentActiveAnnot != null) {
            newActiveAnnot = ((TierImpl)currentActiveAnnot.getTier()).getAnnotationAfter(currentActiveAnnot);
        } else {
            TierImpl activeTier = (TierImpl)this.vm.getMultiTierControlPanel().getActiveTier();
            if (activeTier != null) {
                currentActiveAnnot = activeTier.getAnnotationAtTime(this.vm.getMasterMediaPlayer().getMediaTime());
                newActiveAnnot = activeTier.getAnnotationAfter(currentActiveAnnot);
            }
        }
        if (newActiveAnnot == null) {
            currentActiveAnnot = null;
        }
        if (currentActiveAnnot != null && (currentTier = (TierImpl)currentActiveAnnot.getTier()).getLinguisticType().getConstraints() != null) {
            currentActiveAnnot = null;
            newActiveAnnot = null;
        }
        Annotation[] activeAnnotations = new Annotation[]{currentActiveAnnot, newActiveAnnot};
        return activeAnnotations;
    }

    private List<Annotation> getSimultaneousAnnotations(Annotation currentActiveAnnot) {
        ArrayList<TierImpl> rootTiers = new ArrayList<TierImpl>();
        this.extractRootTiers((TranscriptionImpl)this.vm.getTranscription(), rootTiers);
        ArrayList<Annotation> simultaneousAnnotations = null;
        if (currentActiveAnnot != null) {
            TierImpl currentTier = (TierImpl)currentActiveAnnot.getTier();
            simultaneousAnnotations = new ArrayList<Annotation>();
            for (TierImpl tier : rootTiers) {
                Annotation ann;
                if (currentTier.getName().equals(tier.getName()) || (ann = tier.getAnnotationAtTime(this.vm.getMasterMediaPlayer().getMediaTime())) == null) continue;
                simultaneousAnnotations.add(ann);
            }
        }
        return simultaneousAnnotations;
    }
}

